/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/OptionalAbstractKeyword;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "handleAbstractKeyword", "", "dcl", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "visitClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nOptionalAbstractKeyword.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptionalAbstractKeyword.kt\nio/gitlab/arturbosch/detekt/rules/style/OptionalAbstractKeyword\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,65:1\n1855#2,2:66\n158#3:68\n13309#4,2:69\n*S KotlinDebug\n*F\n+ 1 OptionalAbstractKeyword.kt\nio/gitlab/arturbosch/detekt/rules/style/OptionalAbstractKeyword\n*L\n52#1:66,2\n53#1:68\n53#1:69,2\n*E\n"})
public final class OptionalAbstractKeyword
extends Rule {
    @NotNull
    private final Issue issue;

    public OptionalAbstractKeyword(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Unnecessary abstract modifier in interface detected. This abstract modifier is unnecessary and thus can be removed.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ OptionalAbstractKeyword(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (klass.isInterface()) {
            this.handleAbstractKeyword((KtDeclaration)klass);
            KtClassBody body = klass.getBody();
            if (body != null) {
                PsiElement[] $this$forEach$iv = (PsiElement[])body.getProperties();
                boolean $i$f$forEach = false;
                for (Object t : $this$forEach$iv) {
                    KtProperty it = (KtProperty)t;
                    boolean bl = false;
                    this.handleAbstractKeyword((KtDeclaration)it);
                }
                PsiElement $this$getChildrenOfType$iv = (PsiElement)body;
                boolean $i$f$getChildrenOfType = false;
                PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KtNamedFunction.class);
                if (psiElementArray == null) {
                    psiElementArray = (PsiElement[])new KtNamedFunction[0];
                }
                $this$forEach$iv = psiElementArray;
                $i$f$forEach = false;
                for (PsiElement element$iv : $this$forEach$iv) {
                    KtNamedFunction it = (KtNamedFunction)element$iv;
                    boolean bl = false;
                    this.handleAbstractKeyword((KtDeclaration)it);
                }
            }
        }
        super.visitClass(klass);
    }

    private final void handleAbstractKeyword(KtDeclaration dcl) {
        block0: {
            KtModifierList ktModifierList = dcl.getModifierList();
            if (ktModifierList == null || (ktModifierList = ktModifierList.getModifier(KtTokens.ABSTRACT_KEYWORD)) == null) break block0;
            KtModifierList it = ktModifierList;
            boolean bl = false;
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)it, (int)0, (int)2, null), "The abstract keyword on this declaration is unnecessary.", null, null, 24, null));
        }
    }

    public OptionalAbstractKeyword() {
        this(null, 1, null);
    }
}

