/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/Section;", "", "priority", "", "(I)V", "getPriority", "()I", "compareTo", "other", "toDescription", "", "detekt-rules-style"})
final class Section
implements Comparable<Section> {
    private final int priority;

    public Section(int priority) {
        this.priority = priority;
        int n = this.priority;
        if (!(0 <= n ? n < 4 : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int getPriority() {
        return this.priority;
    }

    @NotNull
    public final String toDescription() {
        String string;
        switch (this.priority) {
            case 0: {
                string = "property declarations and initializer blocks";
                break;
            }
            case 1: {
                string = "secondary constructors";
                break;
            }
            case 2: {
                string = "method declarations";
                break;
            }
            case 3: {
                string = "companion object";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Override
    public int compareTo(@NotNull Section other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.compare((int)this.priority, (int)other.priority);
    }
}

