/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.style.StringShouldBeRawString;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.NavigatablePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0001+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\u0004\u0018\u00010#*\u00020$H\u0002J\u000e\u0010%\u001a\u0004\u0018\u00010\u0019*\u00020\u0019H\u0002J\u0012\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00070'*\u00020\u0019H\u0002J\u0014\u0010(\u001a\u00020)*\u00020!2\u0006\u0010*\u001a\u00020\u0019H\u0002R'\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0012\u001a\u00020\u00138BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\r\u0012\u0004\b\u0014\u0010\t\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0018\u001a\u00020\u0019*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u001c\u001a\u00020\u0019*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001b\u00a8\u0006,"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/StringShouldBeRawString;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "ignoredCharacters", "", "", "getIgnoredCharacters$annotations", "()V", "getIgnoredCharacters", "()Ljava/util/List;", "ignoredCharacters$delegate", "Lkotlin/properties/ReadOnlyProperty;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "maxEscapedCharacterCount", "", "getMaxEscapedCharacterCount$annotations", "getMaxEscapedCharacterCount", "()I", "maxEscapedCharacterCount$delegate", "leftMostElementOfLeftSubtree", "Lorg/jetbrains/kotlin/psi/KtElement;", "getLeftMostElementOfLeftSubtree", "(Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/psi/KtElement;", "rightMostElementOfRightSubtree", "getRightMostElementOfRightSubtree", "visitStringTemplateExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "getParentExpressionAfterParenthesis", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getRootExpression", "getStringSequenceExcludingRawString", "Lkotlin/sequences/Sequence;", "isPivotElementInTheTree", "", "rootElement", "Companion", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nStringShouldBeRawString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringShouldBeRawString.kt\nio/gitlab/arturbosch/detekt/rules/style/StringShouldBeRawString\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,176:1\n125#2:177\n*S KotlinDebug\n*F\n+ 1 StringShouldBeRawString.kt\nio/gitlab/arturbosch/detekt/rules/style/StringShouldBeRawString\n*L\n87#1:177\n*E\n"})
public final class StringShouldBeRawString
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty maxEscapedCharacterCount$delegate;
    @NotNull
    private final ReadOnlyProperty ignoredCharacters$delegate;
    @NotNull
    private static final Regex REGEX_FOR_ESCAPE_CHARS;
    @NotNull
    private static final List<String> listOfAllowedMethod;
    @NotNull
    private static final Regex regexForOnlyQuotes;

    public StringShouldBeRawString(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "The string can be converted to raw string.", Debt.Companion.getFIVE_MINS());
        this.maxEscapedCharacterCount$delegate = ConfigPropertyKt.config((Object)2);
        this.ignoredCharacters$delegate = ConfigPropertyKt.config((Object)CollectionsKt.emptyList());
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getMaxEscapedCharacterCount() {
        return ((Number)this.maxEscapedCharacterCount$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="maximum escape characters allowed")
    private static /* synthetic */ void getMaxEscapedCharacterCount$annotations() {
    }

    private final List<String> getIgnoredCharacters() {
        return (List)this.ignoredCharacters$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="list of characters to ignore")
    private static /* synthetic */ void getIgnoredCharacters$annotations() {
    }

    private final KtElement getLeftMostElementOfLeftSubtree(KtElement $this$leftMostElementOfLeftSubtree) {
        KtBinaryExpression ktBinaryExpression = $this$leftMostElementOfLeftSubtree instanceof KtBinaryExpression ? (KtBinaryExpression)$this$leftMostElementOfLeftSubtree : null;
        if (ktBinaryExpression == null || (ktBinaryExpression = ktBinaryExpression.getLeft()) == null || (ktBinaryExpression = KotlinUtilsKt.deparenthesize((KtElement)((KtElement)ktBinaryExpression))) == null) {
            return $this$leftMostElementOfLeftSubtree;
        }
        KtBinaryExpression leftChild = ktBinaryExpression;
        return this.getLeftMostElementOfLeftSubtree((KtElement)leftChild);
    }

    private final KtElement getRightMostElementOfRightSubtree(KtElement $this$rightMostElementOfRightSubtree) {
        KtBinaryExpression ktBinaryExpression = $this$rightMostElementOfRightSubtree instanceof KtBinaryExpression ? (KtBinaryExpression)$this$rightMostElementOfRightSubtree : null;
        if (ktBinaryExpression == null || (ktBinaryExpression = ktBinaryExpression.getRight()) == null || (ktBinaryExpression = KotlinUtilsKt.deparenthesize((KtElement)((KtElement)ktBinaryExpression))) == null) {
            return $this$rightMostElementOfRightSubtree;
        }
        KtBinaryExpression leftChild = ktBinaryExpression;
        return this.getRightMostElementOfRightSubtree((KtElement)leftChild);
    }

    public void visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression) {
        CharSequence $this$getParentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitStringTemplateExpression(expression);
        PsiElement psiElement = (PsiElement)expression;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        KtCallExpression callExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtCallExpression.class, (boolean)strict$iv);
        KtCallExpression ktCallExpression = callExpression;
        if (CollectionsKt.contains((Iterable)listOfAllowedMethod, ktCallExpression != null && (ktCallExpression = ktCallExpression.getCalleeExpression()) != null ? ktCallExpression.getText() : null)) {
            return;
        }
        String string = expression.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        $this$getParentOfType$iv = string;
        if (regexForOnlyQuotes.matches($this$getParentOfType$iv)) {
            return;
        }
        PsiElement expressionParent = this.getParentExpressionAfterParenthesis((KtExpression)expression);
        Sequence rootElement = this.getRootExpression((KtElement)expression);
        if (!(expressionParent instanceof KtBinaryExpression) || rootElement != null && this.isPivotElementInTheTree(expression, (KtElement)rootElement)) {
            Sequence stringSeqToProcess;
            boolean hasNoViolations2;
            Sequence sequence = rootElement;
            if (sequence == null || (sequence = this.getStringSequenceExcludingRawString((KtElement)sequence)) == null) {
                Object[] objectArray = new String[]{""};
                sequence = SequencesKt.sequenceOf((Object[])objectArray);
            }
            if (!(hasNoViolations2 = SequencesKt.none((Sequence)SequencesKt.drop((Sequence)SequencesKt.flatMap((Sequence)(stringSeqToProcess = sequence), (Function1)((Function1)new Function1<String, Sequence<? extends MatchResult>>(this){
                final /* synthetic */ StringShouldBeRawString this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Sequence<MatchResult> invoke(@NotNull String stringTemplateExpressionText) {
                    Intrinsics.checkNotNullParameter((Object)stringTemplateExpressionText, (String)"stringTemplateExpressionText");
                    return SequencesKt.filter((Sequence)Regex.findAll$default((Regex)StringShouldBeRawString.access$getREGEX_FOR_ESCAPE_CHARS$cp(), (CharSequence)stringTemplateExpressionText, (int)0, (int)2, null), (Function1)((Function1)new Function1<MatchResult, Boolean>(this.this$0){
                        final /* synthetic */ StringShouldBeRawString this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull MatchResult it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return !StringShouldBeRawString.access$getIgnoredCharacters(this.this$0).contains(it.getValue());
                        }
                    }));
                }
            })), (int)this.getMaxEscapedCharacterCount())))) {
                Issue issue = this.getIssue();
                Sequence sequence2 = rootElement;
                if (sequence2 == null) {
                    sequence2 = (KtElement)expression;
                }
                this.report((Finding)new CodeSmell(issue, Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)sequence2), (int)0, (int)2, null), "String with escape characters should be converted to raw string", null, null, 24, null));
            }
        }
    }

    private final boolean isPivotElementInTheTree(KtStringTemplateExpression $this$isPivotElementInTheTree, KtElement rootElement) {
        KtElement leftMostElementOfLeftSubtree = this.getLeftMostElementOfLeftSubtree(rootElement);
        return Intrinsics.areEqual((Object)$this$isPivotElementInTheTree, (Object)(leftMostElementOfLeftSubtree instanceof KtStringTemplateExpression ? leftMostElementOfLeftSubtree : this.getRightMostElementOfRightSubtree(rootElement)));
    }

    private final Sequence<String> getStringSequenceExcludingRawString(KtElement $this$getStringSequenceExcludingRawString) {
        return SequencesKt.map((Sequence)SequencesKt.filter(StringShouldBeRawString.getStringSequenceExcludingRawString$getStringSequence($this$getStringSequenceExcludingRawString), (Function1)getStringSequenceExcludingRawString.1.INSTANCE), (Function1)getStringSequenceExcludingRawString.2.INSTANCE);
    }

    private final PsiElement getParentExpressionAfterParenthesis(KtExpression $this$getParentExpressionAfterParenthesis) {
        Class[] classArray = new Class[]{PsiElement.class};
        return PsiUtilsKt.getParentOfTypesAndPredicate((PsiElement)((PsiElement)$this$getParentExpressionAfterParenthesis), (boolean)true, (Class[])classArray, (Function1)getParentExpressionAfterParenthesis.1.INSTANCE);
    }

    private final KtElement getRootExpression(KtElement $this$getRootExpression) {
        Class[] classArray = new Class[]{KtBinaryExpression.class, KtParenthesizedExpression.class, KtStringTemplateExpression.class};
        NavigatablePsiElement navigatablePsiElement = (NavigatablePsiElement)PsiUtilsKt.getParentOfTypesAndPredicate((PsiElement)((PsiElement)$this$getRootExpression), (boolean)false, (Class[])classArray, (Function1)getRootExpression.1.INSTANCE);
        return navigatablePsiElement != null ? KotlinUtilsKt.deparenthesize((KtElement)((KtElement)navigatablePsiElement)) : null;
    }

    private static final Sequence<KtStringTemplateExpression> getStringSequenceExcludingRawString$getStringSequence(KtElement $this$getStringSequenceExcludingRawString_u24getStringSequence) {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super KtStringTemplateExpression>, Continuation<? super Unit>, Object>($this$getStringSequenceExcludingRawString_u24getStringSequence, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ KtElement $this_getStringSequence;
            {
                this.$this_getStringSequence = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                block11: {
                    Object object2;
                    KtExpression it;
                    void $result;
                    SequenceScope $this$sequence;
                    Object object3;
                    block12: {
                        Object object4;
                        boolean bl;
                        object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                $this$sequence = (SequenceScope)this.L$0;
                                if (!(this.$this_getStringSequence instanceof KtStringTemplateExpression)) break;
                                this.label = 1;
                                Object object5 = $this$sequence.yield((Object)this.$this_getStringSequence, (Continuation)this);
                                if (object5 == object3) {
                                    return object3;
                                }
                                break;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object5 = $result;
                                break;
                            }
                        }
                        if (!(this.$this_getStringSequence instanceof KtBinaryExpression)) break block11;
                        KtExpression ktExpression = ((KtBinaryExpression)this.$this_getStringSequence).getLeft();
                        if (ktExpression != null) {
                            it = ktExpression;
                            bl = false;
                            this.L$0 = $this$sequence;
                            this.label = 2;
                            object4 = $this$sequence.yieldAll(StringShouldBeRawString.access$getStringSequenceExcludingRawString$getStringSequence(KotlinUtilsKt.deparenthesize((KtElement)((KtElement)it))), (Continuation)this);
                            if (object4 == object3) {
                                return object3;
                            }
                        }
                        break block12;
                        {
                            case 2: {
                                bl = false;
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                object4 = $result;
                            }
                        }
                    }
                    KtExpression ktExpression = ((KtBinaryExpression)this.$this_getStringSequence).getRight();
                    if (ktExpression != null) {
                        it = ktExpression;
                        boolean bl = false;
                        this.L$0 = null;
                        this.label = 3;
                        object2 = $this$sequence.yieldAll(StringShouldBeRawString.access$getStringSequenceExcludingRawString$getStringSequence(KotlinUtilsKt.deparenthesize((KtElement)((KtElement)it))), (Continuation)this);
                        if (object2 == object3) {
                            return object3;
                        }
                    }
                    break block11;
                    {
                        case 3: {
                            boolean bl = false;
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                        }
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super KtStringTemplateExpression>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super KtStringTemplateExpression> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public static final /* synthetic */ Regex access$getREGEX_FOR_ESCAPE_CHARS$cp() {
        return REGEX_FOR_ESCAPE_CHARS;
    }

    public static final /* synthetic */ List access$getIgnoredCharacters(StringShouldBeRawString $this) {
        return $this.getIgnoredCharacters();
    }

    public static final /* synthetic */ Sequence access$getStringSequenceExcludingRawString$getStringSequence(KtElement $receiver) {
        return StringShouldBeRawString.getStringSequenceExcludingRawString$getStringSequence($receiver);
    }

    static {
        Object[] objectArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(StringShouldBeRawString.class, "maxEscapedCharacterCount", "getMaxEscapedCharacterCount()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(StringShouldBeRawString.class, "ignoredCharacters", "getIgnoredCharacters()Ljava/util/List;", 0)))};
        $$delegatedProperties = objectArray;
        Companion = new Companion(null);
        REGEX_FOR_ESCAPE_CHARS = new Regex("\\\\[t\"\\\\n]");
        objectArray = new String[]{"replaceIndent", "prependIndent"};
        listOfAllowedMethod = CollectionsKt.listOf((Object[])objectArray);
        regexForOnlyQuotes = new Regex("\"(?:\\\\\")*\"");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/StringShouldBeRawString$Companion;", "", "()V", "REGEX_FOR_ESCAPE_CHARS", "Lkotlin/text/Regex;", "listOfAllowedMethod", "", "", "regexForOnlyQuotes", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

