/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.style.TrimMultilineRawStringKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR'\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u0013\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/TrimMultilineRawString;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "getConfig", "()Lio/gitlab/arturbosch/detekt/api/Config;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "trimmingMethods", "", "", "getTrimmingMethods$annotations", "()V", "getTrimmingMethods", "()Ljava/util/List;", "trimmingMethods$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitStringTemplateExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "detekt-rules-style"})
public final class TrimMultilineRawString
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Config config;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty trimmingMethods$delegate;

    public TrimMultilineRawString(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.config = config;
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Multiline raw strings should be followed by `trimMargin()` or `trimIndent()`.", Debt.Companion.getFIVE_MINS());
        Object[] objectArray = new String[]{"trimIndent", "trimMargin"};
        this.trimmingMethods$delegate = ConfigPropertyKt.config((Object)CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<String> getTrimmingMethods() {
        return (List)this.trimmingMethods$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="allows to provide a list of multiline string trimming methods")
    private static /* synthetic */ void getTrimmingMethods$annotations() {
    }

    public void visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitStringTemplateExpression(expression);
        if (TrimMultilineRawStringKt.isRawStringWithLineBreak(expression) && !TrimMultilineRawStringKt.isTrimmed(expression, this.getTrimmingMethods()) && !TrimMultilineRawStringKt.access$isExpectedAsConstant(expression)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "Multiline raw strings should be followed by `trimMargin()` or `trimIndent()`", null, null, 24, null));
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TrimMultilineRawString.class, "trimmingMethods", "getTrimmingMethods()Ljava/util/List;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

