/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.AnnotationExcluder;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.style.UnnecessaryAbstractClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassMemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@RequiresTypeResolution
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\f\u0010\u001e\u001a\u00020\u0018*\u00020\u001aH\u0002J\"\u0010\u001f\u001a\u00020\u0018*\u00020\u001a2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\b2\u0006\u0010\"\u001a\u00020#H\u0002J\f\u0010$\u001a\u00020%*\u00020\u001aH\u0002J\u0014\u0010&\u001a\u00020%*\u00020\u001a2\u0006\u0010'\u001a\u00020%H\u0002J\f\u0010(\u001a\u00020%*\u00020\u001aH\u0002J$\u0010 \u001a\u001a\u0012\u0016\u0012\u0014 **\t\u0018\u00010!\u00a2\u0006\u0002\b)0!\u00a2\u0006\u0002\b)0\b*\u00020\u001aH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R'\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u0012\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryAbstractClass;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "annotationExcluder", "Lio/gitlab/arturbosch/detekt/api/AnnotationExcluder;", "excludeAnnotatedClasses", "", "Lkotlin/text/Regex;", "getExcludeAnnotatedClasses$annotations", "()V", "getExcludeAnnotatedClasses", "()Ljava/util/List;", "excludeAnnotatedClasses$delegate", "Lkotlin/properties/ReadOnlyProperty;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "noAbstractMember", "", "noConcreteMember", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "check", "checkMembers", "members", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "nameIdentifier", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "hasConstructorParameter", "", "hasInheritedMember", "isAbstract", "isAnyParentAbstract", "Lkotlin/internal/NoInfer;", "kotlin.jvm.PlatformType", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUnnecessaryAbstractClass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnnecessaryAbstractClass.kt\nio/gitlab/arturbosch/detekt/rules/style/UnnecessaryAbstractClass\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,149:1\n3190#2,10:150\n1747#2,3:160\n766#2:174\n857#2,2:175\n1747#2,3:177\n1726#2,3:180\n4098#3,11:163\n*S KotlinDebug\n*F\n+ 1 UnnecessaryAbstractClass.kt\nio/gitlab/arturbosch/detekt/rules/style/UnnecessaryAbstractClass\n*L\n115#1:150,10\n119#1:160,3\n127#1:174\n127#1:175,2\n137#1:177,3\n147#1:180,3\n126#1:163,11\n*E\n"})
public final class UnnecessaryAbstractClass
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final String noConcreteMember;
    @NotNull
    private final String noAbstractMember;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty excludeAnnotatedClasses$delegate;
    private AnnotationExcluder annotationExcluder;

    public UnnecessaryAbstractClass(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.noConcreteMember = "An abstract class without a concrete member can be refactored to an interface.";
        this.noAbstractMember = "An abstract class without an abstract member can be refactored to a concrete class.";
        this.issue = new Issue("UnnecessaryAbstractClass", Severity.Style, "An abstract class is unnecessary. May be refactored to an interface or to a concrete class.", Debt.Companion.getFIVE_MINS());
        this.excludeAnnotatedClasses$delegate = ConfigPropertyKt.config((Object)CollectionsKt.emptyList(), (Function1)excludeAnnotatedClasses.2.INSTANCE);
    }

    public /* synthetic */ UnnecessaryAbstractClass(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<Regex> getExcludeAnnotatedClasses() {
        return (List)this.excludeAnnotatedClasses$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="Allows you to provide a list of annotations that disable this check.")
    @Deprecated(message="Use `ignoreAnnotated` instead")
    private static /* synthetic */ void getExcludeAnnotatedClasses$annotations() {
    }

    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.annotationExcluder = new AnnotationExcluder(file, this.getExcludeAnnotatedClasses(), this.getBindingContext());
        super.visitKtFile(file);
    }

    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        super.visitClass(klass);
        this.check(klass);
    }

    private final void check(KtClass $this$check) {
        PsiElement psiElement = $this$check.getNameIdentifier();
        if (psiElement == null) {
            return;
        }
        PsiElement nameIdentifier = psiElement;
        AnnotationExcluder annotationExcluder = this.annotationExcluder;
        if (annotationExcluder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"annotationExcluder");
            annotationExcluder = null;
        }
        List list = $this$check.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAnnotationEntries(...)");
        if (annotationExcluder.shouldExclude(list) || $this$check.isInterface() || !KtPsiUtilKt.isAbstract((KtClass)$this$check)) {
            return;
        }
        List<KtCallableDeclaration> members = this.members($this$check);
        if (!((Collection)members).isEmpty()) {
            this.checkMembers($this$check, members, nameIdentifier);
        } else {
            if (this.hasInheritedMember($this$check, true) && this.isAnyParentAbstract($this$check)) {
                return;
            }
            if (!this.hasConstructorParameter($this$check)) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)nameIdentifier, (int)0, (int)2, null), this.noConcreteMember, null, null, 24, null));
            } else {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)nameIdentifier, (int)0, (int)2, null), this.noAbstractMember, null, null, 24, null));
            }
        }
    }

    private final void checkMembers(KtClass $this$checkMembers, List<? extends KtCallableDeclaration> members, PsiElement nameIdentifier) {
        KtCallableDeclaration it;
        Iterable $this$partition$iv = members;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            it = (KtCallableDeclaration)element$iv;
            boolean bl = false;
            if (KtModifierListKt.isAbstract((KtModifierListOwner)((KtModifierListOwner)it))) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List abstractMembers = (List)pair.component1();
        List concreteMembers = (List)pair.component2();
        if (abstractMembers.isEmpty() && !this.hasInheritedMember($this$checkMembers, true)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)nameIdentifier, (int)0, (int)2, null), this.noAbstractMember, null, null, 24, null));
        } else {
            boolean bl;
            block8: {
                Iterable $this$any$iv = abstractMembers;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (KtCallableDeclaration)element$iv;
                        boolean bl2 = false;
                        if (!(KtModifierListKt.isInternal((KtModifierListOwner)((KtModifierListOwner)it)) || KtModifierListKt.isProtected((KtModifierListOwner)((KtModifierListOwner)it)))) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (!bl && !this.hasConstructorParameter($this$checkMembers) && concreteMembers.isEmpty() && !this.hasInheritedMember($this$checkMembers, false)) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)nameIdentifier, (int)0, (int)2, null), this.noConcreteMember, null, null, 24, null));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtCallableDeclaration> members(KtClass $this$members) {
        List list;
        List list2;
        List list3;
        List list4;
        void $this$filterIsInstanceTo$iv$iv;
        Collection destination$iv$iv;
        Object $this$filterIsInstance$iv;
        PsiElement[] psiElementArray = $this$members.getBody();
        if (psiElementArray != null && (psiElementArray = psiElementArray.getChildren()) != null) {
            $this$filterIsInstance$iv = psiElementArray;
            boolean $i$f$filterIsInstance = false;
            PsiElement[] psiElementArray2 = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KtCallableDeclaration)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list4 = (List)destination$iv$iv;
        } else {
            list4 = list3 = null;
        }
        if (list4 == null) {
            list3 = CollectionsKt.emptyList();
        }
        Collection collection = list3;
        Object object = $this$members.getPrimaryConstructor();
        if (object != null && (object = object.getValueParameters()) != null) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            $this$filterIsInstance$iv = (Iterable)object;
            Collection collection2 = collection;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtParameter it = (KtParameter)element$iv$iv;
                boolean bl = false;
                if (!it.hasValOrVar()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
            collection = collection2;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)list);
    }

    private final boolean hasConstructorParameter(KtClass $this$hasConstructorParameter) {
        Object object = $this$hasConstructorParameter.getPrimaryConstructor();
        return object != null && (object = object.getValueParameters()) != null ? !((Collection)object).isEmpty() : false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasInheritedMember(KtClass $this$hasInheritedMember, boolean isAbstract) {
        boolean bl;
        block8: {
            if ($this$hasInheritedMember.getSuperTypeListEntries().isEmpty()) {
                bl = false;
            } else if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
                bl = true;
            } else {
                void $this$any$iv;
                Collection collection;
                ClassDescriptor descriptor = (ClassDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.CLASS, (Object)$this$hasInheritedMember);
                ClassDescriptor classDescriptor = descriptor;
                if ((classDescriptor != null && (classDescriptor = classDescriptor.getUnsubstitutedMemberScope()) != null ? ResolutionScope.DefaultImpls.getContributedDescriptors$default((ResolutionScope)((ResolutionScope)classDescriptor), null, null, (int)3, null) : (collection = null)) == null) {
                    collection = CollectionsKt.emptyList();
                }
                Iterable iterable = collection;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                        boolean bl2 = false;
                        MemberDescriptor memberDescriptor = it instanceof MemberDescriptor ? (MemberDescriptor)it : null;
                        if (!((memberDescriptor != null ? memberDescriptor.getModality() : null) == Modality.ABSTRACT == isAbstract)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isAnyParentAbstract(KtClass $this$isAnyParentAbstract) {
        boolean bl;
        LazyClassMemberScope lazyClassMemberScope;
        ClassDescriptor classDescriptor = (ClassDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.CLASS, (Object)$this$isAnyParentAbstract);
        Object object = classDescriptor != null ? classDescriptor.getUnsubstitutedMemberScope() : null;
        LazyClassMemberScope lazyClassMemberScope2 = lazyClassMemberScope = object instanceof LazyClassMemberScope ? (LazyClassMemberScope)object : null;
        if (lazyClassMemberScope != null && (object = lazyClassMemberScope.getSupertypes()) != null) {
            boolean bl2;
            block5: {
                void $this$all$iv;
                Iterable iterable = (Iterable)object;
                boolean $i$f$all = false;
                if (((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        KotlinType it = (KotlinType)element$iv;
                        boolean bl3 = false;
                        if (TypeUtilsKt.isInterface((KotlinType)it)) continue;
                        bl2 = false;
                        break block5;
                    }
                    bl2 = true;
                }
            }
            bl = !bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    public UnnecessaryAbstractClass() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(UnnecessaryAbstractClass.class, "excludeAnnotatedClasses", "getExcludeAnnotatedClasses()Ljava/util/List;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

