/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.style.UnnecessaryParentheses;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.parsing.KotlinExpressionParsing;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryParentheses;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "allowForUnclearPrecedence", "", "getAllowForUnclearPrecedence$annotations", "()V", "getAllowForUnclearPrecedence", "()Z", "allowForUnclearPrecedence$delegate", "Lkotlin/properties/ReadOnlyProperty;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitParenthesizedExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "Companion", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUnnecessaryParentheses.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnnecessaryParentheses.kt\nio/gitlab/arturbosch/detekt/rules/style/UnnecessaryParentheses\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,192:1\n1#2:193\n13309#3,2:194\n9972#3:196\n10394#3,2:197\n11065#3:199\n11400#3,2:200\n10394#3,5:202\n11402#3:207\n10396#3,3:208\n*S KotlinDebug\n*F\n+ 1 UnnecessaryParentheses.kt\nio/gitlab/arturbosch/detekt/rules/style/UnnecessaryParentheses\n*L\n123#1:194,2\n125#1:196\n125#1:197,2\n126#1:199\n126#1:200,2\n127#1:202,5\n126#1:207\n125#1:208,3\n*E\n"})
public final class UnnecessaryParentheses
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty allowForUnclearPrecedence$delegate;
    @NotNull
    private static final Map<IElementType, Set<IElementType>> childToUnclearPrecedenceParentsMapping;

    public UnnecessaryParentheses(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("UnnecessaryParentheses", Severity.Style, "Unnecessary parentheses don't add any value to the code and should be removed.", Debt.Companion.getFIVE_MINS());
        this.allowForUnclearPrecedence$delegate = ConfigPropertyKt.config((Object)false);
    }

    public /* synthetic */ UnnecessaryParentheses(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getAllowForUnclearPrecedence() {
        return (Boolean)this.allowForUnclearPrecedence$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="allow parentheses when not strictly required but precedence may be unclear, such as `(a && b) || c`")
    private static /* synthetic */ void getAllowForUnclearPrecedence$annotations() {
    }

    public void visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitParenthesizedExpression(expression);
        KtExpression ktExpression = expression.getExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression inner = ktExpression;
        if (expression.getParent() instanceof KtDelegatedSuperTypeEntry) {
            return;
        }
        if (!KtPsiUtil.areParenthesesUseless((KtParenthesizedExpression)expression)) {
            return;
        }
        if (this.getAllowForUnclearPrecedence() && UnnecessaryParentheses.Companion.isBinaryOperationPrecedenceUnclearWithParent(inner)) {
            return;
        }
        if (this.getAllowForUnclearPrecedence() && UnnecessaryParentheses.Companion.isUnaryOperationPrecedenceUnclear(expression)) {
            return;
        }
        KtExpression ktExpression2 = KtPsiUtil.deparenthesize((KtExpression)((KtExpression)expression));
        String message = "Parentheses in " + expression.getText() + " are unnecessary and can be replaced with: " + (ktExpression2 != null ? ktExpression2.getText() : null);
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), message, null, null, 24, null));
    }

    public UnnecessaryParentheses() {
        this(null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_5;
        void $this$flatMapTo$iv$iv;
        Object[] it;
        KotlinExpressionParsing.Precedence[] parents;
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(UnnecessaryParentheses.class, "allowForUnclearPrecedence", "getAllowForUnclearPrecedence()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        kPropertyArray = new Pair[5];
        KotlinExpressionParsing.Precedence[] precedenceArray = new KotlinExpressionParsing.Precedence[]{KotlinExpressionParsing.Precedence.EQUALITY, KotlinExpressionParsing.Precedence.COMPARISON, KotlinExpressionParsing.Precedence.IN_OR_IS};
        kPropertyArray[0] = TuplesKt.to((Object)KotlinExpressionParsing.Precedence.ELVIS, (Object)precedenceArray);
        precedenceArray = new KotlinExpressionParsing.Precedence[]{KotlinExpressionParsing.Precedence.ELVIS, KotlinExpressionParsing.Precedence.SIMPLE_NAME};
        kPropertyArray[1] = TuplesKt.to((Object)KotlinExpressionParsing.Precedence.SIMPLE_NAME, (Object)precedenceArray);
        precedenceArray = new KotlinExpressionParsing.Precedence[]{KotlinExpressionParsing.Precedence.ADDITIVE, KotlinExpressionParsing.Precedence.RANGE, KotlinExpressionParsing.Precedence.ELVIS};
        kPropertyArray[2] = TuplesKt.to((Object)KotlinExpressionParsing.Precedence.MULTIPLICATIVE, (Object)precedenceArray);
        precedenceArray = new KotlinExpressionParsing.Precedence[]{KotlinExpressionParsing.Precedence.RANGE, KotlinExpressionParsing.Precedence.ELVIS};
        kPropertyArray[3] = TuplesKt.to((Object)KotlinExpressionParsing.Precedence.ADDITIVE, (Object)precedenceArray);
        precedenceArray = new KotlinExpressionParsing.Precedence[]{KotlinExpressionParsing.Precedence.DISJUNCTION};
        kPropertyArray[4] = TuplesKt.to((Object)KotlinExpressionParsing.Precedence.CONJUNCTION, (Object)precedenceArray);
        for (KotlinExpressionParsing.Precedence precedence : precedenceArray = kPropertyArray) {
            boolean bl = false;
            KotlinExpressionParsing.Precedence child = (KotlinExpressionParsing.Precedence)precedence.component1();
            KotlinExpressionParsing.Precedence[] $this$forEach$iv = parents = (KotlinExpressionParsing.Precedence[])precedence.component2();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Object[] element$iv;
                it = element$iv = $this$forEach$iv[i];
                boolean bl2 = false;
                if (child.compareTo((Enum)it) <= 0) continue;
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
        }
        KotlinExpressionParsing.Precedence[] $this$flatMap$iv = precedenceArray;
        boolean $i$f$flatMap = false;
        KotlinExpressionParsing.Precedence[] precedenceArray2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (void element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            parents = element$iv$iv;
            boolean bl = false;
            KotlinExpressionParsing.Precedence child = (KotlinExpressionParsing.Precedence)parents.component1();
            KotlinExpressionParsing.Precedence[] parents2 = (KotlinExpressionParsing.Precedence[])parents.component2();
            IElementType[] iElementTypeArray = child.getOperations().getTypes();
            Intrinsics.checkNotNullExpressionValue((Object)iElementTypeArray, (String)"getTypes(...)");
            Object[] $this$map$iv = iElementTypeArray;
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void destination$iv;
                void $this$flatMapTo$iv;
                void childOp;
                IElementType iElementType = (IElementType)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                KotlinExpressionParsing.Precedence[] precedenceArray3 = parents2;
                Collection collection2 = new LinkedHashSet();
                void var25_36 = childOp;
                boolean $i$f$flatMapTo2 = false;
                int n = ((void)$this$flatMapTo$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv;
                    void parentOp = element$iv = $this$flatMapTo$iv[i];
                    boolean bl4 = false;
                    IElementType[] iElementTypeArray2 = parentOp.getOperations().getTypes();
                    Intrinsics.checkNotNullExpressionValue((Object)iElementTypeArray2, (String)"getTypes(...)");
                    Iterable list$iv = ArraysKt.toList((Object[])iElementTypeArray2);
                    CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                }
                collection.add(TuplesKt.to((Object)var25_36, (Object)destination$iv));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        childToUnclearPrecedenceParentsMapping = MapsKt.toMap((Iterable)((List)var3_5));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u0004\u0018\u00010\u0005*\u00020\tH\u0002J\u000e\u0010\n\u001a\u0004\u0018\u00010\t*\u00020\u000bH\u0002J\f\u0010\f\u001a\u00020\r*\u00020\u000bH\u0002J\f\u0010\u000e\u001a\u00020\r*\u00020\u000fH\u0002R&\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryParentheses$Companion;", "", "()V", "childToUnclearPrecedenceParentsMapping", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "", "getChildToUnclearPrecedenceParentsMapping$annotations", "binaryOp", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "firstNonParenParent", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isBinaryOperationPrecedenceUnclearWithParent", "", "isUnaryOperationPrecedenceUnclear", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "detekt-rules-style"})
    @SourceDebugExtension(value={"SMAP\nUnnecessaryParentheses.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnnecessaryParentheses.kt\nio/gitlab/arturbosch/detekt/rules/style/UnnecessaryParentheses$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,192:1\n1#2:193\n179#3,2:194\n*S KotlinDebug\n*F\n+ 1 UnnecessaryParentheses.kt\nio/gitlab/arturbosch/detekt/rules/style/UnnecessaryParentheses$Companion\n*L\n152#1:194,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getChildToUnclearPrecedenceParentsMapping$annotations() {
        }

        private final IElementType binaryOp(PsiElement $this$binaryOp) {
            Object object;
            PsiElement psiElement = $this$binaryOp;
            if (psiElement instanceof KtBinaryExpression) {
                KtOperationReferenceExpression ktOperationReferenceExpression;
                KtOperationReferenceExpression it = ktOperationReferenceExpression = ((KtBinaryExpression)$this$binaryOp).getOperationReference();
                boolean bl = false;
                object = (KtSimpleNameExpression)(!KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)$this$binaryOp).getOperationToken()) ? ktOperationReferenceExpression : null);
            } else {
                object = psiElement instanceof KtBinaryExpressionWithTypeRHS ? ((KtBinaryExpressionWithTypeRHS)$this$binaryOp).getOperationReference() : (psiElement instanceof KtIsExpression ? ((KtIsExpression)$this$binaryOp).getOperationReference() : null);
            }
            KtSimpleNameExpression ktSimpleNameExpression = object;
            return ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedNameElementType() : null;
        }

        private final PsiElement firstNonParenParent(KtExpression $this$firstNonParenParent) {
            Object v0;
            block1: {
                Sequence $this$firstOrNull$iv = SequencesKt.generateSequence((Object)$this$firstNonParenParent.getParent(), (Function1)firstNonParenParent.1.INSTANCE);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!(!(it instanceof KtParenthesizedExpression))) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        private final boolean isBinaryOperationPrecedenceUnclearWithParent(KtExpression $this$isBinaryOperationPrecedenceUnclearWithParent) {
            IElementType iElementType = this.binaryOp((PsiElement)$this$isBinaryOperationPrecedenceUnclearWithParent);
            if (iElementType == null) {
                return false;
            }
            IElementType innerOp = iElementType;
            PsiElement psiElement = this.firstNonParenParent($this$isBinaryOperationPrecedenceUnclearWithParent);
            if (psiElement == null || (psiElement = this.binaryOp(psiElement)) == null) {
                return false;
            }
            PsiElement outerOp = psiElement;
            Set set = (Set)childToUnclearPrecedenceParentsMapping.get(innerOp);
            return set != null ? set.contains(outerOp) : false;
        }

        private final boolean isUnaryOperationPrecedenceUnclear(KtParenthesizedExpression $this$isUnaryOperationPrecedenceUnclear) {
            PsiElement parentExpression = $this$isUnaryOperationPrecedenceUnclear.getParent();
            if (!(parentExpression instanceof KtPrefixExpression)) {
                return false;
            }
            Object[] objectArray = new KtSingleValueToken[]{KtTokens.PLUSPLUS, KtTokens.MINUSMINUS};
            if (CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)((KtPrefixExpression)parentExpression).getOperationReference().getReferencedNameElementType())) {
                KtExpression ktExpression = $this$isUnaryOperationPrecedenceUnclear.getExpression();
                KtDotQualifiedExpression ktDotQualifiedExpression = ktExpression instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)ktExpression : null;
                if ((ktDotQualifiedExpression != null ? ktDotQualifiedExpression.getReceiverExpression() : null) instanceof KtConstantExpression) {
                    return false;
                }
            }
            objectArray = new KtSingleValueToken[]{KtTokens.PLUS, KtTokens.MINUS, KtTokens.EXCL, KtTokens.PLUSPLUS, KtTokens.MINUSMINUS};
            return CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)((KtPrefixExpression)parentExpression).getOperationReference().getReferencedNameElementType());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

