/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.error.ErrorType;

@RequiresTypeResolution
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UselessCallOnNotNull;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "resolveCallForExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitQualifiedExpression", "isNullable", "", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "(Lorg/jetbrains/kotlin/psi/ValueArgument;)Ljava/lang/Boolean;", "Companion", "Conversion", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUselessCallOnNotNull.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UselessCallOnNotNull.kt\nio/gitlab/arturbosch/detekt/rules/style/UselessCallOnNotNull\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1726#2,3:134\n1#3:137\n*S KotlinDebug\n*F\n+ 1 UselessCallOnNotNull.kt\nio/gitlab/arturbosch/detekt/rules/style/UselessCallOnNotNull\n*L\n93#1:134,3\n*E\n"})
public final class UselessCallOnNotNull
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final Map<FqName, Conversion> uselessFqNames;
    @NotNull
    private static final FqName listOfNotNull;

    public UselessCallOnNotNull(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("UselessCallOnNotNull", Severity.Performance, "This call on a non-null reference may be reduced or removed. Some calls are intended to be called on nullable collection or text types (e.g. `String?`).When this call is used on a reference to a non-null type (e.g. `String`) it is redundant and will have no effect, so it can be removed.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UselessCallOnNotNull(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitQualifiedExpression(@NotNull KtQualifiedExpression expression) {
        boolean notNullType;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitQualifiedExpression(expression);
        KtSafeQualifiedExpression safeExpression = expression instanceof KtSafeQualifiedExpression ? (KtSafeQualifiedExpression)expression : null;
        KotlinType kotlinType = CallUtilKt.getType((KtExpression)expression.getReceiverExpression(), (BindingContext)this.getBindingContext());
        boolean bl = kotlinType != null ? !KotlinTypeKt.isNullable((KotlinType)kotlinType) : (notNullType = false);
        if (notNullType || safeExpression != null) {
            this.resolveCallForExpression(expression);
        }
    }

    private final void resolveCallForExpression(KtQualifiedExpression expression) {
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)this.getBindingContext());
        if (resolvedCall == null) {
            return;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        FqName fqName = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)resolvedCall2.getResultingDescriptor()));
        if (fqName == null) {
            return;
        }
        FqName fqName2 = fqName;
        Conversion conversion = uselessFqNames.get(fqName2);
        if (conversion != null) {
            String string = fqName2.shortName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String shortName = string;
            String message = conversion.getReplacementName() == null ? "Remove redundant call to " + shortName : "Replace " + shortName + " with " + conversion.getReplacementName();
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), message, null, null, 24, null));
        }
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitCallExpression(expression);
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)this.getBindingContext());
        if (resolvedCall == null) {
            return;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        FqName fqName = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)resolvedCall2.getResultingDescriptor()));
        if (Intrinsics.areEqual((Object)fqName, (Object)listOfNotNull)) {
            boolean bl;
            block6: {
                List list = ((ResolvedValueArgument)((Map.Entry)CollectionsKt.single((Iterable)resolvedCall2.getValueArguments().entrySet())).getValue()).getArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getArguments(...)");
                List varargs = list;
                Iterable $this$all$iv = varargs;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        ValueArgument it = (ValueArgument)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (Intrinsics.areEqual((Object)this.isNullable(it), (Object)false)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "Replace listOfNotNull with listOf", null, null, 24, null));
            }
        }
    }

    private final Boolean isNullable(ValueArgument $this$isNullable) {
        KtExpression type;
        KtExpression ktExpression;
        KtExpression ktExpression2 = $this$isNullable.getArgumentExpression();
        if (ktExpression2 == null || (ktExpression2 = CallUtilKt.getType((KtExpression)ktExpression2, (BindingContext)this.getBindingContext())) == null) {
            return null;
        }
        KtExpression wrapperType = ktExpression2;
        KtExpression ktExpression3 = $this$isNullable.getSpreadElement() != null ? ((TypeProjection)CollectionsKt.first((List)wrapperType.getArguments())).getType() : wrapperType;
        Intrinsics.checkNotNull((Object)ktExpression3);
        KtExpression it = ktExpression = (type = ktExpression3);
        boolean bl = false;
        ktExpression3 = !(it instanceof ErrorType) ? ktExpression : null;
        return ktExpression3 != null ? Boolean.valueOf(KotlinTypeKt.isNullable((KotlinType)ktExpression3)) : null;
    }

    public UselessCallOnNotNull() {
        this(null, 1, null);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)new FqName("kotlin.collections.orEmpty"), (Object)new Conversion(null, 1, null)), TuplesKt.to((Object)new FqName("kotlin.sequences.orEmpty"), (Object)new Conversion(null, 1, null)), TuplesKt.to((Object)new FqName("kotlin.text.orEmpty"), (Object)new Conversion(null, 1, null)), TuplesKt.to((Object)new FqName("kotlin.text.isNullOrEmpty"), (Object)new Conversion("isEmpty")), TuplesKt.to((Object)new FqName("kotlin.text.isNullOrBlank"), (Object)new Conversion("isBlank")), TuplesKt.to((Object)new FqName("kotlin.collections.isNullOrEmpty"), (Object)new Conversion("isEmpty"))};
        uselessFqNames = MapsKt.mapOf((Pair[])pairArray);
        listOfNotNull = new FqName("kotlin.collections.listOfNotNull");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UselessCallOnNotNull$Companion;", "", "()V", "listOfNotNull", "Lorg/jetbrains/kotlin/name/FqName;", "uselessFqNames", "", "Lio/gitlab/arturbosch/detekt/rules/style/UselessCallOnNotNull$Conversion;", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UselessCallOnNotNull$Conversion;", "", "replacementName", "", "(Ljava/lang/String;)V", "getReplacementName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "detekt-rules-style"})
    private static final class Conversion {
        @Nullable
        private final String replacementName;

        public Conversion(@Nullable String replacementName) {
            this.replacementName = replacementName;
        }

        public /* synthetic */ Conversion(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            this(string);
        }

        @Nullable
        public final String getReplacementName() {
            return this.replacementName;
        }

        @Nullable
        public final String component1() {
            return this.replacementName;
        }

        @NotNull
        public final Conversion copy(@Nullable String replacementName) {
            return new Conversion(replacementName);
        }

        public static /* synthetic */ Conversion copy$default(Conversion conversion, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = conversion.replacementName;
            }
            return conversion.copy(string);
        }

        @NotNull
        public String toString() {
            return "Conversion(replacementName=" + this.replacementName + ')';
        }

        public int hashCode() {
            return this.replacementName == null ? 0 : this.replacementName.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Conversion)) {
                return false;
            }
            Conversion conversion = (Conversion)other;
            return Intrinsics.areEqual((Object)this.replacementName, (Object)conversion.replacementName);
        }

        public Conversion() {
            this(null, 1, null);
        }
    }
}

