/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.style.ClassOrderingKt;
import io.gitlab.arturbosch.detekt.rules.style.Section;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010\u000e\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0018\u00010\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ClassOrdering;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitClassBody", "", "classBody", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "getMinimalNumberOfViolations", "Lkotlin/Pair;", "", "Lio/gitlab/arturbosch/detekt/rules/style/ClassOrdering$DeclarationWithSection;", "declarations", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "DeclarationWithSection", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nClassOrdering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassOrdering.kt\nio/gitlab/arturbosch/detekt/rules/style/ClassOrdering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,193:1\n1863#2:194\n967#2,7:195\n967#2,7:202\n1864#2:210\n1611#2,9:211\n1863#2:220\n1864#2:222\n1620#2:223\n1971#2,14:224\n1#3:209\n1#3:221\n*S KotlinDebug\n*F\n+ 1 ClassOrdering.kt\nio/gitlab/arturbosch/detekt/rules/style/ClassOrdering\n*L\n72#1:194\n74#1:195,7\n76#1:202,7\n72#1:210\n111#1:211,9\n111#1:220\n111#1:222\n111#1:223\n137#1:224,14\n111#1:221\n*E\n"})
public final class ClassOrdering
extends Rule {
    @NotNull
    private final Issue issue;

    public ClassOrdering(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Class contents should be in this order: Property declarations/initializer blocks; secondary constructors; method declarations then companion objects.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ ClassOrdering(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void visitClassBody(@NotNull KtClassBody classBody) {
        Intrinsics.checkNotNullParameter((Object)classBody, (String)"classBody");
        super.visitClassBody(classBody);
        declarations = CollectionsKt.filterNotNull((Iterable)classBody.getDeclarations());
        if (declarations.isEmpty()) {
            return;
        }
        v0 = this.getMinimalNumberOfViolations(declarations);
        if (v0 == null) {
            return;
        }
        var3_3 = v0;
        violatingDeclarationWithSections = (List)var3_3.component1();
        increasingDeclarationWithSections = (List)var3_3.component2();
        $this$forEach$iv = violatingDeclarationWithSections;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            block9: {
                var10_10 = (DeclarationWithSection)element$iv;
                $i$a$-forEach-ClassOrdering$visitClassBody$1 = false;
                violatingDeclaration = var10_10.component1();
                violatingSection = var10_10.component2();
                $this$takeWhile$iv = declarations;
                $i$f$takeWhile = false;
                list$iv = new ArrayList<Object>();
                for (Object item$iv : $this$takeWhile$iv) {
                    it /* !! */  = (KtDeclaration)item$iv;
                    $i$a$-takeWhile-ClassOrdering$visitClassBody$1$increasingDeclarationsBeforeViolatingElement$1 = false;
                    if (!(Intrinsics.areEqual((Object)it /* !! */ , (Object)violatingDeclaration) == false)) break;
                    list$iv.add(item$iv);
                }
                increasingDeclarationsBeforeViolatingElement = list$iv;
                $this$takeWhile$iv = increasingDeclarationWithSections;
                $i$f$takeWhile = false;
                list$iv = new ArrayList();
                for (Object item$iv : $this$takeWhile$iv) {
                    it = (DeclarationWithSection)item$iv;
                    $i$a$-takeWhile-ClassOrdering$visitClassBody$1$increasingDeclarationSectionBeforeViolatingElement$1 = false;
                    if (!increasingDeclarationsBeforeViolatingElement.contains(it.getDeclaration())) break;
                    list$iv.add(item$iv);
                }
                increasingDeclarationSectionBeforeViolatingElement = (List)list$iv;
                item$iv = increasingDeclarationSectionBeforeViolatingElement;
                item$iv = item$iv.iterator();
                while (item$iv.hasNext()) {
                    it = item$iv.next();
                    it = (DeclarationWithSection)it;
                    $i$a$-find-ClassOrdering$visitClassBody$1$1 = false;
                    if (!(it.getSection().getPriority() > violatingSection.getPriority())) continue;
                    v1 = it;
                    break block9;
                }
                v1 = null;
            }
            $i$f$takeWhile = v1;
            if ($i$f$takeWhile == null) ** GOTO lbl-1000
            it /* !! */  = $i$f$takeWhile;
            $i$a$-let-ClassOrdering$visitClassBody$1$2 = false;
            list$iv = TuplesKt.to((Object)"before", (Object)it /* !! */ );
            if (list$iv != null) {
                v2 = list$iv;
            } else lbl-1000:
            // 2 sources

            {
                block10: {
                    $this$visitClassBody_u24lambda_u246_u24lambda_u245 = this;
                    $i$a$-run-ClassOrdering$visitClassBody$1$3 = false;
                    var22_29 = increasingDeclarationWithSections;
                    var23_31 = "after";
                    var24_32 = var22_29;
                    var25_33 = var24_32.listIterator(var24_32.size());
                    while (var25_33.hasPrevious()) {
                        var26_34 = var25_33.previous();
                        it = (DeclarationWithSection)var26_34;
                        $i$a$-findLast-ClassOrdering$visitClassBody$1$3$1 = false;
                        if (!(it.getSection().getPriority() < violatingSection.getPriority())) continue;
                        v3 = var26_34;
                        break block10;
                    }
                    v3 = null;
                }
                v2 = TuplesKt.to((Object)var23_31, v3);
            }
            var15_15 = v2;
            directionMsg = (String)var15_15.component1();
            anchorSection = (DeclarationWithSection)var15_15.component2();
            if (anchorSection == null) continue;
            message = ClassOrderingKt.access$toDescription(violatingDeclaration) + " should be declared " + directionMsg + ' ' + anchorSection.getSection().toDescription() + '.';
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)violatingDeclaration), (int)0, (int)2, null), message, null, CollectionsKt.listOf((Object)Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)classBody), (int)0, (int)2, null)), 8, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<DeclarationWithSection>, List<DeclarationWithSection>> getMinimalNumberOfViolations(List<? extends KtDeclaration> declarations) {
        List list;
        Object v1;
        void $this$mapNotNullTo$iv$iv22;
        Iterable $this$mapNotNull$iv = declarations;
        int $i$f$mapNotNull = 0;
        Iterable iterable = $this$mapNotNull$iv;
        Object destination$iv$iv22 = new ArrayList();
        int $i$f$mapNotNullTo22 = 0;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv22;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DeclarationWithSection declarationWithSection;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KtDeclaration declaration = (KtDeclaration)element$iv$iv;
            boolean bl2 = false;
            if (ClassOrderingKt.access$toSection(declaration) != null) {
                Section it;
                boolean bl3 = false;
                declarationWithSection = new DeclarationWithSection(declaration, it);
            } else {
                declarationWithSection = null;
            }
            if (declarationWithSection == null) continue;
            DeclarationWithSection it$iv$iv = declarationWithSection;
            boolean bl4 = false;
            destination$iv$iv22.add(it$iv$iv);
        }
        List declarationWithSectionList = (List)destination$iv$iv22;
        $i$f$mapNotNull = 0;
        int $this$mapNotNullTo$iv$iv22 = declarationWithSectionList.size();
        destination$iv$iv22 = new int[$this$mapNotNullTo$iv$iv22];
        while ($i$f$mapNotNull < $this$mapNotNullTo$iv$iv22) {
            $i$f$mapNotNullTo22 = $i$f$mapNotNull++;
            destination$iv$iv22[$i$f$mapNotNullTo22] = true;
        }
        Object dp = destination$iv$iv22;
        $this$mapNotNullTo$iv$iv22 = 0;
        int destination$iv$iv22 = declarationWithSectionList.size();
        int[] $i$f$mapNotNullTo22 = new int[destination$iv$iv22];
        while ($this$mapNotNullTo$iv$iv22 < destination$iv$iv22) {
            $i$f$mapNotNullTo22[$this$forEach$iv$iv$iv] = $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv22++;
        }
        int[] backTrack = $i$f$mapNotNullTo22;
        destination$iv$iv22 = ((Object)dp).length;
        for (int i = 0; i < destination$iv$iv22; ++i) {
            for (int j = 0; j < i; ++j) {
                if (((DeclarationWithSection)declarationWithSectionList.get(i)).getSection().getPriority() < ((DeclarationWithSection)declarationWithSectionList.get(j)).getSection().getPriority() || dp[i] >= dp[j] + true) continue;
                dp[i] = dp[j] + true;
                backTrack[i] = j;
            }
        }
        int index = 0;
        Iterable $this$maxByOrNull$iv = (Iterable)ArraysKt.getIndices((int[])dp);
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = maxElem$iv;
            } else {
                int it = ((Number)maxElem$iv).intValue();
                boolean bl = false;
                Object maxValue$iv = dp[it];
                do {
                    Object e$iv = iterator$iv.next();
                    int it2 = ((Number)e$iv).intValue();
                    $i$a$-maxByOrNull-ClassOrdering$getMinimalNumberOfViolations$index$1 = false;
                    Object v$iv = dp[it2];
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = maxElem$iv;
            }
        }
        Integer n = v1;
        if (n == null) {
            return null;
        }
        index = n;
        List $this$getMinimalNumberOfViolations_u24lambda_u2410 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        int oldIndex = 0;
        do {
            $this$getMinimalNumberOfViolations_u24lambda_u2410.add(declarationWithSectionList.get(index));
        } while ((index = backTrack[index]) != (oldIndex = index));
        List listOfIncreasingSection = CollectionsKt.reversed((Iterable)CollectionsKt.build((List)list));
        return TuplesKt.to((Object)CollectionsKt.minus((Iterable)declarationWithSectionList, (Iterable)CollectionsKt.toSet((Iterable)listOfIncreasingSection)), (Object)listOfIncreasingSection);
    }

    public ClassOrdering() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ClassOrdering$DeclarationWithSection;", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "section", "Lio/gitlab/arturbosch/detekt/rules/style/Section;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lio/gitlab/arturbosch/detekt/rules/style/Section;)V", "getDeclaration", "()Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getSection", "()Lio/gitlab/arturbosch/detekt/rules/style/Section;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "detekt-rules-style"})
    private static final class DeclarationWithSection {
        @NotNull
        private final KtDeclaration declaration;
        @NotNull
        private final Section section;

        public DeclarationWithSection(@NotNull KtDeclaration declaration, @NotNull Section section) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)section, (String)"section");
            this.declaration = declaration;
            this.section = section;
        }

        @NotNull
        public final KtDeclaration getDeclaration() {
            return this.declaration;
        }

        @NotNull
        public final Section getSection() {
            return this.section;
        }

        @NotNull
        public final KtDeclaration component1() {
            return this.declaration;
        }

        @NotNull
        public final Section component2() {
            return this.section;
        }

        @NotNull
        public final DeclarationWithSection copy(@NotNull KtDeclaration declaration, @NotNull Section section) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)section, (String)"section");
            return new DeclarationWithSection(declaration, section);
        }

        public static /* synthetic */ DeclarationWithSection copy$default(DeclarationWithSection declarationWithSection, KtDeclaration ktDeclaration, Section section, int n, Object object) {
            if ((n & 1) != 0) {
                ktDeclaration = declarationWithSection.declaration;
            }
            if ((n & 2) != 0) {
                section = declarationWithSection.section;
            }
            return declarationWithSection.copy(ktDeclaration, section);
        }

        @NotNull
        public String toString() {
            return "DeclarationWithSection(declaration=" + this.declaration + ", section=" + this.section + ')';
        }

        public int hashCode() {
            int result = this.declaration.hashCode();
            result = result * 31 + this.section.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeclarationWithSection)) {
                return false;
            }
            DeclarationWithSection declarationWithSection = (DeclarationWithSection)other;
            if (!Intrinsics.areEqual((Object)this.declaration, (Object)declarationWithSection.declaration)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.section, (Object)declarationWithSection.section);
        }
    }
}

