/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR'\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0013\u001a\u00020\u00148BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0012\u0012\u0004\b\u0015\u0010\u000e\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006 "}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/DataClassContainsFunctions;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "conversionFunctionPrefix", "", "", "getConversionFunctionPrefix$annotations", "()V", "getConversionFunctionPrefix", "()Ljava/util/List;", "conversionFunctionPrefix$delegate", "Lkotlin/properties/ReadOnlyProperty;", "allowOperators", "", "getAllowOperators$annotations", "getAllowOperators", "()Z", "allowOperators$delegate", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "checkFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nDataClassContainsFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataClassContainsFunctions.kt\nio/gitlab/arturbosch/detekt/rules/style/DataClassContainsFunctions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n808#2,11:73\n1863#2,2:84\n1755#2,3:86\n*S KotlinDebug\n*F\n+ 1 DataClassContainsFunctions.kt\nio/gitlab/arturbosch/detekt/rules/style/DataClassContainsFunctions\n*L\n49#1:73,11\n50#1:84,2\n59#1:86,3\n*E\n"})
public final class DataClassContainsFunctions
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty conversionFunctionPrefix$delegate;
    @NotNull
    private final ReadOnlyProperty allowOperators$delegate;

    public DataClassContainsFunctions(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("DataClassContainsFunctions", Severity.Style, "Data classes should mainly be used to store data and should not have any extra functions (Compiler will automatically generate equals, toString and hashCode functions).", Debt.Companion.getTWENTY_MINS());
        this.conversionFunctionPrefix$delegate = ConfigPropertyKt.config((Object)CollectionsKt.listOf((Object)"to"));
        this.allowOperators$delegate = ConfigPropertyKt.config((Object)false);
    }

    public /* synthetic */ DataClassContainsFunctions(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<String> getConversionFunctionPrefix() {
        return (List)this.conversionFunctionPrefix$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="allowed conversion function names")
    private static /* synthetic */ void getConversionFunctionPrefix$annotations() {
    }

    private final boolean getAllowOperators() {
        return (Boolean)this.allowOperators$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="allows overloading an operator")
    private static /* synthetic */ void getAllowOperators$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    public void visitClass(@NotNull KtClass klass) {
        List list;
        KtClassBody ktClassBody;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (klass.isData() && (ktClassBody = klass.getBody()) != null && (list = ktClassBody.getDeclarations()) != null) {
            void $this$forEach$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            Iterable iterable = list;
            boolean $i$f$filterIsInstance = false;
            Iterator iterator = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KtNamedFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtNamedFunction it = (KtNamedFunction)element$iv;
                boolean bl = false;
                this.checkFunction(klass, it);
            }
        }
        super.visitClass(klass);
    }

    private final void checkFunction(KtClass klass, KtNamedFunction function) {
        if (KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)function))) {
            return;
        }
        String functionName = function.getName();
        if (functionName != null) {
            boolean bl;
            block7: {
                Iterable $this$any$iv = this.getConversionFunctionPrefix();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.startsWith$default((String)functionName, (String)it, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return;
            }
        }
        if (this.getAllowOperators() && KtModifierListKt.isOperator((KtModifierListOwner)((KtModifierListOwner)function))) {
            return;
        }
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)function), "The data class " + klass.getName() + " contains functions which are not registered conversion functions. The offending method is called " + functionName, null, null, 24, null));
    }

    public DataClassContainsFunctions() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(DataClassContainsFunctions.class, "conversionFunctionPrefix", "getConversionFunctionPrefix()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(DataClassContainsFunctions.class, "allowOperators", "getAllowOperators()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

