/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.load.java.sam.JavaSingleAbstractMethodUtils;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000f\u001a\u0004\u0018\u00010\f*\u00020\fH\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0012H\u0002J\u0014\u0010\u0013\u001a\u00020\u000b*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u0017\u001a\u00020\u000b*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0018\u001a\u00020\u000b*\u0004\u0018\u00010\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u001a\u001a\u00020\u000b*\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\f\u0010\u001c\u001a\u00020\u000b*\u00020\u0012H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\u00020\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ObjectLiteralToLambda;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "couldBeSamInterface", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "getCouldBeSamInterface", "(Lorg/jetbrains/kotlin/types/KotlinType;)Z", "singleSuperTypeOrNull", "singleNamedMethodOrNull", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "containsThisReference", "Lorg/jetbrains/kotlin/psi/KtExpression;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "containsOwnMethodCall", "isImplicitClassFor", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "containsMethodOf", "declaration", "hasConvertibleMethod", "visitObjectLiteralExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtObjectLiteralExpression;", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nObjectLiteralToLambda.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectLiteralToLambda.kt\nio/gitlab/arturbosch/detekt/rules/style/ObjectLiteralToLambda\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,112:1\n266#2:113\n277#2,10:114\n299#2:124\n266#2:125\n277#2,10:126\n299#2:136\n*S KotlinDebug\n*F\n+ 1 ObjectLiteralToLambda.kt\nio/gitlab/arturbosch/detekt/rules/style/ObjectLiteralToLambda\n*L\n66#1:113\n66#1:114,10\n66#1:124\n71#1:125\n71#1:126,10\n71#1:136\n*E\n"})
public final class ObjectLiteralToLambda
extends Rule {
    @NotNull
    private final Issue issue;

    public ObjectLiteralToLambda(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Report object literals that can be changed to lambdas.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ ObjectLiteralToLambda(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getCouldBeSamInterface(KotlinType $this$couldBeSamInterface) {
        return JavaSingleAbstractMethodUtils.isSamType((KotlinType)$this$couldBeSamInterface);
    }

    private final KotlinType singleSuperTypeOrNull(KotlinType $this$singleSuperTypeOrNull) {
        Collection collection = $this$singleSuperTypeOrNull.getConstructor().getSupertypes();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getSupertypes(...)");
        return (KotlinType)CollectionsKt.singleOrNull((Iterable)collection);
    }

    private final KtNamedFunction singleNamedMethodOrNull(KtObjectDeclaration $this$singleNamedMethodOrNull) {
        Object object = CollectionsKt.singleOrNull((List)$this$singleNamedMethodOrNull.getDeclarations());
        return object instanceof KtNamedFunction ? (KtNamedFunction)object : null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containsThisReference(KtExpression $this$containsThisReference, DeclarationDescriptor descriptor) {
        void $this$anyDescendantOfType$iv;
        PsiElement psiElement = (PsiElement)$this$containsThisReference;
        Function1 predicate$iv = arg_0 -> ObjectLiteralToLambda.containsThisReference$lambda$0(this, descriptor, arg_0);
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtThisExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containsOwnMethodCall(KtExpression $this$containsOwnMethodCall, DeclarationDescriptor descriptor) {
        void $this$anyDescendantOfType$iv;
        PsiElement psiElement = (PsiElement)$this$containsOwnMethodCall;
        Function1 predicate$iv = arg_0 -> ObjectLiteralToLambda.containsOwnMethodCall$lambda$2(this, descriptor, arg_0);
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    private final boolean isImplicitClassFor(ReceiverValue $this$isImplicitClassFor, DeclarationDescriptor descriptor) {
        return $this$isImplicitClassFor instanceof ImplicitClassReceiver && Intrinsics.areEqual((Object)((ImplicitClassReceiver)$this$isImplicitClassFor).getClassDescriptor(), (Object)descriptor);
    }

    private final boolean containsMethodOf(KtExpression $this$containsMethodOf, KtObjectDeclaration declaration) {
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)declaration);
        if (declarationDescriptor == null) {
            return false;
        }
        DeclarationDescriptor objectDescriptor = declarationDescriptor;
        return this.containsThisReference($this$containsMethodOf, objectDescriptor) || this.containsOwnMethodCall($this$containsMethodOf, objectDescriptor);
    }

    private final boolean hasConvertibleMethod(KtObjectDeclaration $this$hasConvertibleMethod) {
        KtNamedFunction singleNamedMethod = this.singleNamedMethodOrNull($this$hasConvertibleMethod);
        KtNamedFunction ktNamedFunction = singleNamedMethod;
        if (ktNamedFunction == null || (ktNamedFunction = ktNamedFunction.getBodyExpression()) == null) {
            return false;
        }
        KtNamedFunction functionBody = ktNamedFunction;
        return KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)singleNamedMethod)) && !this.containsMethodOf((KtExpression)functionBody, $this$hasConvertibleMethod);
    }

    public void visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitObjectLiteralExpression(expression);
        KtObjectDeclaration ktObjectDeclaration = expression.getObjectDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)ktObjectDeclaration, (String)"getObjectDeclaration(...)");
        KtObjectDeclaration declaration = ktObjectDeclaration;
        if (declaration.getName() == null) {
            KotlinType kotlinType;
            KotlinType kotlinType2 = this.getBindingContext().getType((KtExpression)expression);
            boolean bl = kotlinType2 != null && (kotlinType = this.singleSuperTypeOrNull(kotlinType2)) != null ? this.getCouldBeSamInterface(kotlinType) : false;
            if (bl && this.hasConvertibleMethod(declaration)) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
            }
        }
    }

    private static final boolean containsThisReference$lambda$0(ObjectLiteralToLambda this$0, DeclarationDescriptor $descriptor, KtThisExpression thisReference) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$descriptor, (String)"$descriptor");
        Intrinsics.checkNotNullParameter((Object)thisReference, (String)"thisReference");
        return Intrinsics.areEqual((Object)this$0.getBindingContext().get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)thisReference.getInstanceReference()), (Object)$descriptor);
    }

    private static final boolean containsOwnMethodCall$lambda$2(ObjectLiteralToLambda this$0, DeclarationDescriptor $descriptor, KtExpression it) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$descriptor, (String)"$descriptor");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)it), (BindingContext)this$0.getBindingContext());
        if (resolvedCall != null) {
            ResolvedCall resolvedCall2 = resolvedCall;
            boolean bl2 = false;
            bl = this$0.isImplicitClassFor(resolvedCall2.getDispatchReceiver(), $descriptor) || this$0.isImplicitClassFor(resolvedCall2.getExtensionReceiver(), $descriptor);
        } else {
            bl = false;
        }
        return bl;
    }

    public ObjectLiteralToLambda() {
        this(null, 1, null);
    }
}

