/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Location;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.TextLocation;
import io.gitlab.arturbosch.detekt.rules.IsPartOfUtilsKt;
import io.gitlab.arturbosch.detekt.rules.style.JunkKt;
import io.gitlab.arturbosch.detekt.rules.style.KtFileContent;
import io.gitlab.arturbosch.detekt.rules.style.KtFileContentKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/TrailingWhitespace;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visit", "fileContent", "Lio/gitlab/arturbosch/detekt/rules/style/KtFileContent;", "countTrailingWhitespace", "", "line", "", "createMessage", "findFirstKtElementInParentsOrNull", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "offset", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nTrailingWhitespace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrailingWhitespace.kt\nio/gitlab/arturbosch/detekt/rules/style/TrailingWhitespace\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,65:1\n1328#2,3:66\n170#3,6:69\n*S KotlinDebug\n*F\n+ 1 TrailingWhitespace.kt\nio/gitlab/arturbosch/detekt/rules/style/TrailingWhitespace\n*L\n33#1:66,3\n55#1:69,6\n*E\n"})
public final class TrailingWhitespace
extends Rule {
    @NotNull
    private final Issue issue;

    public TrailingWhitespace(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Whitespaces at the end of a line are unnecessary and can be removed.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ TrailingWhitespace(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super.visitKtFile(file);
        this.visit(KtFileContentKt.toFileContent(file));
    }

    /*
     * WARNING - void declaration
     */
    private final void visit(KtFileContent fileContent) {
        int offset = 0;
        Sequence<String> $this$forEachIndexed$iv = fileContent.getContent();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            KtFile file;
            PsiElement ktElement;
            void line;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            int trailingWhitespaces = this.countTrailingWhitespace((String)line);
            if (!(trailingWhitespaces <= 0 || (ktElement = this.findFirstKtElementInParentsOrNull(file = fileContent.getFile(), offset += line.length(), (String)line)) != null && IsPartOfUtilsKt.isPartOfString((PsiElement)ktElement))) {
                Entity entity = Entity.Companion.from((PsiElement)file, offset - trailingWhitespaces);
                boolean bl2 = false;
                Entity entity2 = Entity.copy$default((Entity)entity, null, null, (Location)Location.copy$default((Location)entity.getLocation(), null, (TextLocation)TextLocation.copy$default((TextLocation)entity.getLocation().getText(), (int)0, (int)offset, (int)1, null), null, null, (int)13, null), null, (int)11, null);
                this.report((Finding)new CodeSmell(this.getIssue(), entity2, this.createMessage(index), null, null, 24, null));
            }
            ++offset;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int countTrailingWhitespace(String line) {
        int n;
        int n2;
        block2: {
            void $this$indexOfLast$iv;
            CharSequence charSequence = line;
            n2 = line.length();
            boolean $i$f$indexOfLast = false;
            int n3 = $this$indexOfLast$iv.length() + -1;
            if (0 <= n3) {
                do {
                    int index$iv = n3--;
                    char it = $this$indexOfLast$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(it != ' ' && it != '\t')) continue;
                    n = index$iv;
                    break block2;
                } while (0 <= n3);
            }
            n = -1;
        }
        int n4 = n;
        return n2 - n4 - 1;
    }

    private final String createMessage(int line) {
        return "Line " + (line + 1) + " ends with a whitespace.";
    }

    private final PsiElement findFirstKtElementInParentsOrNull(KtFile file, int offset, String line) {
        return (PsiElement)SequencesKt.firstOrNull(JunkKt.findKtElementInParents(file, offset, line));
    }

    public TrailingWhitespace() {
        this(null, 1, null);
    }
}

