/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\t2\u0006\u0010\u0019\u001a\u00020\bH\u0002J\u0018\u0010\u001a\u001a\u00020\u00112\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001cH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u001f\u001a\u0004\u0018\u00010\u001d*\u00020\u0017H\u0002R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryInnerClass;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "candidateClassToParentClasses", "", "Lorg/jetbrains/kotlin/psi/KtClass;", "", "classChain", "Lkotlin/collections/ArrayDeque;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitClass", "", "klass", "visitReferenceExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "visitThisExpression", "Lorg/jetbrains/kotlin/psi/KtThisExpression;", "findParentClasses", "ktClass", "checkForOuterUsage", "getTargetClassId", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/name/ClassId;", "findResolvedContainingClassId", "referenceClassId", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUnnecessaryInnerClass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnnecessaryInnerClass.kt\nio/gitlab/arturbosch/detekt/rules/style/UnnecessaryInnerClass\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n360#2,7:127\n1863#2,2:134\n*S KotlinDebug\n*F\n+ 1 UnnecessaryInnerClass.kt\nio/gitlab/arturbosch/detekt/rules/style/UnnecessaryInnerClass\n*L\n106#1:127,7\n109#1:134,2\n*E\n"})
public final class UnnecessaryInnerClass
extends Rule {
    @NotNull
    private final Map<KtClass, List<KtClass>> candidateClassToParentClasses;
    @NotNull
    private final ArrayDeque<KtClass> classChain;
    @NotNull
    private final Issue issue;

    public UnnecessaryInnerClass(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.candidateClassToParentClasses = new LinkedHashMap();
        this.classChain = new ArrayDeque();
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "The 'inner' qualifier is unnecessary.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UnnecessaryInnerClass(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        this.classChain.add((Object)klass);
        if (klass.isInner()) {
            this.candidateClassToParentClasses.put(klass, this.findParentClasses(klass));
        }
        super.visitClass(klass);
        if (klass.isInner() && this.candidateClassToParentClasses.containsKey(klass)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)klass), (int)0, (int)2, null), "Class '" + klass.getName() + "' does not require `inner` keyword.", null, null, 24, null));
            this.candidateClassToParentClasses.remove(klass);
        }
        UtilsKt.pop((List)((List)this.classChain));
    }

    public void visitReferenceExpression(@NotNull KtReferenceExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitReferenceExpression(expression);
        this.checkForOuterUsage((Function0<ClassId>)((Function0)() -> UnnecessaryInnerClass.visitReferenceExpression$lambda$0(this, expression)));
    }

    public void visitThisExpression(@NotNull KtThisExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.checkForOuterUsage((Function0<ClassId>)((Function0)() -> UnnecessaryInnerClass.visitThisExpression$lambda$1(this, expression)));
    }

    private final List<KtClass> findParentClasses(KtClass ktClass) {
        ArrayList<KtClass> arrayList;
        ArrayList<KtClass> $this$findParentClasses_u24lambda_u242 = arrayList = new ArrayList<KtClass>();
        boolean bl = false;
        KtClass containingClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)ktClass));
        while (containingClass != null) {
            $this$findParentClasses_u24lambda_u242.add(containingClass);
            containingClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)containingClass));
        }
        return arrayList;
    }

    private final void checkForOuterUsage(Function0<ClassId> getTargetClassId) {
        int index;
        List<KtClass> parentClasses;
        KtClass currentClass;
        block7: {
            int n;
            KtClass ktClass = (KtClass)UtilsKt.peek((List)((List)this.classChain));
            if (ktClass == null) {
                return;
            }
            currentClass = ktClass;
            List<KtClass> list = this.candidateClassToParentClasses.get(currentClass);
            if (list == null) {
                return;
            }
            parentClasses = list;
            ClassId classId = (ClassId)getTargetClassId.invoke();
            if (classId == null) {
                return;
            }
            ClassId targetClassId = classId;
            List<KtClass> $this$indexOfFirst$iv = parentClasses;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<KtClass> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                KtClass item$iv;
                KtClass it = item$iv = iterator.next();
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getClassId(), (Object)targetClassId)) {
                    n = index$iv;
                    break block7;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (index >= 0) {
            this.candidateClassToParentClasses.remove(currentClass);
            Iterable $this$forEach$iv = parentClasses.subList(0, index);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtClass it = (KtClass)element$iv;
                boolean bl = false;
                this.candidateClassToParentClasses.remove(it);
            }
        }
    }

    private final ClassId findResolvedContainingClassId(KtReferenceExpression expression) {
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)expression);
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor != null ? declarationDescriptor.getContainingDeclaration() : null;
        ClassifierDescriptor classifierDescriptor = declarationDescriptor2 instanceof ClassifierDescriptor ? (ClassifierDescriptor)declarationDescriptor2 : null;
        return classifierDescriptor != null ? DescriptorUtilsKt.getClassId((ClassifierDescriptor)classifierDescriptor) : null;
    }

    private final ClassId referenceClassId(KtThisExpression $this$referenceClassId) {
        ClassifierDescriptor classifierDescriptor;
        TypeConstructor typeConstructor;
        KotlinType kotlinType;
        CallableDescriptor callableDescriptor;
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$referenceClassId), (BindingContext)this.getBindingContext());
        return resolvedCall != null && (callableDescriptor = resolvedCall.getResultingDescriptor()) != null && (kotlinType = callableDescriptor.getReturnType()) != null && (typeConstructor = kotlinType.getConstructor()) != null && (classifierDescriptor = typeConstructor.getDeclarationDescriptor()) != null ? DescriptorUtilsKt.getClassId((ClassifierDescriptor)classifierDescriptor) : null;
    }

    private static final ClassId visitReferenceExpression$lambda$0(UnnecessaryInnerClass this$0, KtReferenceExpression $expression) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$expression, (String)"$expression");
        return this$0.findResolvedContainingClassId($expression);
    }

    private static final ClassId visitThisExpression$lambda$1(UnnecessaryInnerClass this$0, KtThisExpression $expression) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$expression, (String)"$expression");
        return this$0.referenceClassId($expression);
    }

    public UnnecessaryInnerClass() {
        this(null, 1, null);
    }
}

