/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtBinaryExpressionKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseLet;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "isExpressionNull", "", "branch", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitIfExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUseLet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UseLet.kt\nio/gitlab/arturbosch/detekt/rules/style/UseLet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n1#2:65\n*E\n"})
public final class UseLet
extends Rule {
    @NotNull
    private final Issue issue;

    public UseLet(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Use `?.let {}` instead of if/else with a null block when checking for nullable values", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UseLet(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean isExpressionNull(KtExpression branch) {
        boolean bl;
        KtExpression statement;
        Object object;
        KtExpression ktExpression = branch;
        if (ktExpression instanceof KtBlockExpression) {
            if (((KtBlockExpression)branch).getStatements().size() == 1) {
                List list = ((KtBlockExpression)branch).getStatements();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStatements(...)");
                object = (KtExpression)CollectionsKt.first((List)list);
            } else {
                object = null;
            }
        } else {
            object = ktExpression instanceof KtConstantExpression ? branch : null;
        }
        KtExpression ktExpression2 = statement = object;
        if (ktExpression2 != null) {
            KtExpression it = ktExpression2;
            boolean bl2 = false;
            bl = KtPsiUtil.isNullConstant((KtExpression)it);
        } else {
            bl = false;
        }
        return bl;
    }

    public void visitIfExpression(@NotNull KtIfExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitIfExpression(expression);
        KtExpression ktExpression = expression.getCondition();
        KtBinaryExpression ktBinaryExpression = ktExpression instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression : null;
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression condition = ktBinaryExpression;
        if (KtBinaryExpressionKt.isNullCheck((KtBinaryExpression)condition) && this.isExpressionNull(expression.getThen())) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        } else if (KtBinaryExpressionKt.isNonNullCheck((KtBinaryExpression)condition) && this.isExpressionNull(expression.getElse())) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    public UseLet() {
        this(null, 1, null);
    }
}

