/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0016B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0010\u001a\u00020\u000f2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0013H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UtilityClassWithPublicConstructor;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "canBeCheckedForUtilityClass", "", "hasOnlyUtilityClassMembers", "declarations", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "isCompanionObject", "declaration", "UtilityClassConstructor", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUtilityClassWithPublicConstructor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UtilityClassWithPublicConstructor.kt\nio/gitlab/arturbosch/detekt/rules/style/UtilityClassWithPublicConstructor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n1863#2,2:143\n*S KotlinDebug\n*F\n+ 1 UtilityClassWithPublicConstructor.kt\nio/gitlab/arturbosch/detekt/rules/style/UtilityClassWithPublicConstructor\n*L\n112#1:143,2\n*E\n"})
public final class UtilityClassWithPublicConstructor
extends Rule {
    @NotNull
    private final Issue issue;

    public UtilityClassWithPublicConstructor(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "The class declaration is unnecessary because it only contains utility functions. An object declaration should be used instead.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UtilityClassWithPublicConstructor(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (this.canBeCheckedForUtilityClass(klass)) {
            List declarations;
            UtilityClassConstructor utilityClassConstructor = new UtilityClassConstructor(klass);
            KtClassBody ktClassBody = klass.getBody();
            List list = declarations = ktClassBody != null ? ktClassBody.getDeclarations() : null;
            if (this.hasOnlyUtilityClassMembers(declarations)) {
                if (utilityClassConstructor.hasPublicConstructorWithoutParameters$detekt_rules_style()) {
                    this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)klass), (int)0, (int)2, null), "The class " + klass.getNameAsSafeName() + " only contains utility functions. Consider defining it as an object.", null, null, 24, null));
                } else if (KtModifierListKt.isOpen((KtModifierListOwner)((KtModifierListOwner)klass)) && utilityClassConstructor.hasNonPublicConstructorWithoutParameters$detekt_rules_style()) {
                    this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)klass), (int)0, (int)2, null), "The utility class " + klass.getNameAsSafeName() + " should be final.", null, null, 24, null));
                }
            }
        }
        super.visitClass(klass);
    }

    private final boolean canBeCheckedForUtilityClass(KtClass klass) {
        return !klass.isInterface() && !CollectionsKt.any((Iterable)klass.getSuperTypeListEntries()) && !klass.isAnnotation() && !klass.isSealed();
    }

    private final boolean hasOnlyUtilityClassMembers(List<? extends KtDeclaration> declarations) {
        Collection collection = declarations;
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        boolean containsCompanionObject = false;
        boolean isUtilityClassCandidate = false;
        isUtilityClassCandidate = true;
        Iterable $this$forEach$iv = declarations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtDeclaration it = (KtDeclaration)element$iv;
            boolean bl = false;
            if (this.isCompanionObject(it)) {
                containsCompanionObject = true;
                continue;
            }
            if (it instanceof KtSecondaryConstructor || it instanceof KtClassInitializer) continue;
            isUtilityClassCandidate = false;
        }
        return containsCompanionObject && isUtilityClassCandidate;
    }

    private final boolean isCompanionObject(KtDeclaration declaration) {
        KtObjectDeclaration ktObjectDeclaration = declaration instanceof KtObjectDeclaration ? (KtObjectDeclaration)declaration : null;
        return ktObjectDeclaration != null ? ktObjectDeclaration.isCompanion() : false;
    }

    public UtilityClassWithPublicConstructor() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\bJ\r\u0010\t\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\nJ\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UtilityClassWithPublicConstructor$UtilityClassConstructor;", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtClass;)V", "hasPublicConstructorWithoutParameters", "", "hasPublicConstructorWithoutParameters$detekt_rules_style", "hasNonPublicConstructorWithoutParameters", "hasNonPublicConstructorWithoutParameters$detekt_rules_style", "hasConstructorWithoutParameters", "publicModifier", "detekt-rules-style"})
    @SourceDebugExtension(value={"SMAP\nUtilityClassWithPublicConstructor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UtilityClassWithPublicConstructor.kt\nio/gitlab/arturbosch/detekt/rules/style/UtilityClassWithPublicConstructor$UtilityClassConstructor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n1755#2,3:143\n*S KotlinDebug\n*F\n+ 1 UtilityClassWithPublicConstructor.kt\nio/gitlab/arturbosch/detekt/rules/style/UtilityClassWithPublicConstructor$UtilityClassConstructor\n*L\n138#1:143,3\n*E\n"})
    public static final class UtilityClassConstructor {
        @NotNull
        private final KtClass klass;

        public UtilityClassConstructor(@NotNull KtClass klass) {
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            this.klass = klass;
        }

        public final boolean hasPublicConstructorWithoutParameters$detekt_rules_style() {
            return this.hasConstructorWithoutParameters(true);
        }

        public final boolean hasNonPublicConstructorWithoutParameters$detekt_rules_style() {
            return this.hasConstructorWithoutParameters(false);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean hasConstructorWithoutParameters(boolean publicModifier) {
            boolean bl;
            KtPrimaryConstructor primaryConstructor = this.klass.getPrimaryConstructor();
            if (primaryConstructor != null) {
                if (KtPsiUtilKt.isPublic((KtModifierListOwner)((KtModifierListOwner)primaryConstructor)) != publicModifier) return false;
                if (!primaryConstructor.getValueParameters().isEmpty()) return false;
                return true;
            }
            List secondaryConstructors = this.klass.getSecondaryConstructors();
            if (secondaryConstructors.isEmpty()) return true;
            Iterable $this$any$iv = secondaryConstructors;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                KtSecondaryConstructor it = (KtSecondaryConstructor)element$iv;
                boolean bl2 = false;
                if (KtPsiUtilKt.isPublic((KtModifierListOwner)((KtModifierListOwner)it)) == publicModifier && it.getValueParameters().isEmpty()) {
                    return true;
                }
                bl = false;
            } while (!bl);
            return true;
        }
    }
}

