/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/AlsoCouldBeApply;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nAlsoCouldBeApply.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlsoCouldBeApply.kt\nio/gitlab/arturbosch/detekt/rules/style/AlsoCouldBeApply\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Junk.kt\nio/gitlab/arturbosch/detekt/rules/JunkKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1#2:63\n40#3:64\n40#3:67\n1734#4,2:65\n1736#4:68\n*S KotlinDebug\n*F\n+ 1 AlsoCouldBeApply.kt\nio/gitlab/arturbosch/detekt/rules/style/AlsoCouldBeApply\n*L\n54#1:64\n57#1:67\n57#1:65,2\n57#1:68\n*E\n"})
public final class AlsoCouldBeApply
extends Rule {
    @NotNull
    private final Issue issue;

    public AlsoCouldBeApply(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("AlsoCouldBeApply", Severity.Style, "When an `also` block contains only `it`-started expressions, simplify it to the `apply` block.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ AlsoCouldBeApply(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        boolean bl;
        KtExpression callee;
        block16: {
            Object object;
            Object object2;
            block18: {
                block17: {
                    Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                    super.visitCallExpression(expression);
                    object2 = expression.getCalleeExpression();
                    if (object2 == null) break block17;
                    object = object2;
                    KtExpression it = object;
                    boolean bl2 = false;
                    object2 = Intrinsics.areEqual((Object)it.getText(), (Object)"also") ? object : null;
                    if (object2 != null) break block18;
                }
                return;
            }
            callee = object2;
            List list = expression.getLambdaArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getLambdaArguments(...)");
            KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull((List)list);
            if (ktLambdaArgument == null || (ktLambdaArgument = ktLambdaArgument.getLambdaExpression()) == null) {
                KtLambdaExpression ktLambdaExpression;
                List list2 = expression.getValueArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueArguments(...)");
                KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.singleOrNull((List)list2);
                if (ktValueArgument != null && (ktValueArgument = ktValueArgument.getArgumentExpression()) != null) {
                    KtValueArgument $this$safeAs$iv = ktValueArgument;
                    boolean $i$f$safeAs = false;
                    KtValueArgument ktValueArgument2 = $this$safeAs$iv;
                    if (!(ktValueArgument2 instanceof KtLambdaExpression)) {
                        ktValueArgument2 = null;
                    }
                    ktLambdaExpression = (KtLambdaExpression)ktValueArgument2;
                } else {
                    ktLambdaExpression = ktLambdaArgument = null;
                }
                if (ktLambdaExpression == null) {
                    return;
                }
            }
            KtLambdaArgument lambda = ktLambdaArgument;
            KtBlockExpression ktBlockExpression = lambda.getBodyExpression();
            List list3 = ktBlockExpression != null ? ktBlockExpression.getStatements() : null;
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            if ((object = (Collection)list3).isEmpty()) {
                boolean bl3 = false;
                return;
            }
            List statements = (List)object;
            Iterable $this$all$iv = statements;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    KtQualifiedExpression ktQualifiedExpression;
                    KtExpression it = (KtExpression)element$iv;
                    boolean bl4 = false;
                    Intrinsics.checkNotNull((Object)it);
                    KtExpression $this$safeAs$iv = it;
                    boolean $i$f$safeAs = false;
                    KtExpression ktExpression = $this$safeAs$iv;
                    if (!(ktExpression instanceof KtQualifiedExpression)) {
                        ktExpression = null;
                    }
                    if (Intrinsics.areEqual((Object)((ktQualifiedExpression = (KtQualifiedExpression)ktExpression) != null && (ktQualifiedExpression = ktQualifiedExpression.getReceiverExpression()) != null ? ktQualifiedExpression.getText() : null), (Object)"it")) continue;
                    bl = false;
                    break block16;
                }
                bl = true;
            }
        }
        if (bl) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)callee), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    public AlsoCouldBeApply() {
        this(null, 1, null);
    }
}

