/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.KtBinaryExpressionKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.style.CanBeNonNullable$ParameterCheckVisitor$visitNamedFunction$;
import io.gitlab.arturbosch.detekt.rules.style.CanBeNonNullable$ParameterCheckVisitor$visitWhenExpression$;
import io.gitlab.arturbosch.detekt.rules.style.CanBeNonNullable$PropertyCheckVisitor$isNullableType$;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Named;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslatorKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowUtilsKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0004\u000e\u000f\u0010\u0011B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/CanBeNonNullable;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "ParameterCheckVisitor", "NullableParam", "PropertyCheckVisitor", "Companion", "detekt-rules-style"})
public final class CanBeNonNullable
extends Rule {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final String REQUIRE_NOT_NULL_NAME = "requireNotNull";
    @NotNull
    private static final String CHECK_NOT_NULL_NAME = "checkNotNull";
    private static final boolean INELIGIBLE_SINGLE_EXPRESSION = false;
    private static final boolean ELIGIBLE_SINGLE_EXPRESSION = true;

    public CanBeNonNullable(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Variable can be changed to non-nullable, as it is never set to null.", Debt.Companion.getTEN_MINS());
    }

    public /* synthetic */ CanBeNonNullable(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super.visitKtFile(file);
        new PropertyCheckVisitor().visitKtFile(file);
        new ParameterCheckVisitor().visitKtFile(file);
    }

    public CanBeNonNullable() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/CanBeNonNullable$Companion;", "", "<init>", "()V", "REQUIRE_NOT_NULL_NAME", "", "CHECK_NOT_NULL_NAME", "INELIGIBLE_SINGLE_EXPRESSION", "", "ELIGIBLE_SINGLE_EXPRESSION", "detekt-rules-style"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u000f\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR\u001a\u0010\u0011\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\f\u00a8\u0006\u0013"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/CanBeNonNullable$NullableParam;", "", "param", "Lorg/jetbrains/kotlin/psi/KtParameter;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtParameter;)V", "getParam", "()Lorg/jetbrains/kotlin/psi/KtParameter;", "isNullChecked", "", "()Z", "setNullChecked", "(Z)V", "isNonNullChecked", "setNonNullChecked", "isNonNullForced", "setNonNullForced", "isNullCheckReturnsUnit", "setNullCheckReturnsUnit", "detekt-rules-style"})
    private static final class NullableParam {
        @NotNull
        private final KtParameter param;
        private boolean isNullChecked;
        private boolean isNonNullChecked;
        private boolean isNonNullForced;
        private boolean isNullCheckReturnsUnit;

        public NullableParam(@NotNull KtParameter param) {
            Intrinsics.checkNotNullParameter((Object)param, (String)"param");
            this.param = param;
        }

        @NotNull
        public final KtParameter getParam() {
            return this.param;
        }

        public final boolean isNullChecked() {
            return this.isNullChecked;
        }

        public final void setNullChecked(boolean bl) {
            this.isNullChecked = bl;
        }

        public final boolean isNonNullChecked() {
            return this.isNonNullChecked;
        }

        public final void setNonNullChecked(boolean bl) {
            this.isNonNullChecked = bl;
        }

        public final boolean isNonNullForced() {
            return this.isNonNullForced;
        }

        public final void setNonNullForced(boolean bl) {
            this.isNonNullForced = bl;
        }

        public final boolean isNullCheckReturnsUnit() {
            return this.isNullCheckReturnsUnit;
        }

        public final void setNullCheckReturnsUnit(boolean bl) {
            this.isNullCheckReturnsUnit = bl;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0014H\u0016J\u001c\u0010\u0015\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u0017*\u0004\u0018\u00010\u0017H\u0002J\u001c\u0010 \u001a\u00020!*\u0004\u0018\u00010\u00172\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060#H\u0002J \u0010$\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010%*\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J\u0018\u0010*\u001a\u00020\t*\u0004\u0018\u00010\u00172\b\u0010+\u001a\u0004\u0018\u00010\u0017H\u0002J\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020&0%*\u00020\u001e2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J\u001e\u0010-\u001a\u0004\u0018\u00010&2\b\u0010.\u001a\u0004\u0018\u00010'2\b\u0010/\u001a\u0004\u0018\u00010'H\u0002J\u0012\u00100\u001a\b\u0012\u0004\u0012\u00020&0%*\u000201H\u0002J(\u00102\u001a\u00020\t*\b\u0012\u0004\u0012\u0002030%2\u0006\u0010\r\u001a\u00020\u00122\f\u00104\u001a\b\u0012\u0004\u0012\u00020&0%H\u0002J\u001a\u00105\u001a\u00020!2\b\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u00020!H\u0002J\u000e\u00109\u001a\u00020!*\u0004\u0018\u00010\u0017H\u0002J\u0016\u0010:\u001a\u00020!*\u0004\u0018\u0001072\u0006\u0010;\u001a\u00020<H\u0002J$\u0010=\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00172\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0?H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/CanBeNonNullable$ParameterCheckVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "<init>", "(Lio/gitlab/arturbosch/detekt/rules/style/CanBeNonNullable;)V", "nullableParams", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lio/gitlab/arturbosch/detekt/rules/style/CanBeNonNullable$NullableParam;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitCallExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitPostfixExpression", "Lorg/jetbrains/kotlin/psi/KtPostfixExpression;", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "evaluateNullCheckReturnsUnit", "condition", "Lorg/jetbrains/kotlin/psi/KtExpression;", "then", "visitSafeQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtSafeQualifiedExpression;", "visitDotQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "getRootExpression", "determineSingleExpression", "", "candidateDescriptors", "", "getNonNullChecks", "", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/psi/KtElement;", "parentOperatorToken", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "evaluateCheckStatement", "elseExpression", "evaluateBinaryExpression", "getDescriptor", "leftExpression", "rightExpression", "evaluateIsExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "evaluateSubjectWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "subjectDescriptors", "isNullableCheck", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "isNegated", "isValidElseExpression", "isNullable", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "updateNullableParam", "updateCallback", "Lkotlin/Function1;", "detekt-rules-style"})
    @SourceDebugExtension(value={"SMAP\nCanBeNonNullable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanBeNonNullable.kt\nio/gitlab/arturbosch/detekt/rules/style/CanBeNonNullable$ParameterCheckVisitor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,595:1\n1317#2,2:596\n477#2:598\n1317#2,2:599\n1863#3,2:601\n1611#3,9:622\n1863#3:631\n1864#3:633\n1620#3:634\n774#3:635\n865#3,2:636\n1611#3,9:638\n1863#3:647\n1864#3:649\n1620#3:650\n1368#3:651\n1454#3,5:652\n1863#3,2:657\n1863#3,2:660\n1863#3,2:662\n1863#3,2:664\n309#4,15:603\n229#4,2:618\n241#4:620\n328#4:621\n1#5:632\n1#5:648\n1#5:659\n*S KotlinDebug\n*F\n+ 1 CanBeNonNullable.kt\nio/gitlab/arturbosch/detekt/rules/style/CanBeNonNullable$ParameterCheckVisitor\n*L\n166#1:596,2\n174#1:598\n201#1:599,2\n221#1:601,2\n243#1:622,9\n243#1:631\n243#1:633\n243#1:634\n244#1:635\n244#1:636,2\n245#1:638,9\n245#1:647\n245#1:649\n245#1:650\n246#1:651\n246#1:652,5\n250#1:657,2\n353#1:660,2\n407#1:662,2\n430#1:664,2\n241#1:603,15\n241#1:618,2\n241#1:620\n241#1:621\n243#1:632\n245#1:648\n*E\n"})
    private final class ParameterCheckVisitor
    extends DetektVisitor {
        @NotNull
        private final Map<DeclarationDescriptor, NullableParam> nullableParams = new LinkedHashMap();

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public void visitNamedFunction(@NotNull KtNamedFunction function) {
            block7: {
                block6: {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    if (KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)function))) {
                        return;
                    }
                    candidateDescriptors = new LinkedHashSet<E>();
                    v0 = function.getValueParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getValueParameters(...)");
                    $this$forEach$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)v0), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, visitNamedFunction$lambda$0(org.jetbrains.kotlin.psi.KtParameter ), (Lorg/jetbrains/kotlin/psi/KtParameter;)Ljava/lang/Boolean;)()), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, visitNamedFunction$lambda$2(io.gitlab.arturbosch.detekt.rules.style.CanBeNonNullable org.jetbrains.kotlin.psi.KtParameter ), (Lorg/jetbrains/kotlin/psi/KtParameter;)Lkotlin/Pair;)((CanBeNonNullable)CanBeNonNullable.this));
                    $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        var7_11 = (Pair)element$iv /* !! */ ;
                        $i$a$-forEach-CanBeNonNullable$ParameterCheckVisitor$visitNamedFunction$3 = false;
                        descriptor = (DeclarationDescriptor)var7_11.component1();
                        param = (KtParameter)var7_11.component2();
                        candidateDescriptors.add(descriptor);
                        Intrinsics.checkNotNull((Object)param);
                        this.nullableParams.put(descriptor, new NullableParam(param));
                    }
                    if (function.getInitializer() != null) break block6;
                    var5_8 = function.getBodyBlockExpression();
                    if (var5_8 == null || (element$iv /* !! */  = PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)var5_8))) == null) ** GOTO lbl-1000
                    $i$a$-forEach-CanBeNonNullable$ParameterCheckVisitor$visitNamedFunction$3 = (Sequence)element$iv /* !! */ ;
                    $i$f$filterIsInstance = false;
                    v1 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)ParameterCheckVisitor$visitNamedFunction$$inlined$filterIsInstance$1.INSTANCE);
                    Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                    var7_11 = v1;
                    if (var7_11 != null) {
                        v2 = SequencesKt.toList((Sequence)var7_11);
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = v3 = null;
                    }
                    if (v2 == null) {
                        v3 = CollectionsKt.emptyList();
                    }
                    v4 = (children = v3).size() == 1 ? this.determineSingleExpression((KtExpression)CollectionsKt.first((List)children), candidateDescriptors) : false;
                    break block7;
                }
                v4 = false;
            }
            validSingleChildExpression = v4;
            super.visitNamedFunction(function);
            children = SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)candidateDescriptors), (Function1)((Function1)new Function1<DeclarationDescriptor, NullableParam>(this.nullableParams){

                public final NullableParam invoke(DeclarationDescriptor p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return (NullableParam)((Map)this.receiver).remove(p0);
                }
            })), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, visitNamedFunction$lambda$4(boolean io.gitlab.arturbosch.detekt.rules.style.CanBeNonNullable$NullableParam ), (Lio/gitlab/arturbosch/detekt/rules/style/CanBeNonNullable$NullableParam;)Ljava/lang/Boolean;)((boolean)validSingleChildExpression));
            var5_8 = CanBeNonNullable.this;
            $i$f$forEach = false;
            for (E element$iv : $this$forEach$iv) {
                nullableParam = (NullableParam)element$iv;
                $i$a$-forEach-CanBeNonNullable$ParameterCheckVisitor$visitNamedFunction$6 = false;
                var5_8.report((Finding)new CodeSmell(var5_8.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)nullableParam.getParam()), (int)0, (int)2, null), "The nullable parameter '" + nullableParam.getParam().getName() + "' can be made non-nullable.", null, null, 24, null));
            }
        }

        public void visitCallExpression(@NotNull KtCallExpression expression) {
            Object object;
            CallableDescriptor callableDescriptor;
            String calleeName;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression.getCalleeExpression()), (BindingContext)CanBeNonNullable.this.getBindingContext());
            String string = calleeName = resolvedCall != null && (callableDescriptor = resolvedCall.getResultingDescriptor()) != null && (object = ((Named)callableDescriptor).getName()) != null ? object.toString() : null;
            if (Intrinsics.areEqual(calleeName, (Object)CanBeNonNullable.REQUIRE_NOT_NULL_NAME) || Intrinsics.areEqual(calleeName, (Object)CanBeNonNullable.CHECK_NOT_NULL_NAME)) {
                List list = expression.getValueArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueArguments(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtValueArgument valueArgument = (KtValueArgument)element$iv;
                    boolean bl = false;
                    if (valueArgument.getArgumentExpression() != null) {
                        KtExpression argumentExpression;
                        boolean bl2 = false;
                        this.updateNullableParam(argumentExpression, (Function1<? super NullableParam, Unit>)((Function1)ParameterCheckVisitor::visitCallExpression$lambda$8$lambda$7$lambda$6));
                    }
                }
            }
            super.visitCallExpression(expression);
        }

        public void visitPostfixExpression(@NotNull KtPostfixExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (Intrinsics.areEqual((Object)expression.getOperationToken(), (Object)KtTokens.EXCLEXCL)) {
                KtExpression ktExpression = expression.getBaseExpression();
                if (ktExpression != null) {
                    KtExpression baseExpression = ktExpression;
                    boolean bl = false;
                    this.updateNullableParam(baseExpression, (Function1<? super NullableParam, Unit>)((Function1)ParameterCheckVisitor::visitPostfixExpression$lambda$10$lambda$9));
                }
            }
            super.visitPostfixExpression(expression);
        }

        /*
         * WARNING - void declaration
         */
        public void visitWhenExpression(@NotNull KtWhenExpression expression) {
            void $this$flatMapTo$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            ResolvedCall it$iv$iv;
            boolean bl;
            void $this$mapNotNullTo$iv$iv2;
            Iterable $this$mapNotNull$iv;
            List list;
            List list2;
            CanBeNonNullable $this$collectDescendantsOfType_u24default$iv;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Object object = expression.getSubjectExpression();
            if (object != null) {
                void $this$forEachDescendantOfType$iv$iv$iv$iv;
                void $this$collectDescendantsOfTypeTo$iv$iv$iv;
                PsiElement psiElement = (PsiElement)object;
                Function1 predicate$iv = ParameterCheckVisitor$visitWhenExpression$$inlined$collectDescendantsOfType$default$1.INSTANCE;
                boolean $i$f$collectDescendantsOfType = false;
                CanBeNonNullable $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType_u24default$iv;
                boolean $i$f$collectDescendantsOfType2 = false;
                CanBeNonNullable canBeNonNullable = $this$collectDescendantsOfType$iv$iv;
                Collection to$iv$iv$iv = new ArrayList();
                boolean $i$f$collectDescendantsOfTypeTo = false;
                void var12_32 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
                Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtNameReferenceExpression, Unit>(predicate$iv, to$iv$iv$iv){
                    final /* synthetic */ Function1 $predicate;
                    final /* synthetic */ Collection $to;
                    {
                        this.$predicate = $predicate;
                        this.$to = $to;
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public final void invoke(PsiElement it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                            this.$to.add(it);
                        }
                    }
                };
                boolean $i$f$forEachDescendantOfType = false;
                PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
                $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
                    final /* synthetic */ Function1 $action;
                    {
                        this.$action = $action;
                    }

                    public void visitElement(PsiElement element) {
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        PsiElement it = element;
                        boolean bl = false;
                        super.visitElement(element);
                        if (element instanceof KtNameReferenceExpression) {
                            this.$action.invoke((Object)element);
                        }
                    }
                });
                list2 = (List)to$iv$iv$iv;
            } else {
                list2 = list = null;
            }
            if (list2 == null) {
                list = CollectionsKt.emptyList();
            }
            object = list;
            $this$collectDescendantsOfType_u24default$iv = CanBeNonNullable.this;
            boolean $i$f$mapNotNull22 = false;
            void $i$f$collectDescendantsOfType = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            Iterator $i$f$collectDescendantsOfTypeTo = $this$forEach$iv$iv$iv.iterator();
            while ($i$f$collectDescendantsOfTypeTo.hasNext()) {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = $i$f$collectDescendantsOfTypeTo.next();
                boolean bl2 = false;
                KtNameReferenceExpression it = (KtNameReferenceExpression)element$iv$iv;
                boolean bl3 = false;
                if (CallUtilKt.getResolvedCall((KtElement)((KtElement)it), (BindingContext)$this$collectDescendantsOfType_u24default$iv.getBindingContext()) == null) continue;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            Iterable $i$f$mapNotNull22 = $this$filter$iv;
            Iterable<ResolvedCall> destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ResolvedCall callDescriptor = (ResolvedCall)element$iv$iv;
                boolean bl4 = false;
                if (!KotlinTypeKt.isNullable((KotlinType)CallTranslatorKt.getReturnType((ResolvedCall)callDescriptor))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv2;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator callDescriptor = $this$forEach$iv$iv$iv2.iterator();
            while (callDescriptor.hasNext()) {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = callDescriptor.next();
                boolean bl5 = false;
                ResolvedCall callDescriptor2 = (ResolvedCall)element$iv$iv;
                boolean bl6 = false;
                CallableDescriptor callableDescriptor = callDescriptor2.getResultingDescriptor();
                if ((callableDescriptor instanceof ValueParameterDescriptor ? (ValueParameterDescriptor)callableDescriptor : null) == null) continue;
                it$iv$iv = it$iv$iv;
                bl = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List nullCheckedDescriptor = (List)destination$iv$iv2;
            List list3 = expression.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getEntries(...)");
            Iterable $this$flatMap$iv = list3;
            boolean $i$f$flatMap = false;
            destination$iv$iv2 = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                KtWhenEntry it = (KtWhenEntry)element$iv$iv;
                boolean bl7 = false;
                KtWhenCondition[] ktWhenConditionArray = it.getConditions();
                Intrinsics.checkNotNullExpressionValue((Object)ktWhenConditionArray, (String)"getConditions(...)");
                Iterable list$iv$iv = ArraysKt.asList((Object[])ktWhenConditionArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List whenConditions = (List)destination$iv$iv;
            if (!((Collection)nullCheckedDescriptor).isEmpty()) {
                this.evaluateSubjectWhenExpression(whenConditions, expression, nullCheckedDescriptor);
            } else {
                Iterable $this$forEach$iv = whenConditions;
                boolean $i$f$forEach3 = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtWhenCondition whenCondition = (KtWhenCondition)element$iv;
                    boolean bl8 = false;
                    if (!(whenCondition instanceof KtWhenConditionWithExpression)) continue;
                    this.evaluateCheckStatement(((KtWhenConditionWithExpression)whenCondition).getExpression(), expression.getElseExpression());
                }
            }
            super.visitWhenExpression(expression);
        }

        public void visitIfExpression(@NotNull KtIfExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            this.evaluateCheckStatement(expression.getCondition(), expression.getElse());
            if (KtPsiUtilKt.isFirstStatement((KtElement)((KtElement)expression))) {
                this.evaluateNullCheckReturnsUnit(expression.getCondition(), expression.getThen());
            }
            super.visitIfExpression(expression);
        }

        private final void evaluateNullCheckReturnsUnit(KtExpression condition, KtExpression then) {
            block3: {
                CallableDescriptor callableDescriptor;
                KtExpression thenExpression;
                KtExpression ktExpression = thenExpression = then instanceof KtBlockExpression ? ((KtBlockExpression)then).getFirstStatement() : then;
                if (!(thenExpression instanceof KtReturnExpression)) {
                    return;
                }
                if (((KtReturnExpression)thenExpression).getReturnedExpression() != null) {
                    return;
                }
                if (!(condition instanceof KtBinaryExpression) || !KtBinaryExpressionKt.isNullCheck((KtBinaryExpression)((KtBinaryExpression)condition)) || (callableDescriptor = this.getDescriptor((KtElement)((KtBinaryExpression)condition).getLeft(), (KtElement)((KtBinaryExpression)condition).getRight())) == null) break block3;
                Object it = callableDescriptor;
                boolean bl = false;
                NullableParam nullableParam = this.nullableParams.get(it);
                if (nullableParam != null) {
                    it = nullableParam;
                    boolean bl2 = false;
                    ((NullableParam)it).setNullCheckReturnsUnit(true);
                }
            }
        }

        public void visitSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            this.updateNullableParam(expression.getReceiverExpression(), (Function1<? super NullableParam, Unit>)((Function1)ParameterCheckVisitor::visitSafeQualifiedExpression$lambda$18));
            super.visitSafeQualifiedExpression(expression);
        }

        public void visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression) {
            KotlinType kotlinType;
            ReceiverParameterDescriptor receiverParameterDescriptor;
            CallableDescriptor callableDescriptor;
            Boolean isExtensionForNullable;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)CanBeNonNullable.this.getBindingContext());
            Boolean bl = isExtensionForNullable = resolvedCall != null && (callableDescriptor = resolvedCall.getResultingDescriptor()) != null && (receiverParameterDescriptor = callableDescriptor.getExtensionReceiverParameter()) != null && (kotlinType = receiverParameterDescriptor.getType()) != null ? Boolean.valueOf(kotlinType.isMarkedNullable()) : null;
            if (Intrinsics.areEqual(isExtensionForNullable, (Object)true) && (resolvedCall = this.getRootExpression(expression.getReceiverExpression())) != null) {
                ResolvedCall rootExpression = resolvedCall;
                boolean bl2 = false;
                this.updateNullableParam((KtExpression)rootExpression, (Function1<? super NullableParam, Unit>)((Function1)ParameterCheckVisitor::visitDotQualifiedExpression$lambda$20$lambda$19));
            }
            super.visitDotQualifiedExpression(expression);
        }

        public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
            KtExpression ktExpression;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (Intrinsics.areEqual((Object)expression.getOperationToken(), (Object)KtTokens.ELVIS) && (ktExpression = this.getRootExpression(expression.getLeft())) != null) {
                KtExpression rootExpression = ktExpression;
                boolean bl = false;
                this.updateNullableParam(rootExpression, (Function1<? super NullableParam, Unit>)((Function1)ParameterCheckVisitor::visitBinaryExpression$lambda$22$lambda$21));
            }
            super.visitBinaryExpression(expression);
        }

        private final KtExpression getRootExpression(KtExpression $this$getRootExpression) {
            KtExpression receiverExpression = $this$getRootExpression;
            while (receiverExpression instanceof KtQualifiedExpression) {
                receiverExpression = ((KtQualifiedExpression)receiverExpression).getReceiverExpression();
            }
            return receiverExpression;
        }

        private final boolean determineSingleExpression(KtExpression $this$determineSingleExpression, Set<? extends DeclarationDescriptor> candidateDescriptors) {
            boolean bl;
            KtExpression ktExpression = $this$determineSingleExpression;
            if (ktExpression instanceof KtReturnExpression) {
                bl = false;
            } else if (ktExpression instanceof KtIfExpression) {
                bl = true;
            } else if (ktExpression instanceof KtDotQualifiedExpression) {
                CallableDescriptor callableDescriptor;
                ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)this.getRootExpression($this$determineSingleExpression)), (BindingContext)CanBeNonNullable.this.getBindingContext());
                if (resolvedCall != null && (callableDescriptor = resolvedCall.getResultingDescriptor()) != null) {
                    DeclarationDescriptor p0 = (DeclarationDescriptor)callableDescriptor;
                    boolean $i$f$determineSingleExpression$stub_for_inlining = false;
                    boolean bl2 = false;
                    bl = candidateDescriptors.contains(p0);
                } else {
                    bl = false;
                }
            } else {
                bl = !(ktExpression instanceof KtCallExpression);
            }
            return bl;
        }

        private final List<CallableDescriptor> getNonNullChecks(KtElement $this$getNonNullChecks, IElementType parentOperatorToken) {
            KtElement ktElement = $this$getNonNullChecks;
            return ktElement instanceof KtBinaryExpression ? this.evaluateBinaryExpression((KtBinaryExpression)$this$getNonNullChecks, parentOperatorToken) : (ktElement instanceof KtIsExpression ? this.evaluateIsExpression((KtIsExpression)$this$getNonNullChecks) : null);
        }

        private final void evaluateCheckStatement(KtExpression $this$evaluateCheckStatement, KtExpression elseExpression) {
            block1: {
                List<CallableDescriptor> list = this.getNonNullChecks((KtElement)$this$evaluateCheckStatement, null);
                if (list == null) break block1;
                List<CallableDescriptor> nonNullChecks = list;
                boolean bl = false;
                Function1 nullableParamCallback = this.isValidElseExpression(elseExpression) ? ParameterCheckVisitor::evaluateCheckStatement$lambda$26$lambda$23 : ParameterCheckVisitor::evaluateCheckStatement$lambda$26$lambda$24;
                Iterable $this$forEach$iv = nonNullChecks;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CallableDescriptor it = (CallableDescriptor)element$iv;
                    boolean bl2 = false;
                    NullableParam nullableParam = this.nullableParams.get(it);
                    if (nullableParam == null) continue;
                    nullableParamCallback.invoke((Object)nullableParam);
                }
            }
        }

        private final List<CallableDescriptor> evaluateBinaryExpression(KtBinaryExpression $this$evaluateBinaryExpression, IElementType parentOperatorToken) {
            List nonNullChecks;
            block7: {
                Collection p0;
                KtExpression ktExpression = $this$evaluateBinaryExpression.getLeft();
                KtElement leftExpression = ktExpression != null ? KotlinUtilsKt.deparenthesize((KtElement)((KtElement)ktExpression)) : null;
                KtExpression ktExpression2 = $this$evaluateBinaryExpression.getRight();
                KtElement rightExpression = ktExpression2 != null ? KotlinUtilsKt.deparenthesize((KtElement)((KtElement)ktExpression2)) : null;
                nonNullChecks = new ArrayList();
                if (KtBinaryExpressionKt.isNullCheck((KtBinaryExpression)$this$evaluateBinaryExpression)) {
                    CallableDescriptor callableDescriptor = this.getDescriptor(leftExpression, rightExpression);
                    if (callableDescriptor != null) {
                        Object it = callableDescriptor;
                        boolean bl = false;
                        NullableParam nullableParam = this.nullableParams.get(it);
                        if (nullableParam != null) {
                            it = nullableParam;
                            boolean bl2 = false;
                            ((NullableParam)it).setNullChecked(true);
                        }
                    }
                } else if (KtBinaryExpressionKt.isNonNullCheck((KtBinaryExpression)$this$evaluateBinaryExpression) && !Intrinsics.areEqual((Object)parentOperatorToken, (Object)KtTokens.OROR)) {
                    CallableDescriptor callableDescriptor = this.getDescriptor(leftExpression, rightExpression);
                    if (callableDescriptor != null) {
                        p0 = callableDescriptor;
                        boolean $i$f$evaluateBinaryExpression$stub_for_inlining$29 = false;
                        boolean bl = false;
                        nonNullChecks.add(p0);
                    }
                }
                List<CallableDescriptor> list = this.getNonNullChecks(leftExpression, $this$evaluateBinaryExpression.getOperationToken());
                if (list != null) {
                    p0 = list;
                    boolean $i$f$evaluateBinaryExpression$stub_for_inlining$30 = false;
                    boolean bl = false;
                    nonNullChecks.addAll(p0);
                }
                List<CallableDescriptor> list2 = this.getNonNullChecks(rightExpression, $this$evaluateBinaryExpression.getOperationToken());
                if (list2 == null) break block7;
                p0 = list2;
                boolean $i$f$evaluateBinaryExpression$stub_for_inlining$31 = false;
                boolean bl = false;
                nonNullChecks.addAll(p0);
            }
            return nonNullChecks;
        }

        private final CallableDescriptor getDescriptor(KtElement leftExpression, KtElement rightExpression) {
            ResolvedCall resolvedCall;
            KtNameReferenceExpression ktNameReferenceExpression = leftExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)leftExpression : (rightExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)rightExpression : null);
            return ktNameReferenceExpression != null && (resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)ktNameReferenceExpression), (BindingContext)CanBeNonNullable.this.getBindingContext())) != null ? resolvedCall.getResultingDescriptor() : null;
        }

        private final List<CallableDescriptor> evaluateIsExpression(KtIsExpression $this$evaluateIsExpression) {
            List list;
            ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$evaluateIsExpression.getLeftHandSide()), (BindingContext)CanBeNonNullable.this.getBindingContext());
            if (resolvedCall == null || (resolvedCall = resolvedCall.getResultingDescriptor()) == null) {
                return CollectionsKt.emptyList();
            }
            ResolvedCall descriptor = resolvedCall;
            if (this.isNullableCheck($this$evaluateIsExpression.getTypeReference(), $this$evaluateIsExpression.isNegated())) {
                NullableParam nullableParam = this.nullableParams.get(descriptor);
                if (nullableParam != null) {
                    NullableParam it = nullableParam;
                    boolean bl = false;
                    it.setNullChecked(true);
                }
                list = CollectionsKt.emptyList();
            } else {
                list = CollectionsKt.listOf((Object)descriptor);
            }
            return list;
        }

        private final void evaluateSubjectWhenExpression(List<? extends KtWhenCondition> $this$evaluateSubjectWhenExpression, KtWhenExpression expression, List<? extends CallableDescriptor> subjectDescriptors) {
            boolean isNonNullChecked = false;
            boolean isNullChecked = false;
            Iterable $this$forEach$iv = $this$evaluateSubjectWhenExpression;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtWhenCondition whenCondition = (KtWhenCondition)element$iv;
                boolean bl = false;
                KtWhenCondition ktWhenCondition = whenCondition;
                if (ktWhenCondition instanceof KtWhenConditionWithExpression) {
                    KtExpression ktExpression = ((KtWhenConditionWithExpression)whenCondition).getExpression();
                    if (!Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)"null")) continue;
                    isNullChecked = true;
                    continue;
                }
                if (!(ktWhenCondition instanceof KtWhenConditionIsPattern)) continue;
                if (this.isNullableCheck(((KtWhenConditionIsPattern)whenCondition).getTypeReference(), ((KtWhenConditionIsPattern)whenCondition).isNegated())) {
                    isNullChecked = true;
                    continue;
                }
                isNonNullChecked = true;
            }
            if (this.isValidElseExpression(expression.getElseExpression())) {
                if (isNullChecked) {
                    isNonNullChecked = true;
                } else if (isNonNullChecked) {
                    isNullChecked = true;
                }
            }
            $this$forEach$iv = subjectDescriptors;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NullableParam it;
                CallableDescriptor callableDescriptor = (CallableDescriptor)element$iv;
                boolean bl = false;
                if (this.nullableParams.get(callableDescriptor) == null) continue;
                boolean bl2 = false;
                if (isNullChecked) {
                    it.setNullChecked(true);
                }
                if (!isNonNullChecked) continue;
                it.setNonNullChecked(true);
            }
        }

        private final boolean isNullableCheck(KtTypeReference typeReference, boolean isNegated) {
            boolean isNullable = this.isNullable(typeReference, CanBeNonNullable.this.getBindingContext());
            return isNullable && !isNegated || !isNullable && isNegated;
        }

        private final boolean isValidElseExpression(KtExpression $this$isValidElseExpression) {
            return $this$isValidElseExpression != null && !($this$isValidElseExpression instanceof KtIfExpression) && !($this$isValidElseExpression instanceof KtWhenExpression);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isNullable(KtTypeReference $this$isNullable, BindingContext bindingContext) {
            KtTypeReference ktTypeReference = $this$isNullable;
            KtTypeReference ktTypeReference2 = ktTypeReference;
            if (ktTypeReference == null) return false;
            KtTypeReference it = ktTypeReference2;
            boolean bl = false;
            KotlinType kotlinType = (KotlinType)bindingContext.get((ReadOnlySlice)BindingContext.TYPE, (Object)it);
            ktTypeReference2 = kotlinType;
            if (kotlinType == null) return false;
            if (!ktTypeReference2.isMarkedNullable()) return false;
            return true;
        }

        private final void updateNullableParam(KtExpression expression, Function1<? super NullableParam, Unit> updateCallback) {
            block1: {
                CallableDescriptor callableDescriptor;
                ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)CanBeNonNullable.this.getBindingContext());
                if (resolvedCall == null || (callableDescriptor = resolvedCall.getResultingDescriptor()) == null) break block1;
                CallableDescriptor it = callableDescriptor;
                boolean bl = false;
                NullableParam nullableParam = this.nullableParams.get(it);
                if (nullableParam != null) {
                    NullableParam nullableParam2 = nullableParam;
                    updateCallback.invoke((Object)nullableParam2);
                }
            }
        }

        private static final boolean visitNamedFunction$lambda$0(KtParameter it) {
            KtTypeReference ktTypeReference = it.getTypeReference();
            return (ktTypeReference != null ? ktTypeReference.getTypeElement() : null) instanceof KtNullableType;
        }

        private static final Pair visitNamedFunction$lambda$2(CanBeNonNullable this$0, KtParameter parameter) {
            Pair pair;
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this$0.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)parameter);
            if (declarationDescriptor != null) {
                DeclarationDescriptor it = declarationDescriptor;
                boolean bl = false;
                pair = TuplesKt.to((Object)it, (Object)parameter);
            } else {
                pair = null;
            }
            return pair;
        }

        private static final boolean visitNamedFunction$lambda$4(boolean $validSingleChildExpression, NullableParam it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            boolean onlyNonNullCheck = $validSingleChildExpression && it.isNonNullChecked() && !it.isNullChecked();
            return it.isNonNullForced() || it.isNullCheckReturnsUnit() || onlyNonNullCheck;
        }

        private static final Unit visitCallExpression$lambda$8$lambda$7$lambda$6(NullableParam it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.setNonNullForced(true);
            return Unit.INSTANCE;
        }

        private static final Unit visitPostfixExpression$lambda$10$lambda$9(NullableParam it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.setNonNullForced(true);
            return Unit.INSTANCE;
        }

        private static final Unit visitSafeQualifiedExpression$lambda$18(NullableParam it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.setNonNullChecked(true);
            return Unit.INSTANCE;
        }

        private static final Unit visitDotQualifiedExpression$lambda$20$lambda$19(NullableParam it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.setNullChecked(true);
            return Unit.INSTANCE;
        }

        private static final Unit visitBinaryExpression$lambda$22$lambda$21(NullableParam it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            it.setNullChecked(true);
            return Unit.INSTANCE;
        }

        private static final Unit evaluateCheckStatement$lambda$26$lambda$23(NullableParam nullableParam) {
            Intrinsics.checkNotNullParameter((Object)nullableParam, (String)"nullableParam");
            nullableParam.setNonNullChecked(true);
            nullableParam.setNullChecked(true);
            return Unit.INSTANCE;
        }

        private static final Unit evaluateCheckStatement$lambda$26$lambda$24(NullableParam nullableParam) {
            Intrinsics.checkNotNullParameter((Object)nullableParam, (String)"nullableParam");
            nullableParam.setNonNullChecked(true);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\f\u001a\u00020\t*\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\u0011*\u00020\u0007H\u0002J\u000e\u0010\u0014\u001a\u00020\u0011*\u0004\u0018\u00010\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u0011*\u0004\u0018\u00010\u0017H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/CanBeNonNullable$PropertyCheckVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "<init>", "(Lio/gitlab/arturbosch/detekt/rules/style/CanBeNonNullable;)V", "candidateProps", "", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "collectCandidateProps", "visitBinaryExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "isNullableAndCanBeNonNullable", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "isCandidate", "returnsNullable", "Lorg/jetbrains/kotlin/psi/KtPropertyDelegate;", "isNullableType", "Lorg/jetbrains/kotlin/psi/KtExpression;", "detekt-rules-style"})
    @SourceDebugExtension(value={"SMAP\nCanBeNonNullable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanBeNonNullable.kt\nio/gitlab/arturbosch/detekt/rules/style/CanBeNonNullable$PropertyCheckVisitor\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,595:1\n216#2,2:596\n222#3,9:598\n241#3:607\n309#3,15:608\n229#3,2:623\n241#3:625\n328#3:626\n1755#4,3:627\n*S KotlinDebug\n*F\n+ 1 CanBeNonNullable.kt\nio/gitlab/arturbosch/detekt/rules/style/CanBeNonNullable$PropertyCheckVisitor\n*L\n480#1:596,2\n492#1:598,9\n492#1:607\n572#1:608,15\n572#1:623,2\n572#1:625\n572#1:626\n573#1:627,3\n*E\n"})
    private final class PropertyCheckVisitor
    extends DetektVisitor {
        @NotNull
        private final Map<FqName, KtProperty> candidateProps = new LinkedHashMap();

        /*
         * WARNING - void declaration
         */
        public void visitKtFile(@NotNull KtFile file) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.collectCandidateProps(file);
            super.visitKtFile(file);
            Map<FqName, KtProperty> map = this.candidateProps;
            CanBeNonNullable canBeNonNullable = CanBeNonNullable.this;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                KtProperty property = (KtProperty)entry.getValue();
                canBeNonNullable.report((Finding)new CodeSmell(canBeNonNullable.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)property), (int)0, (int)2, null), "The nullable variable '" + property.getName() + "' can be made non-nullable.", null, null, 24, null));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void collectCandidateProps(KtFile $this$collectCandidateProps) {
            void $this$forEachDescendantOfType$iv;
            PsiElement psiElement = (PsiElement)$this$collectCandidateProps;
            Function1 action$iv = arg_0 -> PropertyCheckVisitor.collectCandidateProps$lambda$1(this, arg_0);
            boolean $i$f$forEachDescendantOfType = false;
            void $this$forEachDescendantOfType$iv$iv = $this$forEachDescendantOfType$iv;
            boolean $i$f$forEachDescendantOfType2 = false;
            PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv);
            $this$forEachDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $action;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                    if (element instanceof KtProperty) {
                        this.$action.invoke((Object)element);
                    }
                }
            });
        }

        public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (Intrinsics.areEqual((Object)expression.getOperationToken(), (Object)KtTokens.EQ)) {
                CallableDescriptor callableDescriptor;
                ResolvedCall resolvedCall;
                FqName fqName;
                KtExpression ktExpression = expression.getLeft();
                FqName fqName2 = fqName = ktExpression != null && (resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)ktExpression), (BindingContext)CanBeNonNullable.this.getBindingContext())) != null && (callableDescriptor = resolvedCall.getResultingDescriptor()) != null ? DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)callableDescriptor)) : null;
                if (fqName != null && this.candidateProps.containsKey(fqName)) {
                    KtExpression ktExpression2 = expression.getRight();
                    boolean bl = ktExpression2 != null ? this.isNullableType(ktExpression2) : false;
                    if (bl) {
                        this.candidateProps.remove(fqName);
                    }
                }
            }
            super.visitBinaryExpression(expression);
        }

        private final boolean isNullableAndCanBeNonNullable(KotlinType $this$isNullableAndCanBeNonNullable) {
            return TypeUtils.isTypeParameter((KotlinType)$this$isNullableAndCanBeNonNullable) ? $this$isNullableAndCanBeNonNullable.isMarkedNullable() : KotlinTypeKt.isNullable((KotlinType)$this$isNullableAndCanBeNonNullable);
        }

        /*
         * Unable to fully structure code
         */
        private final boolean isCandidate(KtProperty $this$isCandidate) {
            block9: {
                block8: {
                    if (KtModifierListKt.isOpen((KtModifierListOwner)((KtModifierListOwner)$this$isCandidate)) || KtModifierListKt.isAbstract((KtModifierListOwner)((KtModifierListOwner)$this$isCandidate))) break block8;
                    v0 = KtPsiUtilKt.containingClass((KtElement)((KtElement)$this$isCandidate));
                    v1 = v0 != null ? v0.isInterface() : false;
                    if (!v1) break block9;
                }
                return false;
            }
            v2 = type = DataFlowUtilsKt.getKotlinTypeForComparison((KtExpression)((KtExpression)$this$isCandidate), (BindingContext)CanBeNonNullable.this.getBindingContext());
            if (!(v2 != null ? this.isNullableAndCanBeNonNullable(v2) : false)) {
                return false;
            }
            v3 = $this$isCandidate.getInitializer();
            if (v3 != null ? this.isNullableType(v3) : false) ** GOTO lbl-1000
            v4 = $this$isCandidate.getGetter();
            if (v4 != null ? this.isNullableType((KtExpression)v4) : false) ** GOTO lbl-1000
            v5 = $this$isCandidate.getDelegate();
            if (!(v5 != null ? this.returnsNullable(v5) : false)) {
                v6 = true;
            } else lbl-1000:
            // 3 sources

            {
                v6 = isSetToNonNullable = false;
            }
            if (!$this$isCandidate.isVar() || KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)$this$isCandidate))) ** GOTO lbl-1000
            v7 = $this$isCandidate.getSetter();
            v8 = v7 != null ? KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)v7)) : false;
            if (v8) lbl-1000:
            // 2 sources

            {
                v9 = true;
            } else {
                v9 = false;
            }
            cannotSetViaNonPrivateMeans = v9;
            return isSetToNonNullable != false && cannotSetViaNonPrivateMeans != false;
        }

        private final boolean returnsNullable(KtPropertyDelegate $this$returnsNullable) {
            boolean bl;
            KtPropertyDelegate ktPropertyDelegate = $this$returnsNullable;
            Object object = ktPropertyDelegate != null ? ktPropertyDelegate.getParent() : null;
            KtProperty ktProperty = object instanceof KtProperty ? (KtProperty)object : null;
            if (ktProperty == null) {
                return false;
            }
            KtProperty property = ktProperty;
            object = CanBeNonNullable.this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)property);
            PropertyDescriptor propertyDescriptor = object instanceof PropertyDescriptor ? (PropertyDescriptor)object : null;
            PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
            if (propertyDescriptor2 != null && (propertyDescriptor2 = propertyDescriptor2.getGetter()) != null) {
                KotlinType kotlinType;
                FunctionDescriptor functionDescriptor;
                PropertyDescriptor propertyDescriptor3 = propertyDescriptor2;
                CanBeNonNullable canBeNonNullable = CanBeNonNullable.this;
                PropertyDescriptor it = propertyDescriptor3;
                boolean bl2 = false;
                ResolvedCall resolvedCall = (ResolvedCall)canBeNonNullable.getBindingContext().get((ReadOnlySlice)BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, (Object)it);
                bl = resolvedCall != null && (functionDescriptor = (FunctionDescriptor)resolvedCall.getResultingDescriptor()) != null && (kotlinType = functionDescriptor.getReturnType()) != null ? KotlinTypeKt.isNullable((KotlinType)kotlinType) : false;
            } else {
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isNullableType(KtExpression $this$isNullableType) {
            KtExpression ktExpression = $this$isNullableType;
            if (!(ktExpression instanceof KtConstantExpression)) {
                if (ktExpression instanceof KtIfExpression) {
                    if (this.isNullableType(((KtIfExpression)$this$isNullableType).getThen())) return true;
                    if (!this.isNullableType(((KtIfExpression)$this$isNullableType).getElse())) return false;
                    return true;
                }
                if (ktExpression instanceof KtPropertyAccessor) {
                    KtReturnExpression it;
                    void $this$any$iv;
                    void $this$forEachDescendantOfType$iv$iv$iv$iv;
                    void $this$collectDescendantsOfTypeTo$iv$iv$iv;
                    Iterable $this$collectDescendantsOfType_u24default$iv;
                    boolean bl;
                    KtExpression ktExpression2 = ((KtPropertyAccessor)$this$isNullableType).getInitializer();
                    if (ktExpression2 != null && (ktExpression2 = CallUtilKt.getType((KtExpression)ktExpression2, (BindingContext)CanBeNonNullable.this.getBindingContext())) != null) {
                        if (KotlinTypeKt.isNullable((KotlinType)ktExpression2)) {
                            return true;
                        }
                        bl = false;
                    } else {
                        bl = false;
                    }
                    if (bl) return true;
                    KtExpression ktExpression3 = ((KtPropertyAccessor)$this$isNullableType).getBodyExpression();
                    if (ktExpression3 == null) return false;
                    PsiElement psiElement = (PsiElement)ktExpression3;
                    Function1 predicate$iv = PropertyCheckVisitor$isNullableType$$inlined$collectDescendantsOfType$default$1.INSTANCE;
                    boolean $i$f$collectDescendantsOfType = false;
                    void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType_u24default$iv;
                    boolean $i$f$collectDescendantsOfType2 = false;
                    void var9_12 = $this$collectDescendantsOfType$iv$iv;
                    Collection to$iv$iv$iv = new ArrayList();
                    boolean $i$f$collectDescendantsOfTypeTo = false;
                    void var12_16 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
                    Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtReturnExpression, Unit>(predicate$iv, to$iv$iv$iv){
                        final /* synthetic */ Function1 $predicate;
                        final /* synthetic */ Collection $to;
                        {
                            this.$predicate = $predicate;
                            this.$to = $to;
                        }

                        /*
                         * Ignored method signature, as it can't be verified against descriptor
                         */
                        public final void invoke(PsiElement it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                                this.$to.add(it);
                            }
                        }
                    };
                    boolean $i$f$forEachDescendantOfType = false;
                    PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
                    $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
                        final /* synthetic */ Function1 $action;
                        {
                            this.$action = $action;
                        }

                        public void visitElement(PsiElement element) {
                            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                            PsiElement it = element;
                            boolean bl = false;
                            super.visitElement(element);
                            if (element instanceof KtReturnExpression) {
                                this.$action.invoke((Object)element);
                            }
                        }
                    });
                    $this$collectDescendantsOfType_u24default$iv = (List)to$iv$iv$iv;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        return false;
                    }
                    Iterator iterator = $this$any$iv.iterator();
                    do {
                        if (!iterator.hasNext()) return false;
                        Object element$iv = iterator.next();
                        it = (KtReturnExpression)element$iv;
                        boolean bl2 = false;
                    } while (!this.isNullableType(it.getReturnedExpression()));
                    return true;
                }
                KtExpression ktExpression4 = $this$isNullableType;
                KtExpression ktExpression5 = ktExpression4;
                if (ktExpression4 == null) return false;
                KotlinType kotlinType = CallUtilKt.getType((KtExpression)ktExpression5, (BindingContext)CanBeNonNullable.this.getBindingContext());
                ktExpression5 = kotlinType;
                if (kotlinType == null) return false;
                if (!this.isNullableAndCanBeNonNullable((KotlinType)ktExpression5)) return false;
                return true;
            }
            boolean bl = Intrinsics.areEqual((Object)((KtConstantExpression)$this$isNullableType).getText(), (Object)"null");
            return bl;
        }

        private static final Unit collectCandidateProps$lambda$1(PropertyCheckVisitor this$0, KtProperty property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            FqName fqName = property.getFqName();
            if (fqName != null && this$0.isCandidate(property)) {
                this$0.candidateProps.put(fqName, property);
            }
            return Unit.INSTANCE;
        }
    }
}

