/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.load.java.SpecialBuiltinMembers;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.error.ErrorType;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ExplicitCollectionElementAccessMethod;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitDotQualifiedExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "isIndexGetterRecommended", "", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isIndexSetterRecommended", "getFunctionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "canReplace", "function", "shouldReplace", "isCallerMap", "unusedReturnValue", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nExplicitCollectionElementAccessMethod.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExplicitCollectionElementAccessMethod.kt\nio/gitlab/arturbosch/detekt/rules/style/ExplicitCollectionElementAccessMethod\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1755#2,3:129\n1557#2:132\n1628#2,3:133\n1557#2:136\n1628#2,3:137\n1755#2,3:140\n*S KotlinDebug\n*F\n+ 1 ExplicitCollectionElementAccessMethod.kt\nio/gitlab/arturbosch/detekt/rules/style/ExplicitCollectionElementAccessMethod\n*L\n67#1:129,3\n93#1:132\n93#1:133,3\n94#1:136\n94#1:137,3\n122#1:140,3\n*E\n"})
public final class ExplicitCollectionElementAccessMethod
extends Rule {
    @NotNull
    private final Issue issue;

    public ExplicitCollectionElementAccessMethod(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("ExplicitCollectionElementAccessMethod", Severity.Style, "Prefer usage of the indexed access operator [] for map element access or insert methods.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ ExplicitCollectionElementAccessMethod(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitDotQualifiedExpression(expression);
        KtExpression ktExpression = expression.getSelectorExpression();
        KtCallExpression ktCallExpression = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression call = ktCallExpression;
        if (this.isIndexGetterRecommended(call) || this.isIndexSetterRecommended(call)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    private final boolean isIndexGetterRecommended(KtCallExpression expression) {
        boolean bl;
        FunctionDescriptor getter;
        block5: {
            KtExpression ktExpression = expression.getCalleeExpression();
            FunctionDescriptor functionDescriptor = Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)"get") ? this.getFunctionDescriptor(expression) : null;
            if (functionDescriptor == null) {
                return false;
            }
            getter = functionDescriptor;
            List list = expression.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueArguments(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtValueArgument it = (KtValueArgument)element$iv;
                    boolean bl2 = false;
                    if (!it.isSpread()) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        return this.canReplace(getter) && this.shouldReplace(getter);
    }

    private final boolean isIndexSetterRecommended(KtCallExpression expression) {
        FunctionDescriptor setter;
        String string;
        KtExpression ktExpression = expression.getCalleeExpression();
        String string2 = string = ktExpression != null ? ktExpression.getText() : null;
        return (Intrinsics.areEqual((Object)string, (Object)"set") ? ((setter = this.getFunctionDescriptor(expression)) == null ? false : this.canReplace(setter) && this.shouldReplace(setter)) : (Intrinsics.areEqual((Object)string, (Object)"put") ? this.isCallerMap(expression) : false)) && this.unusedReturnValue(expression);
    }

    private final FunctionDescriptor getFunctionDescriptor(KtCallExpression $this$getFunctionDescriptor) {
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$getFunctionDescriptor), (BindingContext)this.getBindingContext());
        CallableDescriptor callableDescriptor = resolvedCall != null ? resolvedCall.getResultingDescriptor() : null;
        return callableDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)callableDescriptor : null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean canReplace(FunctionDescriptor function) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        List list = function.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueParameters(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getOriginal().getType().toString());
        }
        Set genericParameterTypeNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        List list2 = function.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTypeParameters(...)");
        Iterable $this$map$iv2 = list2;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeParameterDescriptor bl = (TypeParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getName().asString());
        }
        List typeParameterNames = (List)destination$iv$iv2;
        if (!genericParameterTypeNames.containsAll(typeParameterNames)) {
            return false;
        }
        return function.isOperator();
    }

    private final boolean shouldReplace(FunctionDescriptor function) {
        if (!SpecialBuiltinMembers.isFromJava((CallableMemberDescriptor)((CallableMemberDescriptor)function))) {
            return true;
        }
        DeclarationDescriptor declarationDescriptor = function.getContainingDeclaration();
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor javaClass = classDescriptor;
        Object[] objectArray = new String[]{"java.util.ArrayList", "java.util.HashMap", "java.util.LinkedHashMap"};
        return SetsKt.setOf((Object[])objectArray).contains(DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)javaClass)).asString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCallerMap(KtCallExpression expression) {
        FqName fqName;
        if (expression.getValueArguments().size() != 2) {
            return false;
        }
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)expression));
        KtExpression ktExpression = ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null;
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)ktExpression), (BindingContext)this.getBindingContext());
        ResolvedCall resolvedCall2 = resolvedCall;
        if (resolvedCall == null) return false;
        CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor();
        resolvedCall2 = callableDescriptor;
        if (callableDescriptor == null) return false;
        KotlinType kotlinType = resolvedCall2.getReturnType();
        KotlinType type = kotlinType;
        if (type == null) return false;
        if (type instanceof ErrorType) {
            return false;
        }
        String mapName = "kotlin.collections.Map";
        FqName fqName2 = TypeUtilsKt.fqNameOrNull((KotlinType)type);
        if (Intrinsics.areEqual((Object)(fqName2 != null ? fqName2.asString() : null), (Object)mapName)) return true;
        Iterable $this$any$iv = org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt.supertypes((KotlinType)type);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            KotlinType it = (KotlinType)element$iv;
            boolean bl = false;
            fqName = TypeUtilsKt.fqNameOrNull((KotlinType)it);
        } while (!Intrinsics.areEqual((Object)(fqName != null ? fqName.asString() : null), (Object)mapName));
        return true;
    }

    private final boolean unusedReturnValue(KtCallExpression expression) {
        return expression.getParent().getParent() instanceof KtBlockExpression;
    }

    public ExplicitCollectionElementAccessMethod() {
        this(null, 1, null);
    }
}

