/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ExplicitItLambdaParameter;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "getConfig", "()Lio/gitlab/arturbosch/detekt/api/Config;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitLambdaExpression", "", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nExplicitItLambdaParameter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExplicitItLambdaParameter.kt\nio/gitlab/arturbosch/detekt/rules/style/ExplicitItLambdaParameter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1557#2:79\n1628#2,3:80\n*S KotlinDebug\n*F\n+ 1 ExplicitItLambdaParameter.kt\nio/gitlab/arturbosch/detekt/rules/style/ExplicitItLambdaParameter\n*L\n57#1:79\n57#1:80,3\n*E\n"})
public final class ExplicitItLambdaParameter
extends Rule {
    @NotNull
    private final Config config;
    @NotNull
    private final Issue issue;

    public ExplicitItLambdaParameter(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.config = config;
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Declaring lambda parameters as `it` is redundant.", Debt.Companion.getFIVE_MINS());
    }

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public void visitLambdaExpression(@NotNull KtLambdaExpression lambdaExpression) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)lambdaExpression, (String)"lambdaExpression");
        super.visitLambdaExpression(lambdaExpression);
        List list = lambdaExpression.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueParameters(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtParameter ktParameter = (KtParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        List parameterNames = (List)destination$iv$iv;
        if (parameterNames.contains("it")) {
            String message = parameterNames.size() == 1 && ((KtParameter)lambdaExpression.getValueParameters().get(0)).getTypeReference() == null ? "This explicit usage of `it` as the lambda parameter name can be omitted." : "`it` should not be used as name for a lambda parameter.";
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)lambdaExpression), (int)0, (int)2, null), message, null, null, 24, null));
        }
    }
}

