/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\f\u0010\u0019\u001a\u00020\u0013*\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u001dH\u0002J\f\u0010\u001e\u001a\u00020\u000b*\u00020\u001cH\u0002J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u001dH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ExpressionBodySyntax;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "includeLineWrapping", "", "getIncludeLineWrapping$annotations", "()V", "getIncludeLineWrapping", "()Z", "includeLineWrapping$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitProperty", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "checkForExpressionBodySyntax", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "singleReturnStatement", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "containsReturnStmtsInNullableArguments", "isLineWrapped", "expression", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nExpressionBodySyntax.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpressionBodySyntax.kt\nio/gitlab/arturbosch/detekt/rules/style/ExpressionBodySyntax\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,85:1\n1#2:86\n266#3:87\n277#3,10:88\n299#3:98\n12574#4,2:99\n*S KotlinDebug\n*F\n+ 1 ExpressionBodySyntax.kt\nio/gitlab/arturbosch/detekt/rules/style/ExpressionBodySyntax\n*L\n80#1:87\n80#1:88,10\n80#1:98\n83#1:99,2\n*E\n"})
public final class ExpressionBodySyntax
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty includeLineWrapping$delegate;

    public ExpressionBodySyntax(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Functions with exact one statement, the return statement, can be rewritten with ExpressionBodySyntax.", Debt.Companion.getFIVE_MINS());
        this.includeLineWrapping$delegate = ConfigPropertyKt.config((Object)false);
    }

    public /* synthetic */ ExpressionBodySyntax(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getIncludeLineWrapping() {
        return (Boolean)this.includeLineWrapping$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="include return statements with line wraps in it")
    private static /* synthetic */ void getIncludeLineWrapping$annotations() {
    }

    public void visitProperty(@NotNull KtProperty property) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            super.visitProperty(property);
            KtPropertyAccessor ktPropertyAccessor = property.getGetter();
            if (ktPropertyAccessor != null) {
                this.checkForExpressionBodySyntax((KtDeclarationWithBody)ktPropertyAccessor);
            }
            KtPropertyAccessor ktPropertyAccessor2 = property.getSetter();
            if (ktPropertyAccessor2 == null) break block1;
            this.checkForExpressionBodySyntax((KtDeclarationWithBody)ktPropertyAccessor2);
        }
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        super.visitNamedFunction(function);
        this.checkForExpressionBodySyntax((KtDeclarationWithBody)function);
    }

    private final void checkForExpressionBodySyntax(KtDeclarationWithBody $this$checkForExpressionBodySyntax) {
        KtReturnExpression stmt;
        Object object;
        KtReturnExpression ktReturnExpression;
        KtExpression ktExpression = $this$checkForExpressionBodySyntax.getBodyExpression();
        if (ktExpression != null && (ktReturnExpression = this.singleReturnStatement(ktExpression)) != null) {
            KtReturnExpression ktReturnExpression2;
            KtReturnExpression it = ktReturnExpression2 = ktReturnExpression;
            boolean bl = false;
            object = !this.containsReturnStmtsInNullableArguments(it) ? ktReturnExpression2 : null;
        } else {
            object = stmt = null;
        }
        if (stmt != null && (this.getIncludeLineWrapping() || !this.isLineWrapped((KtExpression)stmt))) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)stmt), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    private final KtReturnExpression singleReturnStatement(KtExpression $this$singleReturnStatement) {
        Object object = $this$singleReturnStatement instanceof KtBlockExpression ? (KtBlockExpression)$this$singleReturnStatement : null;
        KtExpression ktExpression = object != null && (object = object.getStatements()) != null ? (KtExpression)CollectionsKt.singleOrNull((List)object) : null;
        return ktExpression instanceof KtReturnExpression ? (KtReturnExpression)ktExpression : null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containsReturnStmtsInNullableArguments(KtReturnExpression $this$containsReturnStmtsInNullableArguments) {
        void $this$anyDescendantOfType$iv;
        PsiElement psiElement = (PsiElement)$this$containsReturnStmtsInNullableArguments;
        Function1 predicate$iv = ExpressionBodySyntax::containsReturnStmtsInNullableArguments$lambda$1;
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtReturnExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    private final boolean isLineWrapped(KtExpression expression) {
        boolean bl;
        block1: {
            PsiElement[] psiElementArray = expression.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            Object[] $this$any$iv = psiElementArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                String string = it.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (!StringsKt.contains$default((CharSequence)string, (char)'\n', (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean containsReturnStmtsInNullableArguments$lambda$1(KtReturnExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiElement psiElement = it.getParent();
        KtBinaryExpression ktBinaryExpression = psiElement instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement : null;
        return Intrinsics.areEqual((Object)(ktBinaryExpression != null ? ktBinaryExpression.getOperationToken() : null), (Object)KtTokens.ELVIS);
    }

    public ExpressionBodySyntax() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ExpressionBodySyntax.class, "includeLineWrapping", "getIncludeLineWrapping()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

