/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.github.detekt.tooling.api.FunctionMatcher;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ValueWithReason;
import io.gitlab.arturbosch.detekt.api.ValuesWithReason;
import io.gitlab.arturbosch.detekt.api.ValuesWithReasonKt;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SyntheticPropertyDescriptor;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001*B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020)H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR'\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0012\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u0014*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006+"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenMethodCall;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "methods", "", "Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenMethodCall$Forbidden;", "getMethods$annotations", "()V", "getMethods", "()Ljava/util/List;", "methods$delegate", "Lkotlin/properties/ReadOnlyProperty;", "unwrappedGetMethod", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getUnwrappedGetMethod", "(Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;)Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "unwrappedSetMethod", "getUnwrappedSetMethod", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitDotQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "visitPrefixExpression", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "visitPostfixExpression", "Lorg/jetbrains/kotlin/psi/KtPostfixExpression;", "visitCallableReferenceExpression", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "check", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Forbidden", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nForbiddenMethodCall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForbiddenMethodCall.kt\nio/gitlab/arturbosch/detekt/rules/style/ForbiddenMethodCall\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n1454#2,5:149\n1557#2:155\n1628#2,3:156\n1#3:154\n*S KotlinDebug\n*F\n+ 1 ForbiddenMethodCall.kt\nio/gitlab/arturbosch/detekt/rules/style/ForbiddenMethodCall\n*L\n129#1:149,5\n77#1:155\n77#1:156,3\n*E\n"})
public final class ForbiddenMethodCall
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty methods$delegate;

    public ForbiddenMethodCall(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Mark forbidden methods. A forbidden method could be an invocation of an unstable / experimental method and hence you might want to mark it as forbidden in order to get warned about the usage.", Debt.Companion.getTEN_MINS());
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"kotlin.io.print", (Object)"print does not allow you to configure the output stream. Use a logger instead."), TuplesKt.to((Object)"kotlin.io.println", (Object)"println does not allow you to configure the output stream. Use a logger instead.")};
        this.methods$delegate = ConfigPropertyKt.config((Object)ValuesWithReasonKt.valuesWithReason((Pair[])pairArray), ForbiddenMethodCall::methods_delegate$lambda$1);
    }

    public /* synthetic */ ForbiddenMethodCall(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<Forbidden> getMethods() {
        return (List)this.methods$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="List of fully qualified method signatures which are forbidden. Methods can be defined without full signature (i.e. `java.time.LocalDate.now`) which will report calls of all methods with this name or with full signature (i.e. `java.time.LocalDate(java.time.Clock)`) which would report only call with this concrete signature. If you want to forbid an extension function like `fun String.hello(a: Int)` you should add the receiver parameter as the first parameter like this: `hello(kotlin.String, kotlin.Int)`. To forbid constructor calls you need to define them with `<init>`, for example `java.util.Date.<init>`. To forbid calls involving type parameters, omit them, for example `fun hello(args: Array<Any>)` is referred to as simply `hello(kotlin.Array)` (also the signature for vararg parameters). To forbid methods from the companion object reference the Companion class, for example as `TestClass.Companion.hello()` (even if it is marked `@JvmStatic`).")
    private static /* synthetic */ void getMethods$annotations() {
    }

    private final FunctionDescriptor getUnwrappedGetMethod(PropertyDescriptor $this$unwrappedGetMethod) {
        return $this$unwrappedGetMethod instanceof SyntheticPropertyDescriptor ? ((SyntheticPropertyDescriptor)$this$unwrappedGetMethod).getGetMethod() : (FunctionDescriptor)$this$unwrappedGetMethod.getGetter();
    }

    private final FunctionDescriptor getUnwrappedSetMethod(PropertyDescriptor $this$unwrappedSetMethod) {
        return $this$unwrappedSetMethod instanceof SyntheticPropertyDescriptor ? ((SyntheticPropertyDescriptor)$this$unwrappedSetMethod).getSetMethod() : (FunctionDescriptor)$this$unwrappedSetMethod.getSetter();
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitCallExpression(expression);
        this.check((KtExpression)expression);
    }

    public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitBinaryExpression(expression);
        KtOperationReferenceExpression ktOperationReferenceExpression = expression.getOperationReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"getOperationReference(...)");
        this.check((KtExpression)ktOperationReferenceExpression);
    }

    public void visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitDotQualifiedExpression(expression);
        KtExpression ktExpression = PsiUtilsKt.getCalleeExpressionIfAny((KtElement)((KtElement)expression));
        boolean bl = ktExpression != null ? KtPsiUtilKt.isDotSelector((KtExpression)ktExpression) : false;
        if (bl) {
            this.check((KtExpression)expression);
        }
    }

    public void visitPrefixExpression(@NotNull KtPrefixExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitPrefixExpression(expression);
        KtSimpleNameExpression ktSimpleNameExpression = expression.getOperationReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getOperationReference(...)");
        this.check((KtExpression)ktSimpleNameExpression);
    }

    public void visitPostfixExpression(@NotNull KtPostfixExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitPostfixExpression(expression);
        KtSimpleNameExpression ktSimpleNameExpression = expression.getOperationReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getOperationReference(...)");
        this.check((KtExpression)ktSimpleNameExpression);
    }

    public void visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitCallableReferenceExpression(expression);
        KtSimpleNameExpression ktSimpleNameExpression = expression.getCallableReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getCallableReference(...)");
        this.check((KtExpression)ktSimpleNameExpression);
    }

    /*
     * WARNING - void declaration
     */
    private final void check(KtExpression expression) {
        void destination$iv;
        Object $this$flatMapTo$iv;
        Object callableDescriptor;
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)this.getBindingContext());
        if (resolvedCall != null && (resolvedCall = resolvedCall.getResultingDescriptor()) != null) {
            Set set;
            Object[] objectArray;
            callableDescriptor = resolvedCall;
            boolean bl = false;
            if (callableDescriptor instanceof PropertyDescriptor) {
                objectArray = new FunctionDescriptor[]{this.getUnwrappedGetMethod((PropertyDescriptor)callableDescriptor), this.getUnwrappedSetMethod((PropertyDescriptor)callableDescriptor)};
                set = SetsKt.setOfNotNull((Object[])objectArray);
            } else {
                set = SetsKt.setOf((Object)callableDescriptor);
            }
            Set foundDescriptors = set;
            objectArray = foundDescriptors;
            Collection collection = new LinkedHashSet();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                CallableDescriptor it = (CallableDescriptor)element$iv;
                boolean bl2 = false;
                Iterable list$iv = SequencesKt.toSet((Sequence)DescriptorUtilsKt.overriddenTreeUniqueAsSequence((CallableDescriptor)it, (boolean)true));
                CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
            }
        } else {
            return;
        }
        Set descriptors = (Set)destination$iv;
        for (CallableDescriptor descriptor : descriptors) {
            Forbidden forbidden;
            Object v2;
            block7: {
                callableDescriptor = this.getMethods();
                Iterator bl = callableDescriptor.iterator();
                while (bl.hasNext()) {
                    $this$flatMapTo$iv = bl.next();
                    Forbidden it = (Forbidden)$this$flatMapTo$iv;
                    boolean bl3 = false;
                    if (!it.getValue().match(descriptor)) continue;
                    v2 = $this$flatMapTo$iv;
                    break block7;
                }
                v2 = null;
            }
            if ((Forbidden)v2 == null) continue;
            boolean bl = false;
            String message = forbidden.getReason() != null ? "The method `" + forbidden.getValue() + "` has been forbidden: " + forbidden.getReason() : "The method `" + forbidden.getValue() + "` has been forbidden in the detekt config.";
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), message, null, null, 24, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List methods_delegate$lambda$1(ValuesWithReason list) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Iterable $this$map$iv = (Iterable)list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ValueWithReason valueWithReason = (ValueWithReason)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Forbidden(FunctionMatcher.Companion.fromFunctionSignature(it.getValue()), it.getReason()));
        }
        return (List)destination$iv$iv;
    }

    public ForbiddenMethodCall() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ForbiddenMethodCall.class, "methods", "getMethods()Ljava/util/List;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenMethodCall$Forbidden;", "", "value", "Lio/github/detekt/tooling/api/FunctionMatcher;", "reason", "", "<init>", "(Lio/github/detekt/tooling/api/FunctionMatcher;Ljava/lang/String;)V", "getValue", "()Lio/github/detekt/tooling/api/FunctionMatcher;", "getReason", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "detekt-rules-style"})
    private static final class Forbidden {
        @NotNull
        private final FunctionMatcher value;
        @Nullable
        private final String reason;

        public Forbidden(@NotNull FunctionMatcher value, @Nullable String reason) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = value;
            this.reason = reason;
        }

        @NotNull
        public final FunctionMatcher getValue() {
            return this.value;
        }

        @Nullable
        public final String getReason() {
            return this.reason;
        }

        @NotNull
        public final FunctionMatcher component1() {
            return this.value;
        }

        @Nullable
        public final String component2() {
            return this.reason;
        }

        @NotNull
        public final Forbidden copy(@NotNull FunctionMatcher value, @Nullable String reason) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Forbidden(value, reason);
        }

        public static /* synthetic */ Forbidden copy$default(Forbidden forbidden, FunctionMatcher functionMatcher, String string, int n, Object object) {
            if ((n & 1) != 0) {
                functionMatcher = forbidden.value;
            }
            if ((n & 2) != 0) {
                string = forbidden.reason;
            }
            return forbidden.copy(functionMatcher, string);
        }

        @NotNull
        public String toString() {
            return "Forbidden(value=" + this.value + ", reason=" + this.reason + ')';
        }

        public int hashCode() {
            int result = this.value.hashCode();
            result = result * 31 + (this.reason == null ? 0 : this.reason.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Forbidden)) {
                return false;
            }
            Forbidden forbidden = (Forbidden)other;
            if (!Intrinsics.areEqual((Object)this.value, (Object)forbidden.value)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.reason, (Object)forbidden.reason);
        }
    }
}

