/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.AnnotationExcluder;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.SplitPatternKt;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.style.FunctionOnlyReturningConstantKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010+\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010,\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010-\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010.\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010/\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)H\u0002J\u0012\u00100\u001a\u00020\u000b2\b\u00101\u001a\u0004\u0018\u000102H\u0002J\u0010\u00103\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020)H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0011\u0012\u0004\b\u0013\u0010\r\u001a\u0004\b\u0014\u0010\u000fR'\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00178BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u0011\u0012\u0004\b\u0019\u0010\r\u001a\u0004\b\u001a\u0010\u001bR'\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u00178BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b \u0010\u0011\u0012\u0004\b\u001e\u0010\r\u001a\u0004\b\u001f\u0010\u001bR\u000e\u0010!\u001a\u00020\"X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/FunctionOnlyReturningConstant;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "ignoreOverridableFunction", "", "getIgnoreOverridableFunction$annotations", "()V", "getIgnoreOverridableFunction", "()Z", "ignoreOverridableFunction$delegate", "Lkotlin/properties/ReadOnlyProperty;", "ignoreActualFunction", "getIgnoreActualFunction$annotations", "getIgnoreActualFunction", "ignoreActualFunction$delegate", "excludedFunctions", "", "Lkotlin/text/Regex;", "getExcludedFunctions$annotations", "getExcludedFunctions", "()Ljava/util/List;", "excludedFunctions$delegate", "excludeAnnotatedFunction", "getExcludeAnnotatedFunction$annotations", "getExcludeAnnotatedFunction", "excludeAnnotatedFunction$delegate", "annotationExcluder", "Lio/gitlab/arturbosch/detekt/api/AnnotationExcluder;", "visit", "", "root", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isNotIgnored", "checkOverridableFunction", "checkContainingInterface", "checkActualFunction", "isNotExcluded", "isReturningAConstant", "isConstantExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "returnsConstant", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nFunctionOnlyReturningConstant.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionOnlyReturningConstant.kt\nio/gitlab/arturbosch/detekt/rules/style/FunctionOnlyReturningConstant\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n1557#2:136\n1628#2,3:137\n1557#2:140\n1628#2,3:141\n*S KotlinDebug\n*F\n+ 1 FunctionOnlyReturningConstant.kt\nio/gitlab/arturbosch/detekt/rules/style/FunctionOnlyReturningConstant\n*L\n56#1:136\n56#1:137,3\n61#1:140\n61#1:141,3\n*E\n"})
public final class FunctionOnlyReturningConstant
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty ignoreOverridableFunction$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreActualFunction$delegate;
    @NotNull
    private final ReadOnlyProperty excludedFunctions$delegate;
    @NotNull
    private final ReadOnlyProperty excludeAnnotatedFunction$delegate;
    private AnnotationExcluder annotationExcluder;

    public FunctionOnlyReturningConstant(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "A function that only returns a constant is misleading. Consider declaring a constant instead.", Debt.Companion.getTEN_MINS());
        this.ignoreOverridableFunction$delegate = ConfigPropertyKt.config((Object)true);
        this.ignoreActualFunction$delegate = ConfigPropertyKt.config((Object)true);
        this.excludedFunctions$delegate = ConfigPropertyKt.config((Object)CollectionsKt.emptyList(), FunctionOnlyReturningConstant::excludedFunctions_delegate$lambda$0);
        this.excludeAnnotatedFunction$delegate = ConfigPropertyKt.config((Object)CollectionsKt.emptyList(), FunctionOnlyReturningConstant::excludeAnnotatedFunction_delegate$lambda$2);
    }

    public /* synthetic */ FunctionOnlyReturningConstant(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getIgnoreOverridableFunction() {
        return (Boolean)this.ignoreOverridableFunction$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="if overriden functions should be ignored")
    private static /* synthetic */ void getIgnoreOverridableFunction$annotations() {
    }

    private final boolean getIgnoreActualFunction() {
        return (Boolean)this.ignoreActualFunction$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="if actual functions should be ignored")
    private static /* synthetic */ void getIgnoreActualFunction$annotations() {
    }

    private final List<Regex> getExcludedFunctions() {
        return (List)this.excludedFunctions$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @Configuration(description="excluded functions")
    private static /* synthetic */ void getExcludedFunctions$annotations() {
    }

    private final List<Regex> getExcludeAnnotatedFunction() {
        return (List)this.excludeAnnotatedFunction$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    @Configuration(description="allows to provide a list of annotations that disable this check")
    @Deprecated(message="Use `ignoreAnnotated` instead")
    private static /* synthetic */ void getExcludeAnnotatedFunction$annotations() {
    }

    public void visit(@NotNull KtFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.annotationExcluder = new AnnotationExcluder(root, this.getExcludeAnnotatedFunction(), this.getBindingContext());
        super.visit(root);
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (this.isNotIgnored(function) && this.isNotExcluded(function) && this.isReturningAConstant(function)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)function), function.getNameAsSafeName() + " is returning a constant. Prefer declaring a constant instead.", null, null, 24, null));
        }
        super.visitNamedFunction(function);
    }

    private final boolean isNotIgnored(KtNamedFunction function) {
        return this.checkOverridableFunction(function) && this.checkActualFunction(function);
    }

    private final boolean checkOverridableFunction(KtNamedFunction function) {
        return this.getIgnoreOverridableFunction() ? !(KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)function)) || KtModifierListKt.isOpen((KtModifierListOwner)((KtModifierListOwner)function)) || this.checkContainingInterface(function)) : true;
    }

    private final boolean checkContainingInterface(KtNamedFunction function) {
        KtClass containingClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)function));
        return containingClass != null && containingClass.isInterface();
    }

    private final boolean checkActualFunction(KtNamedFunction function) {
        return this.getIgnoreActualFunction() ? !KtModifierListKt.isActual((KtModifierListOwner)((KtModifierListOwner)function)) : true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNotExcluded(KtNamedFunction function) {
        if (FunctionOnlyReturningConstantKt.access$contains(this.getExcludedFunctions(), function.getName())) return false;
        AnnotationExcluder annotationExcluder = this.annotationExcluder;
        if (annotationExcluder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"annotationExcluder");
            annotationExcluder = null;
        }
        List list = function.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAnnotationEntries(...)");
        if (annotationExcluder.shouldExclude(list)) return false;
        return true;
    }

    private final boolean isReturningAConstant(KtNamedFunction function) {
        return this.isConstantExpression(function.getBodyExpression()) || this.returnsConstant(function);
    }

    private final boolean isConstantExpression(KtExpression expression) {
        if (expression instanceof KtConstantExpression) {
            return true;
        }
        return expression instanceof KtStringTemplateExpression && !((KtStringTemplateExpression)expression).hasInterpolation();
    }

    private final boolean returnsConstant(KtNamedFunction function) {
        KtReturnExpression returnExpression;
        Object[] objectArray = function.getBodyExpression();
        PsiElement psiElement = objectArray != null && (objectArray = objectArray.getChildren()) != null ? (PsiElement)ArraysKt.singleOrNull((Object[])objectArray) : null;
        KtReturnExpression ktReturnExpression = returnExpression = psiElement instanceof KtReturnExpression ? (KtReturnExpression)psiElement : null;
        return this.isConstantExpression((KtExpression)(ktReturnExpression != null ? ktReturnExpression.getReturnedExpression() : null));
    }

    /*
     * WARNING - void declaration
     */
    private static final List excludedFunctions_delegate$lambda$0(List it) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$map$iv = it;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            boolean $i$f$excludedFunctions_delegate$lambda$0$stub_for_inlining = false;
            collection.add(SplitPatternKt.simplePatternToRegex((String)p0));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List excludeAnnotatedFunction_delegate$lambda$2(List list) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Regex(StringsKt.replace$default((String)StringsKt.replace$default((String)it, (String)".", (String)"\\.", (boolean)false, (int)4, null), (String)"*", (String)".*", (boolean)false, (int)4, null)));
        }
        return (List)destination$iv$iv;
    }

    public FunctionOnlyReturningConstant() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(FunctionOnlyReturningConstant.class, "ignoreOverridableFunction", "getIgnoreOverridableFunction()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(FunctionOnlyReturningConstant.class, "ignoreActualFunction", "getIgnoreActualFunction()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(FunctionOnlyReturningConstant.class, "excludedFunctions", "getExcludedFunctions()Ljava/util/List;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(FunctionOnlyReturningConstant.class, "excludeAnnotatedFunction", "getExcludeAnnotatedFunction()Ljava/util/List;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

