/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.style.LoopWithTooManyJumpStatementsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\f\u0010\u0019\u001a\u00020\u000b*\u00020\u001aH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/LoopWithTooManyJumpStatements;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "maxJumpCount", "", "getMaxJumpCount$annotations", "()V", "getMaxJumpCount", "()I", "maxJumpCount$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitLoopExpression", "", "loopExpression", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "countBreakAndReturnStatements", "body", "Lorg/jetbrains/kotlin/psi/KtExpression;", "countBreakAndReturnStatementsInLoop", "Lorg/jetbrains/kotlin/psi/KtElement;", "detekt-rules-style"})
public final class LoopWithTooManyJumpStatements
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty maxJumpCount$delegate;

    public LoopWithTooManyJumpStatements(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "The loop contains more than one break or continue statement. The code should be refactored to increase readability.", Debt.Companion.getTEN_MINS());
        this.maxJumpCount$delegate = ConfigPropertyKt.config((Object)1);
    }

    public /* synthetic */ LoopWithTooManyJumpStatements(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getMaxJumpCount() {
        return ((Number)this.maxJumpCount$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="maximum allowed jumps in a loop")
    private static /* synthetic */ void getMaxJumpCount$annotations() {
    }

    public void visitLoopExpression(@NotNull KtLoopExpression loopExpression) {
        Intrinsics.checkNotNullParameter((Object)loopExpression, (String)"loopExpression");
        if (this.countBreakAndReturnStatements(loopExpression.getBody()) > this.getMaxJumpCount()) {
            Issue issue = this.getIssue();
            PsiElement psiElement = LoopWithTooManyJumpStatementsKt.access$getKeyword(loopExpression);
            if (psiElement == null) {
                psiElement = (PsiElement)loopExpression;
            }
            this.report((Finding)new CodeSmell(issue, Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)psiElement, (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
        super.visitLoopExpression(loopExpression);
    }

    private final int countBreakAndReturnStatements(KtExpression body) {
        KtExpression ktExpression = body;
        return ktExpression != null ? this.countBreakAndReturnStatementsInLoop((KtElement)ktExpression) : 0;
    }

    private final int countBreakAndReturnStatementsInLoop(KtElement $this$countBreakAndReturnStatementsInLoop) {
        Ref.IntRef count = new Ref.IntRef();
        $this$countBreakAndReturnStatementsInLoop.accept((PsiElementVisitor)new DetektVisitor(count){
            final /* synthetic */ Ref.IntRef $count;
            {
                this.$count = $count;
            }

            public void visitKtElement(KtElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtLoopExpression) {
                    return;
                }
                if (element instanceof KtBreakExpression || element instanceof KtContinueExpression) {
                    int n = this.$count.element;
                    this.$count.element = n + 1;
                }
                PsiElement[] psiElementArray = element.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                Object[] $this$forEach$iv = psiElementArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    it.accept((PsiElementVisitor)this);
                }
            }
        });
        return count.element;
    }

    public LoopWithTooManyJumpStatements() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(LoopWithTooManyJumpStatements.class, "maxJumpCount", "getMaxJumpCount()I", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

