/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ModifierOrder;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "order", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "kotlin.jvm.PlatformType", "[Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "visitModifierList", "", "list", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "detekt-rules-style"})
public final class ModifierOrder
extends Rule {
    @NotNull
    private final Issue issue;
    @NotNull
    private final KtModifierKeywordToken[] order;

    public ModifierOrder(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Modifiers are not in the correct order. Consider to reorder these modifiers.", Debt.Companion.getFIVE_MINS());
        KtModifierKeywordToken[] ktModifierKeywordTokenArray = new KtModifierKeywordToken[]{KtTokens.PUBLIC_KEYWORD, KtTokens.PROTECTED_KEYWORD, KtTokens.PRIVATE_KEYWORD, KtTokens.INTERNAL_KEYWORD, KtTokens.EXPECT_KEYWORD, KtTokens.ACTUAL_KEYWORD, KtTokens.FINAL_KEYWORD, KtTokens.OPEN_KEYWORD, KtTokens.ABSTRACT_KEYWORD, KtTokens.SEALED_KEYWORD, KtTokens.CONST_KEYWORD, KtTokens.EXTERNAL_KEYWORD, KtTokens.OVERRIDE_KEYWORD, KtTokens.LATEINIT_KEYWORD, KtTokens.TAILREC_KEYWORD, KtTokens.VARARG_KEYWORD, KtTokens.SUSPEND_KEYWORD, KtTokens.INNER_KEYWORD, KtTokens.ENUM_KEYWORD, KtTokens.ANNOTATION_KEYWORD, KtTokens.FUN_KEYWORD, KtTokens.COMPANION_KEYWORD, KtTokens.INLINE_KEYWORD, KtTokens.VALUE_KEYWORD, KtTokens.INFIX_KEYWORD, KtTokens.OPERATOR_KEYWORD, KtTokens.DATA_KEYWORD};
        this.order = ktModifierKeywordTokenArray;
    }

    public /* synthetic */ ModifierOrder(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitModifierList(@NotNull KtModifierList list) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        super.visitModifierList(list);
        List modifiers = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)((Sequence)PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)list))), ModifierOrder::visitModifierList$lambda$0));
        List sortedModifiers = CollectionsKt.sortedWith((Iterable)modifiers, (Comparator)new Comparator(this){
            final /* synthetic */ ModifierOrder this$0;
            {
                this.this$0 = modifierOrder;
            }

            public final int compare(T a, T b) {
                KtModifierKeywordToken it = (KtModifierKeywordToken)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(ArraysKt.indexOf((Object[])ModifierOrder.access$getOrder$p(this.this$0), (Object)it));
                it = (KtModifierKeywordToken)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(ArraysKt.indexOf((Object[])ModifierOrder.access$getOrder$p(this.this$0), (Object)it)));
            }
        });
        if (!Intrinsics.areEqual((Object)modifiers, (Object)sortedModifiers)) {
            String modifierString = CollectionsKt.joinToString$default((Iterable)sortedModifiers, (CharSequence)" ", null, null, (int)0, null, ModifierOrder::visitModifierList$lambda$2, (int)30, null);
            String string = ((Object)((Object)this)).getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            this.report((Finding)new CodeSmell(new Issue(string, Severity.Style, "Modifier order should be: " + modifierString, new Debt(0, 0, 1, 3, null)), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)list), (int)0, (int)2, null), "Modifier order should be: " + modifierString, null, null, 24, null));
        }
    }

    private static final KtModifierKeywordToken visitModifierList$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IElementType iElementType = it.getNode().getElementType();
        return iElementType instanceof KtModifierKeywordToken ? (KtModifierKeywordToken)iElementType : null;
    }

    private static final CharSequence visitModifierList$lambda$2(KtModifierKeywordToken it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        return string;
    }

    public ModifierOrder() {
        this(null, 1, null);
    }

    public static final /* synthetic */ KtModifierKeywordToken[] access$getOrder$p(ModifierOrder $this) {
        return $this.order;
    }
}

