/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.github.detekt.psi.KtFilesKt;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Location;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.SourceLocation;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.style.MultilineRawStringIndentation;
import io.gitlab.arturbosch.detekt.rules.style.MultilineRawStringIndentationKt;
import io.gitlab.arturbosch.detekt.rules.style.TrimMultilineRawStringKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.ranges.IntRange;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J$\u0010\u001d\u001a\u00020\u001a*\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000bH\u0002J\u001c\u0010!\u001a\u00020\u001a*\u00020\u001c2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$H\u0002J\u001c\u0010%\u001a\u00020\u001a*\u00020\u001c2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u000bH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR'\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0011\u0012\u0004\b\u0015\u0010\r\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006'"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/MultilineRawStringIndentation;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "indentSize", "", "getIndentSize$annotations", "()V", "getIndentSize", "()I", "indentSize$delegate", "Lkotlin/properties/ReadOnlyProperty;", "trimmingMethods", "", "", "getTrimmingMethods$annotations", "getTrimmingMethods", "()Ljava/util/List;", "trimmingMethods$delegate", "visitStringTemplateExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "checkIndentation", "baseIndent", "firstLineNumber", "lastLineNumber", "checkContent", "desiredIndent", "lineNumberRange", "Lkotlin/ranges/IntRange;", "checkClosing", "lineNumber", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nMultilineRawStringIndentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultilineRawStringIndentation.kt\nio/gitlab/arturbosch/detekt/rules/style/MultilineRawStringIndentation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n1557#2:212\n1628#2,3:213\n774#2:216\n865#2,2:217\n2642#2:219\n2632#2,3:221\n1#3:220\n1#3:224\n*S KotlinDebug\n*F\n+ 1 MultilineRawStringIndentation.kt\nio/gitlab/arturbosch/detekt/rules/style/MultilineRawStringIndentation\n*L\n110#1:212\n110#1:213,3\n117#1:216\n117#1:217,2\n118#1:219\n127#1:221,3\n118#1:220\n*E\n"})
public final class MultilineRawStringIndentation
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty indentSize$delegate;
    @NotNull
    private final ReadOnlyProperty trimmingMethods$delegate;

    public MultilineRawStringIndentation(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "The indentation of the raw String should be consistent", Debt.Companion.getFIVE_MINS());
        this.indentSize$delegate = ConfigPropertyKt.config((Object)4);
        Object[] objectArray = new String[]{"trimIndent", "trimMargin"};
        this.trimmingMethods$delegate = ConfigPropertyKt.config((Object)CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getIndentSize() {
        return ((Number)this.indentSize$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="indentation size")
    private static /* synthetic */ void getIndentSize$annotations() {
    }

    private final List<String> getTrimmingMethods() {
        return (List)this.trimmingMethods$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="allows to provide a list of multiline string trimming methods")
    private static /* synthetic */ void getTrimmingMethods$annotations() {
    }

    public void visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitStringTemplateExpression(expression);
        if (!TrimMultilineRawStringKt.isRawStringWithLineBreak(expression) || !TrimMultilineRawStringKt.isTrimmed(expression, this.getTrimmingMethods())) {
            return;
        }
        if (!MultilineRawStringIndentationKt.access$isSurroundedByLineBreaks(expression)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "A multiline raw string should start with a break line and should end with another", null, null, 24, null));
            return;
        }
        PsiFile psiFile = expression.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        TextRange textRange = expression.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        PsiDiagnosticUtils.LineAndColumn lineAndColumn = KtFilesKt.getLineAndColumnInPsiFile((PsiFile)psiFile, (TextRange)textRange);
        if (lineAndColumn == null) {
            return;
        }
        PsiDiagnosticUtils.LineAndColumn lineAndColumn2 = lineAndColumn;
        String string = expression.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        int lineCount = ((Collection)StringsKt.lines((CharSequence)string)).size();
        String string2 = lineAndColumn2.getLineContent();
        if (string2 == null) {
            return;
        }
        this.checkIndentation(expression, MultilineRawStringIndentationKt.access$countIndent(string2), lineAndColumn2.getLine(), lineAndColumn2.getLine() + lineCount - 1);
    }

    private final void checkIndentation(KtStringTemplateExpression $this$checkIndentation, int baseIndent, int firstLineNumber, int lastLineNumber) {
        this.checkContent($this$checkIndentation, baseIndent + this.getIndentSize(), new IntRange(firstLineNumber + 1, lastLineNumber - 1));
        this.checkClosing($this$checkIndentation, baseIndent, lastLineNumber);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkContent(KtStringTemplateExpression $this$checkContent, int desiredIndent, IntRange lineNumberRange) {
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J,\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0018"}, d2={"io/gitlab/arturbosch/detekt/rules/style/MultilineRawStringIndentation$checkContent$LineInformation", "", "lineNumber", "", "line", "", "currentIndent", "<init>", "(ILjava/lang/String;I)V", "getLineNumber", "()I", "getLine", "()Ljava/lang/String;", "getCurrentIndent", "component1", "component2", "component3", "copy", "(ILjava/lang/String;I)Lio/gitlab/arturbosch/detekt/rules/style/MultilineRawStringIndentation$checkContent$LineInformation;", "equals", "", "other", "hashCode", "toString", "detekt-rules-style"})
        public final class LineInformation {
            private final int lineNumber;
            private final String line;
            private final int currentIndent;

            public LineInformation(int lineNumber, String line, int currentIndent) {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                this.lineNumber = lineNumber;
                this.line = line;
                this.currentIndent = currentIndent;
            }

            public final int getLineNumber() {
                return this.lineNumber;
            }

            public final String getLine() {
                return this.line;
            }

            public final int getCurrentIndent() {
                return this.currentIndent;
            }

            public final int component1() {
                return this.lineNumber;
            }

            public final String component2() {
                return this.line;
            }

            public final int component3() {
                return this.currentIndent;
            }

            public final LineInformation copy(int lineNumber, String line, int currentIndent) {
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                return new LineInformation(lineNumber, line, currentIndent);
            }

            public static /* synthetic */ LineInformation copy$default(LineInformation lineInformation, int n, String string, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = lineInformation.lineNumber;
                }
                if ((n3 & 2) != 0) {
                    string = lineInformation.line;
                }
                if ((n3 & 4) != 0) {
                    n2 = lineInformation.currentIndent;
                }
                return lineInformation.copy(n, string, n2);
            }

            public String toString() {
                return "LineInformation(lineNumber=" + this.lineNumber + ", line=" + this.line + ", currentIndent=" + this.currentIndent + ')';
            }

            public int hashCode() {
                int result = Integer.hashCode(this.lineNumber);
                result = result * 31 + this.line.hashCode();
                result = result * 31 + Integer.hashCode(this.currentIndent);
                return result;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LineInformation)) {
                    return false;
                }
                LineInformation lineInformation = (LineInformation)other;
                if (this.lineNumber != lineInformation.lineNumber) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.line, (Object)lineInformation.line)) {
                    return false;
                }
                return this.currentIndent == lineInformation.currentIndent;
            }
        }
        String line;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = (Iterable)lineNumberRange;
        boolean $i$f$map = false;
        void var7_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Object object = $this$mapTo$iv$iv.iterator();
        while (object.hasNext()) {
            void lineNumber;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)object).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PsiFile psiFile = $this$checkContent.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            line = MultilineRawStringIndentationKt.access$getLine(psiFile, (int)lineNumber);
            collection.add(new LineInformation((int)lineNumber, line, MultilineRawStringIndentationKt.access$countIndent(line)));
        }
        List indentation = (List)destination$iv$iv;
        if (!((Collection)indentation).isEmpty()) {
            void $this$onEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            $this$map$iv = indentation;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                LineInformation lineNumber = (LineInformation)element$iv$iv;
                boolean bl = false;
                line = lineNumber.component2();
                int currentIndent = lineNumber.component3();
                if (!(((CharSequence)line).length() > 0 && currentIndent < desiredIndent)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$onEach = false;
            void $this$onEach_u24lambda_u2419$iv = $this$filterTo$iv$iv = $this$onEach$iv;
            boolean bl = false;
            for (Object element$iv2 : $this$onEach_u24lambda_u2419$iv) {
                LineInformation lineNumber = (LineInformation)element$iv2;
                boolean bl2 = false;
                int lineNumber2 = lineNumber.component1();
                String line2 = lineNumber.component2();
                int currentIndent = lineNumber.component3();
                PsiFile psiFile = $this$checkContent.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                Location location = MultilineRawStringIndentationKt.access$getLocation(psiFile, new SourceLocation(lineNumber2, StringsKt.isBlank((CharSequence)line2) ? 1 : currentIndent + 1), new SourceLocation(lineNumber2, line2.length() + 1));
                MultilineRawStringIndentationKt.access$report(this, (KtElement)$this$checkContent, location, MultilineRawStringIndentationKt.access$message(desiredIndent, currentIndent));
            }
            iterable = (Collection)$this$filterTo$iv$iv;
            if (iterable.isEmpty()) {
                boolean bl3;
                block11: {
                    boolean bl4 = false;
                    Iterable $this$none$iv = indentation;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            LineInformation element$iv2 = (LineInformation)element$iv;
                            boolean bl5 = false;
                            int currentIndent = element$iv2.component3();
                            if (!(currentIndent == desiredIndent)) continue;
                            bl3 = false;
                            break block11;
                        }
                        bl3 = true;
                    }
                }
                if (bl3) {
                    int indent;
                    PsiFile psiFile = $this$checkContent.getContainingFile();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
                    Location location = MultilineRawStringIndentationKt.access$getLocation(psiFile, new SourceLocation(lineNumberRange.getFirst(), desiredIndent + 1), new SourceLocation(lineNumberRange.getLast(), ((LineInformation)CollectionsKt.last((List)indentation)).getLine().length() + 1));
                    Iterable iterable2 = indentation;
                    int n = desiredIndent;
                    Location location2 = location;
                    KtElement ktElement = (KtElement)$this$checkContent;
                    Rule rule = this;
                    Iterator iterator = iterable2.iterator();
                    if (!iterator.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    object = (LineInformation)iterator.next();
                    boolean bl6 = false;
                    int n2 = indent = ((LineInformation)object).component3();
                    while (iterator.hasNext()) {
                        LineInformation lineInformation = (LineInformation)iterator.next();
                        $i$a$-minOf-MultilineRawStringIndentation$checkContent$3$2 = false;
                        int indent2 = lineInformation.component3();
                        int n3 = indent2;
                        if (n2 <= n3) continue;
                        n2 = n3;
                    }
                    int n4 = n2;
                    MultilineRawStringIndentationKt.access$report(rule, ktElement, location2, MultilineRawStringIndentationKt.access$message(n, n4));
                }
            }
        }
    }

    private final void checkClosing(KtStringTemplateExpression $this$checkClosing, int desiredIndent, int lineNumber) {
        PsiFile psiFile = $this$checkClosing.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        int currentIndent = MultilineRawStringIndentationKt.access$countIndent(MultilineRawStringIndentationKt.access$getLine(psiFile, lineNumber));
        if (currentIndent != desiredIndent) {
            Location location;
            if (currentIndent < desiredIndent) {
                PsiFile psiFile2 = $this$checkClosing.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
                location = MultilineRawStringIndentationKt.access$getLocation(psiFile2, new SourceLocation(lineNumber, currentIndent + 1), new SourceLocation(lineNumber, currentIndent + 3 + 1));
            } else {
                PsiFile psiFile3 = $this$checkClosing.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile3, (String)"getContainingFile(...)");
                location = MultilineRawStringIndentationKt.access$getLocation(psiFile3, new SourceLocation(lineNumber, desiredIndent + 1), new SourceLocation(lineNumber, currentIndent + 1));
            }
            Location location2 = location;
            MultilineRawStringIndentationKt.access$report(this, (KtElement)$this$checkClosing, location2, MultilineRawStringIndentationKt.access$message(desiredIndent, currentIndent));
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MultilineRawStringIndentation.class, "indentSize", "getIndentSize()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MultilineRawStringIndentation.class, "trimmingMethods", "getTrimmingMethods()Ljava/util/List;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

