/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.IsPartOfUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\rH\u0002J\f\u0010\u0010\u001a\u00020\u000f*\u00020\rH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/NoTabs;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitWhiteSpace", "", "space", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiWhiteSpace;", "isTab", "", "isStringInterpolated", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nNoTabs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NoTabs.kt\nio/gitlab/arturbosch/detekt/rules/style/NoTabs\n+ 2 IsPartOfUtils.kt\nio/gitlab/arturbosch/detekt/rules/IsPartOfUtilsKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,45:1\n10#2:46\n146#3:47\n*S KotlinDebug\n*F\n+ 1 NoTabs.kt\nio/gitlab/arturbosch/detekt/rules/style/NoTabs\n*L\n43#1:46\n43#1:47\n*E\n"})
public final class NoTabs
extends Rule {
    @NotNull
    private final Issue issue;

    public NoTabs(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Checks if tabs are used in Kotlin files.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ NoTabs(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitWhiteSpace(@NotNull PsiWhiteSpace space) {
        Intrinsics.checkNotNullParameter((Object)space, (String)"space");
        super.visitWhiteSpace(space);
        if (this.isTab(space)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)space), (int)0, (int)2, null), "Tab character is in use.", null, null, 24, null));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTab(PsiWhiteSpace $this$isTab) {
        if (IsPartOfUtilsKt.isPartOfString((PsiElement)((PsiElement)$this$isTab))) {
            if (!this.isStringInterpolated($this$isTab)) return false;
        }
        String string = $this$isTab.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (!StringsKt.contains$default((CharSequence)string, (char)'\t', (boolean)false, (int)2, null)) return false;
        return true;
    }

    private final boolean isStringInterpolated(PsiWhiteSpace $this$isStringInterpolated) {
        PsiElement $this$isPartOf$iv = (PsiElement)$this$isStringInterpolated;
        boolean $i$f$isPartOf = false;
        PsiElement $this$getNonStrictParentOfType$iv$iv = $this$isPartOf$iv;
        boolean $i$f$getNonStrictParentOfType = false;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv$iv, KtStringTemplateEntryWithExpression.class, (boolean)false) != null;
    }

    public NoTabs() {
        this(null, 1, null);
    }
}

