/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.style.SpacingBetweenPackageAndImports$checkKtElementsDeclaration$;
import io.gitlab.arturbosch.detekt.rules.style.SpacingBetweenPackageAndImports$visitKtFile$;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/SpacingBetweenPackageAndImports;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "hasPackage", "", "checkPackageDeclaration", "importList", "Lorg/jetbrains/kotlin/psi/KtImportList;", "isPackageDeclaration", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "checkKtElementsDeclaration", "checkLinebreakAfterElement", "message", "", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nSpacingBetweenPackageAndImports.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpacingBetweenPackageAndImports.kt\nio/gitlab/arturbosch/detekt/rules/style/SpacingBetweenPackageAndImports\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,97:1\n265#2,2:98\n277#2,10:100\n299#2:110\n477#3:111\n1104#4,3:112\n*S KotlinDebug\n*F\n+ 1 SpacingBetweenPackageAndImports.kt\nio/gitlab/arturbosch/detekt/rules/style/SpacingBetweenPackageAndImports\n*L\n48#1:98,2\n48#1:100,10\n48#1:110\n75#1:111\n90#1:112,3\n*E\n"})
public final class SpacingBetweenPackageAndImports
extends Rule {
    @NotNull
    private final Issue issue;

    public SpacingBetweenPackageAndImports(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Violation of the package declaration style detected.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ SpacingBetweenPackageAndImports(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitKtFile(@NotNull KtFile file) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (!this.hasPackage(file)) break block3;
            PsiElement $this$anyDescendantOfType_u24default$iv = (PsiElement)file;
            Function1 predicate$iv = visitKtFile$$inlined$anyDescendantOfType$default$1.INSTANCE;
            boolean $i$f$anyDescendantOfType = false;
            PsiElement $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType_u24default$iv;
            boolean $i$f$findDescendantOfType = false;
            PsiElement $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
            boolean $i$f$findDescendantOfType2 = false;
            PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
            Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
            $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Ref.ObjectRef $result;
                {
                    this.$predicate = $predicate;
                    this.$result = $result;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (element instanceof KtClassOrObject && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                        this.$result.element = element;
                        this.stopWalking();
                        return;
                    }
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                }
            });
            if ((PsiElement)result$iv$iv$iv.element != null) {
                KtImportList ktImportList = file.getImportList();
                if (ktImportList != null) {
                    KtImportList it = ktImportList;
                    boolean bl = false;
                    List list = it.getImports();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getImports(...)");
                    if (!((Collection)list).isEmpty()) {
                        this.checkPackageDeclaration(it);
                        this.checkKtElementsDeclaration(it);
                    }
                }
            }
        }
    }

    private final boolean hasPackage(KtFile $this$hasPackage) {
        Object object = $this$hasPackage.getPackageDirective();
        return object != null && (object = object.getName()) != null ? ((CharSequence)object).length() > 0 : false;
    }

    private final void checkPackageDeclaration(KtImportList importList) {
        PsiElement prevSibling = importList.getPrevSibling();
        if (this.isPackageDeclaration(prevSibling) || prevSibling instanceof PsiWhiteSpace) {
            Intrinsics.checkNotNull((Object)prevSibling);
            this.checkLinebreakAfterElement(prevSibling, "There should be exactly one empty line in between the package declaration and the list of imports.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPackageDeclaration(PsiElement element) {
        if (!(element instanceof KtPackageDirective)) return false;
        String string = ((KtPackageDirective)element).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (((CharSequence)string).length() <= 0) return false;
        return true;
    }

    private final void checkKtElementsDeclaration(KtImportList importList) {
        Sequence $this$filterIsInstance$iv = PsiUtilsKt.siblings$default((PsiElement)((PsiElement)importList), (boolean)false, (boolean)false, (int)1, null);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)checkKtElementsDeclaration$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        KtElement ktElement = (KtElement)SequencesKt.firstOrNull((Sequence)sequence);
        if (ktElement == null) {
            return;
        }
        KtElement ktElement2 = ktElement;
        PsiElement nextSibling = importList.getNextSibling();
        if (nextSibling instanceof PsiWhiteSpace || nextSibling instanceof KtElement) {
            Object object = ktElement2 instanceof KtClassOrObject ? (KtClassOrObject)ktElement2 : null;
            if (object == null || (object = object.getName()) == null) {
                object = "the class or object";
            }
            Object name = object;
            this.checkLinebreakAfterElement(nextSibling, "There should be exactly one empty line in between the list of imports and the declaration of " + (String)name + '.');
        }
    }

    private final void checkLinebreakAfterElement(PsiElement element, String message) {
        if (element instanceof PsiWhiteSpace || element instanceof KtElement) {
            String string = element.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            CharSequence $this$count$iv = string;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int i = 0; i < $this$count$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$count$iv.charAt(i);
                boolean bl = false;
                if (!(it == '\n')) continue;
                ++count$iv;
            }
            int count = count$iv;
            if (count != 2) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)element, (int)0, (int)2, null), message, null, null, 24, null));
            }
        }
    }

    public SpacingBetweenPackageAndImports() {
        this(null, 1, null);
    }
}

