/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0018\u0010\u0003\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a\f\u0010\u0007\u001a\u00020\u0001*\u00020\u0002H\u0002\u00a8\u0006\b"}, d2={"isRawStringWithLineBreak", "", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "isTrimmed", "trimmingMethods", "", "", "isExpectedAsConstant", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nTrimMultilineRawString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrimMultilineRawString.kt\nio/gitlab/arturbosch/detekt/rules/style/TrimMultilineRawStringKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Junk.kt\nio/gitlab/arturbosch/detekt/rules/JunkKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n12574#2:115\n12575#2:117\n40#3:116\n40#3:118\n40#3:123\n142#4:119\n142#4:121\n142#4:122\n1#5:120\n*S KotlinDebug\n*F\n+ 1 TrimMultilineRawString.kt\nio/gitlab/arturbosch/detekt/rules/style/TrimMultilineRawStringKt\n*L\n81#1:115\n81#1:117\n82#1:116\n89#1:118\n109#1:123\n100#1:119\n103#1:121\n107#1:122\n*E\n"})
public final class TrimMultilineRawStringKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isRawStringWithLineBreak(@NotNull KtStringTemplateExpression $this$isRawStringWithLineBreak) {
        Intrinsics.checkNotNullParameter((Object)$this$isRawStringWithLineBreak, (String)"<this>");
        String string = $this$isRawStringWithLineBreak.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"\"\"\"", (boolean)false, (int)2, null)) return false;
        String string2 = $this$isRawStringWithLineBreak.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        if (!StringsKt.endsWith$default((String)string2, (String)"\"\"\"", (boolean)false, (int)2, null)) return false;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = $this$isRawStringWithLineBreak.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
        Object[] $this$any$iv = ktStringTemplateEntryArray;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            String literalText;
            Object element$iv = $this$any$iv[n];
            KtStringTemplateEntry it = (KtStringTemplateEntry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            KtStringTemplateEntry $this$safeAs$iv = it;
            boolean $i$f$safeAs = false;
            KtStringTemplateEntry ktStringTemplateEntry = $this$safeAs$iv;
            if (!(ktStringTemplateEntry instanceof KtLiteralStringTemplateEntry)) {
                ktStringTemplateEntry = null;
            }
            KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = (KtLiteralStringTemplateEntry)ktStringTemplateEntry;
            String string3 = literalText = ktLiteralStringTemplateEntry != null ? ktLiteralStringTemplateEntry.getText() : null;
            if (literalText != null && StringsKt.contains$default((CharSequence)literalText, (CharSequence)"\n", (boolean)false, (int)2, null)) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static final boolean isTrimmed(@NotNull KtStringTemplateExpression $this$isTrimmed, @NotNull List<String> trimmingMethods) {
        Intrinsics.checkNotNullParameter((Object)$this$isTrimmed, (String)"<this>");
        Intrinsics.checkNotNullParameter(trimmingMethods, (String)"trimmingMethods");
        var3_2 = KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)((KtExpression)$this$isTrimmed));
        if (var3_2 == null || (var4_3 = var3_2.getSelectorExpression()) == null) ** GOTO lbl-1000
        var6_4 = var4_3;
        $i$f$safeAs = false;
        v0 = $this$safeAs$iv;
        if (!(v0 instanceof KtCallExpression)) {
            v0 = null;
        }
        if ((var5_6 = (KtCallExpression)v0) != null && (var6_4 = var5_6.getCalleeExpression()) != null) {
            v1 = var6_4.getText();
        } else lbl-1000:
        // 2 sources

        {
            v1 = null;
        }
        nextCall = v1;
        return CollectionsKt.contains((Iterable)trimmingMethods, nextCall);
    }

    private static final boolean isExpectedAsConstant(KtStringTemplateExpression $this$isExpectedAsConstant) {
        KtClass primaryConstructor;
        KtClass ktClass;
        KtClass ktClass2;
        PsiElement parameter;
        PsiElement psiElement;
        Object object;
        PsiElement argument;
        PsiElement psiElement2;
        Object object2;
        PsiElement property;
        Object object3;
        KtExpression ktExpression = KtPsiUtil.safeDeparenthesize((KtExpression)((KtExpression)$this$isExpectedAsConstant));
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"safeDeparenthesize(...)");
        KtExpression expression = ktExpression;
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$isExpectedAsConstant;
        boolean $i$f$getStrictParentOfType = false;
        KtProperty ktProperty = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtProperty.class, (boolean)true);
        if (ktProperty != null) {
            PsiElement it = $this$getStrictParentOfType$iv = ktProperty;
            boolean bl = false;
            object3 = Intrinsics.areEqual((Object)it.getInitializer(), (Object)expression) ? $this$getStrictParentOfType$iv : null;
        } else {
            object3 = property = null;
        }
        if (property != null && KtModifierListKt.isConstant((KtModifierListOwner)((KtModifierListOwner)property))) {
            return true;
        }
        PsiElement $this$getStrictParentOfType$iv2 = (PsiElement)expression;
        boolean $i$f$getStrictParentOfType2 = false;
        $this$getStrictParentOfType$iv = (KtValueArgument)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv2, KtValueArgument.class, (boolean)true);
        if ($this$getStrictParentOfType$iv != null) {
            PsiElement it = $this$getStrictParentOfType$iv2 = $this$getStrictParentOfType$iv;
            boolean bl = false;
            object2 = Intrinsics.areEqual((Object)it.getArgumentExpression(), (Object)expression) ? $this$getStrictParentOfType$iv2 : null;
        } else {
            object2 = null;
        }
        if (((psiElement2 = (argument = object2)) != null && (psiElement2 = psiElement2.getParent()) != null ? psiElement2.getParent() : null) instanceof KtAnnotationEntry) {
            return true;
        }
        PsiElement $this$getStrictParentOfType$iv3 = (PsiElement)expression;
        boolean $i$f$getStrictParentOfType3 = false;
        $this$getStrictParentOfType$iv2 = (KtParameter)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv3, KtParameter.class, (boolean)true);
        if ($this$getStrictParentOfType$iv2 != null) {
            PsiElement psiElement3;
            PsiElement it = psiElement3 = $this$getStrictParentOfType$iv2;
            boolean bl = false;
            object = Intrinsics.areEqual((Object)it.getDefaultValue(), (Object)expression) ? psiElement3 : null;
        } else {
            object = null;
        }
        if ((psiElement = (parameter = object)) != null && (psiElement = psiElement.getParent()) != null && (psiElement = psiElement.getParent()) != null) {
            PsiElement $this$safeAs$iv = psiElement;
            boolean $i$f$safeAs = false;
            PsiElement psiElement4 = $this$safeAs$iv;
            if (!(psiElement4 instanceof KtPrimaryConstructor)) {
                psiElement4 = null;
            }
            ktClass2 = (KtPrimaryConstructor)psiElement4;
        } else {
            ktClass2 = null;
        }
        return (ktClass = (primaryConstructor = ktClass2)) != null && (ktClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)ktClass))) != null ? ktClass.isAnnotation() : false;
    }

    public static final /* synthetic */ boolean access$isExpectedAsConstant(KtStringTemplateExpression $receiver) {
        return TrimMultilineRawStringKt.isExpectedAsConstant($receiver);
    }
}

