/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.JunkKt;
import io.gitlab.arturbosch.detekt.rules.style.UnnecessaryApplyKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\rH\u0002J\f\u0010\u0010\u001a\u00020\u000f*\u00020\rH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryApply;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isApplyExpr", "", "hasOnlyOneMemberAccessStatement", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUnnecessaryApply.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnnecessaryApply.kt\nio/gitlab/arturbosch/detekt/rules/style/UnnecessaryApply\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,107:1\n310#2,14:108\n229#2,2:122\n241#2:124\n328#2:125\n*S KotlinDebug\n*F\n+ 1 UnnecessaryApply.kt\nio/gitlab/arturbosch/detekt/rules/style/UnnecessaryApply\n*L\n93#1:108,14\n93#1:122,2\n93#1:124\n93#1:125\n*E\n"})
public final class UnnecessaryApply
extends Rule {
    @NotNull
    private final Issue issue;

    public UnnecessaryApply(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "The `apply` usage is unnecessary and can be removed.", Debt.Companion.getFIVE_MINS());
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitCallExpression(expression);
        if (this.isApplyExpr(expression) && this.hasOnlyOneMemberAccessStatement(expression) && !JunkKt.receiverIsUsed((KtCallExpression)expression, (BindingContext)this.getBindingContext())) {
            String message = expression.getParent() instanceof KtSafeQualifiedExpression ? "apply can be replaced with let or an if" : "apply expression can be omitted";
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), message, null, null, 24, null));
        }
    }

    private final boolean isApplyExpr(KtCallExpression $this$isApplyExpr) {
        ResolvedCall resolvedCall;
        KtExpression ktExpression = $this$isApplyExpr.getCalleeExpression();
        return (ktExpression != null ? ktExpression.textMatches((CharSequence)"apply") : false) && Intrinsics.areEqual((resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$isApplyExpr), (BindingContext)this.getBindingContext())) != null && (resolvedCall = resolvedCall.getResultingDescriptor()) != null ? DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)resolvedCall)) : null, (Object)UnnecessaryApplyKt.access$getAPPLY_FQ_NAME$p());
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasOnlyOneMemberAccessStatement(KtCallExpression $this$hasOnlyOneMemberAccessStatement) {
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        void $this$collectDescendantsOfType$iv;
        List list = $this$hasOnlyOneMemberAccessStatement.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getLambdaArguments(...)");
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.firstOrNull((List)list);
        if (ktLambdaArgument == null || (ktLambdaArgument = ktLambdaArgument.getLambdaExpression()) == null) {
            return false;
        }
        KtLambdaArgument lambda = ktLambdaArgument;
        Object object = lambda.getBodyExpression();
        if (object == null || (object = object.getStatements()) == null || (object = (KtExpression)CollectionsKt.singleOrNull((List)object)) == null) {
            return false;
        }
        Object singleStatement = object;
        if (singleStatement instanceof KtBinaryExpression) {
            if (!KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)singleStatement).getOperationToken())) {
                return false;
            }
            KtExpression ktExpression = ((KtBinaryExpression)singleStatement).getLeft();
            if (ktExpression == null) {
                return false;
            }
            singleStatement = ktExpression;
        } else if (!(singleStatement instanceof KtThisExpression || singleStatement instanceof KtReferenceExpression || singleStatement instanceof KtDotQualifiedExpression)) {
            return false;
        }
        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.FUNCTION, (Object)lambda.getFunctionLiteral());
        if (simpleFunctionDescriptor == null) {
            return false;
        }
        SimpleFunctionDescriptor lambdaDescriptor = simpleFunctionDescriptor;
        PsiElement psiElement = (PsiElement)singleStatement;
        Function1 predicate$iv = arg_0 -> UnnecessaryApply.hasOnlyOneMemberAccessStatement$lambda$0(this, lambdaDescriptor, arg_0);
        boolean $i$f$collectDescendantsOfType = false;
        void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        void var10_10 = $this$collectDescendantsOfType$iv$iv;
        Collection to$iv$iv$iv = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void var13_13 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtNameReferenceExpression, Unit>(predicate$iv, to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtNameReferenceExpression) {
                    this.$action.invoke((Object)element);
                }
            }
        });
        return ((List)to$iv$iv$iv).size() == 1;
    }

    private static final boolean hasOnlyOneMemberAccessStatement$lambda$0(UnnecessaryApply this$0, SimpleFunctionDescriptor $lambdaDescriptor, KtNameReferenceExpression it) {
        ResolvedCall resolvedCall;
        ResolvedCall resolvedCall2;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ResolvedCall resolvedCall3 = CallUtilKt.getResolvedCall((KtElement)((KtElement)it), (BindingContext)this$0.getBindingContext());
        return it.getParent() instanceof KtThisExpression ? Intrinsics.areEqual((Object)((resolvedCall2 = resolvedCall3) != null && (resolvedCall2 = resolvedCall2.getResultingDescriptor()) != null ? resolvedCall2.getContainingDeclaration() : null), (Object)$lambdaDescriptor) : Intrinsics.areEqual((Object)((resolvedCall = resolvedCall3) != null && (resolvedCall = ResolvedCallUtilKt.getImplicitReceiverValue((ResolvedCall)resolvedCall)) != null ? resolvedCall.getDeclarationDescriptor() : null), (Object)$lambdaDescriptor);
    }
}

