/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtSimpleNameStringTemplateEntry;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00020\u000f*\u00020\u0012H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryBackticks;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitKtElement", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "hasUnnecessaryBackticks", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "isKeyword", "", "Companion", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUnnecessaryBackticks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnnecessaryBackticks.kt\nio/gitlab/arturbosch/detekt/rules/style/UnnecessaryBackticks\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,63:1\n1317#2,2:64\n142#3:66\n1069#4,2:67\n11165#5:69\n11500#5,3:70\n*S KotlinDebug\n*F\n+ 1 UnnecessaryBackticks.kt\nio/gitlab/arturbosch/detekt/rules/style/UnnecessaryBackticks\n*L\n41#1:64,2\n52#1:66\n57#1:67,2\n60#1:69\n60#1:70,3\n*E\n"})
public final class UnnecessaryBackticks
extends Rule {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Issue issue;
    @NotNull
    private static final List<String> KEYWORDS;

    public UnnecessaryBackticks(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Backticks are unnecessary.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UnnecessaryBackticks(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitKtElement(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)((Sequence)PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)element))), arg_0 -> UnnecessaryBackticks.visitKtElement$lambda$0(this, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)it, (int)0, (int)2, null), "Backticks are unnecessary.", null, null, 24, null));
        }
        super.visitKtElement(element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasUnnecessaryBackticks(PsiElement $this$hasUnnecessaryBackticks) {
        String string = $this$hasUnnecessaryBackticks.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String unquoted = StringsKt.dropLast((String)StringsKt.drop((String)string, (int)1), (int)1);
        String string2 = $this$hasUnnecessaryBackticks.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        if (!StringsKt.startsWith$default((String)string2, (String)"`", (boolean)false, (int)2, null)) return false;
        String string3 = $this$hasUnnecessaryBackticks.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        if (!StringsKt.endsWith$default((String)string3, (String)"`", (boolean)false, (int)2, null)) {
            return false;
        }
        if (!KtPsiUtilKt.isIdentifier((String)unquoted)) return false;
        if (this.isKeyword(unquoted)) {
            return false;
        }
        PsiElement $this$getStrictParentOfType$iv = $this$hasUnnecessaryBackticks;
        boolean $i$f$getStrictParentOfType = false;
        KtSimpleNameStringTemplateEntry ktSimpleNameStringTemplateEntry = (KtSimpleNameStringTemplateEntry)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtSimpleNameStringTemplateEntry.class, (boolean)true);
        boolean bl = KtPsiUtilKt.canPlaceAfterSimpleNameEntry((PsiElement)(ktSimpleNameStringTemplateEntry != null ? ktSimpleNameStringTemplateEntry.getNextSibling() : null));
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isKeyword(String $this$isKeyword) {
        if (KEYWORDS.contains($this$isKeyword)) return true;
        CharSequence $this$all$iv = $this$isKeyword;
        boolean $i$f$all = false;
        int n = 0;
        while (n < $this$all$iv.length()) {
            char element$iv;
            char it = element$iv = $this$all$iv.charAt(n);
            boolean bl = false;
            if (it != '_') return false;
            boolean bl2 = true;
            if (!bl2) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static final boolean visitKtElement$lambda$0(UnnecessaryBackticks this$0, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)KtTokens.IDENTIFIER) && this$0.hasUnnecessaryBackticks(it);
    }

    public UnnecessaryBackticks() {
        this(null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        IElementType[] iElementTypeArray = KtTokens.KEYWORDS.getTypes();
        Intrinsics.checkNotNullExpressionValue((Object)iElementTypeArray, (String)"getTypes(...)");
        Object[] $this$map$iv = iElementTypeArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IElementType iElementType = (IElementType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toString());
        }
        KEYWORDS = (List)var3_3;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryBackticks$Companion;", "", "<init>", "()V", "KEYWORDS", "", "", "Lkotlin/jvm/internal/EnhancedNullability;", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

