/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.style.UnusedPrivateClassKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtDoubleColonExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnusedPrivateClass;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "defaultRuleIdAliases", "", "", "getDefaultRuleIdAliases", "()Ljava/util/Set;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visit", "", "root", "Lorg/jetbrains/kotlin/psi/KtFile;", "UnusedClassVisitor", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUnusedPrivateClass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnusedPrivateClass.kt\nio/gitlab/arturbosch/detekt/rules/style/UnusedPrivateClass\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,212:1\n1863#2,2:213\n*S KotlinDebug\n*F\n+ 1 UnusedPrivateClass.kt\nio/gitlab/arturbosch/detekt/rules/style/UnusedPrivateClass\n*L\n61#1:213,2\n*E\n"})
public final class UnusedPrivateClass
extends Rule {
    @NotNull
    private final Set<String> defaultRuleIdAliases;
    @NotNull
    private final Issue issue;

    public UnusedPrivateClass(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.defaultRuleIdAliases = SetsKt.setOf((Object)"unused");
        this.issue = new Issue("UnusedPrivateClass", Severity.Maintainability, "Private class is unused and should be removed.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UnusedPrivateClass(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Set<String> getDefaultRuleIdAliases() {
        return this.defaultRuleIdAliases;
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visit(@NotNull KtFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        super.visit(root);
        UnusedClassVisitor classVisitor = new UnusedClassVisitor();
        root.accept((PsiElementVisitor)classVisitor);
        Iterable $this$forEach$iv = classVisitor.getUnusedClasses();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtNamedDeclaration it = (KtNamedDeclaration)element$iv;
            boolean bl = false;
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it), (int)0, (int)2, null), "Private class " + it.getNameAsSafeName().getIdentifier() + " is unused.", null, null, 24, null));
        }
    }

    public UnusedPrivateClass() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fJ\f\u0010\r\u001a\u00020\u000e*\u00020\u0006H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00102\u0006\u0010,\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020\u00102\u0006\u0010,\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\u00102\u0006\u0010,\u001a\u000203H\u0016J\u0012\u00104\u001a\u00020\u00102\b\u00105\u001a\u0004\u0018\u000106H\u0002J\u0010\u00107\u001a\u00020\u00102\u0006\u0010,\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020\bH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnusedPrivateClass$UnusedClassVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "<init>", "()V", "privateClasses", "", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "namedClasses", "", "importedFqNames", "Lorg/jetbrains/kotlin/name/FqName;", "getUnusedClasses", "", "isUsed", "", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitImportDirective", "importDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "visitAnnotationEntry", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "registerAccess", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "visitFunctionType", "type", "Lorg/jetbrains/kotlin/psi/KtFunctionType;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitBinaryWithTypeRHSExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "visitIsExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitDoubleColonExpression", "Lorg/jetbrains/kotlin/psi/KtDoubleColonExpression;", "checkReceiverForClassUsage", "receiver", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitDotQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "looksLikeAClassName", "maybeClassName", "detekt-rules-style"})
    @SourceDebugExtension(value={"SMAP\nUnusedPrivateClass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnusedPrivateClass.kt\nio/gitlab/arturbosch/detekt/rules/style/UnusedPrivateClass$UnusedClassVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 Junk.kt\nio/gitlab/arturbosch/detekt/rules/JunkKt\n*L\n1#1,212:1\n774#2:213\n865#2,2:214\n1755#2,2:216\n1734#2,3:218\n1757#2:221\n1611#2,9:222\n1863#2:231\n1864#2:233\n1620#2:234\n1863#2,2:235\n1863#2,2:240\n1611#2,9:242\n1863#2:251\n1864#2:253\n1620#2:254\n1863#2,2:255\n1#3:232\n1#3:237\n1#3:252\n1#3:258\n1317#4,2:238\n40#5:257\n*S KotlinDebug\n*F\n+ 1 UnusedPrivateClass.kt\nio/gitlab/arturbosch/detekt/rules/style/UnusedPrivateClass$UnusedClassVisitor\n*L\n74#1:213\n74#1:214,2\n80#1:216,2\n81#1:218,3\n80#1:221\n90#1:222,9\n90#1:231\n90#1:233\n90#1:234\n91#1:235,2\n139#1:240,2\n168#1:242,9\n168#1:251\n168#1:253\n168#1:254\n169#1:255,2\n90#1:232\n168#1:252\n120#1:238,2\n176#1:257\n*E\n"})
    private static final class UnusedClassVisitor
    extends DetektVisitor {
        @NotNull
        private final Set<KtNamedDeclaration> privateClasses = new LinkedHashSet();
        @NotNull
        private final Set<String> namedClasses = new LinkedHashSet();
        @NotNull
        private final Set<FqName> importedFqNames = new LinkedHashSet();

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<KtNamedDeclaration> getUnusedClasses() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.privateClasses;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtNamedDeclaration it = (KtNamedDeclaration)element$iv$iv;
                boolean bl = false;
                if (!(!this.isUsed(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isUsed(KtNamedDeclaration $this$isUsed) {
            boolean bl;
            List pathSegments;
            if (this.namedClasses.contains($this$isUsed.getNameAsSafeName().getIdentifier())) {
                return true;
            }
            FqName fqName = $this$isUsed.getFqName();
            List list = fqName != null ? fqName.pathSegments() : null;
            if (list == null) {
                list = kotlin.collections.CollectionsKt.emptyList();
            }
            if (((Collection)(pathSegments = list)).isEmpty()) return false;
            boolean bl2 = true;
            if (!bl2) return false;
            Iterable $this$any$iv = this.importedFqNames;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                Pair it;
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                FqName importedFqName = (FqName)element$iv;
                boolean bl3 = false;
                List list2 = importedFqName.pathSegments();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"pathSegments(...)");
                Iterable $this$all$iv = kotlin.collections.CollectionsKt.zip((Iterable)list2, (Iterable)pathSegments);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    return true;
                }
                Iterator iterator2 = $this$all$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return true;
                    Object element$iv2 = iterator2.next();
                    it = (Pair)element$iv2;
                    boolean bl4 = false;
                } while (Intrinsics.areEqual((Object)it.getFirst(), (Object)it.getSecond()));
                bl = false;
            } while (!bl);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public void visitClass(@NotNull KtClass klass) {
            List list;
            KtSuperTypeList ktSuperTypeList;
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            if (KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)klass))) {
                this.privateClasses.add((KtNamedDeclaration)klass);
            }
            if ((ktSuperTypeList = klass.getSuperTypeList()) != null && (list = ktSuperTypeList.getEntries()) != null) {
                void $this$forEach$iv;
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv;
                Iterable iterable = list;
                boolean $i$f$mapNotNull = false;
                Iterator iterator = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    KtTypeReference it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    KtSuperTypeListEntry it = (KtSuperTypeListEntry)element$iv$iv;
                    boolean bl2 = false;
                    if (it.getTypeReference() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtTypeReference it = (KtTypeReference)element$iv;
                    boolean bl = false;
                    this.registerAccess(it);
                }
            }
            super.visitClass(klass);
        }

        public void visitImportDirective(@NotNull KtImportDirective importDirective) {
            Intrinsics.checkNotNullParameter((Object)importDirective, (String)"importDirective");
            CollectionsKt.addIfNotNull((Collection)this.importedFqNames, (Object)importDirective.getImportedFqName());
            super.visitImportDirective(importDirective);
        }

        public void visitAnnotationEntry(@NotNull KtAnnotationEntry annotationEntry) {
            Intrinsics.checkNotNullParameter((Object)annotationEntry, (String)"annotationEntry");
            KtTypeReference ktTypeReference = annotationEntry.getTypeReference();
            CollectionsKt.addIfNotNull((Collection)this.namedClasses, (Object)(ktTypeReference != null ? ktTypeReference.getText() : null));
            super.visitAnnotationEntry(annotationEntry);
        }

        /*
         * WARNING - void declaration
         */
        private final void registerAccess(KtTypeReference typeReference) {
            block2: {
                void $this$forEach$iv;
                KtUserType ktUserType;
                KtElement $this$registerAccess_u24lambda_u245 = UnusedPrivateClassKt.access$orInnerType(typeReference);
                boolean bl = false;
                String string = $this$registerAccess_u24lambda_u245.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                this.namedClasses.add(string);
                KtTypeElement ktTypeElement = typeReference.getTypeElement();
                Object object = ktTypeElement != null ? UnusedPrivateClassKt.access$orInnerType(ktTypeElement) : null;
                KtUserType ktUserType2 = ktUserType = object instanceof KtUserType ? (KtUserType)object : null;
                if (ktUserType != null && (object = ktUserType.getReferencedName()) != null) {
                    Object $this$registerAccess_u24lambda_u246 = object;
                    boolean bl2 = false;
                    this.namedClasses.add((String)$this$registerAccess_u24lambda_u246);
                }
                KtTypeElement ktTypeElement2 = typeReference.getTypeElement();
                if (ktTypeElement2 == null) break block2;
                KtTypeElement $this$registerAccess_u24lambda_u249 = ktTypeElement2;
                boolean bl3 = false;
                List list = $this$registerAccess_u24lambda_u249.getTypeArgumentsAsTypes();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTypeArgumentsAsTypes(...)");
                Sequence bl2 = SequencesKt.map((Sequence)SequencesKt.filterNotNull((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)list)), UnusedClassVisitor::registerAccess$lambda$9$lambda$7);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtElement it = (KtElement)element$iv;
                    boolean bl4 = false;
                    String string2 = it.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                    this.namedClasses.add(string2);
                    if (!(it instanceof KtTypeReference)) continue;
                    this.registerAccess((KtTypeReference)it);
                }
            }
        }

        public void visitParameter(@NotNull KtParameter parameter) {
            Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
            KtTypeReference ktTypeReference = parameter.getTypeReference();
            if (ktTypeReference != null) {
                KtTypeReference $this$visitParameter_u24lambda_u2410 = ktTypeReference;
                boolean bl = false;
                this.registerAccess($this$visitParameter_u24lambda_u2410);
            }
            super.visitParameter(parameter);
        }

        public void visitNamedFunction(@NotNull KtNamedFunction function) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            KtTypeReference ktTypeReference = function.getTypeReference();
            if (ktTypeReference != null) {
                KtTypeReference $this$visitNamedFunction_u24lambda_u2411 = ktTypeReference;
                boolean bl = false;
                this.registerAccess($this$visitNamedFunction_u24lambda_u2411);
            }
            super.visitNamedFunction(function);
        }

        public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Object object = declaration.getSuperTypeList();
            if (object != null && (object = object.getEntries()) != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtSuperTypeListEntry it = (KtSuperTypeListEntry)element$iv;
                    boolean bl = false;
                    if (it.getTypeReference() != null) {
                        KtTypeReference $this$visitObjectDeclaration_u24lambda_u2413_u24lambda_u2412;
                        boolean bl2 = false;
                        this.registerAccess($this$visitObjectDeclaration_u24lambda_u2413_u24lambda_u2412);
                    }
                }
            }
            super.visitObjectDeclaration(declaration);
        }

        public void visitFunctionType(@NotNull KtFunctionType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            KtTypeReference ktTypeReference = type.getReturnTypeReference();
            if (ktTypeReference != null) {
                KtTypeReference $this$visitFunctionType_u24lambda_u2414 = ktTypeReference;
                boolean bl = false;
                this.registerAccess($this$visitFunctionType_u24lambda_u2414);
            }
            super.visitFunctionType(type);
        }

        public void visitProperty(@NotNull KtProperty property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            KtTypeReference ktTypeReference = property.getTypeReference();
            if (ktTypeReference != null) {
                KtTypeReference $this$visitProperty_u24lambda_u2415 = ktTypeReference;
                boolean bl = false;
                this.registerAccess($this$visitProperty_u24lambda_u2415);
            }
            super.visitProperty(property);
        }

        public void visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            KtTypeReference ktTypeReference = expression.getRight();
            if (ktTypeReference != null) {
                KtTypeReference $this$visitBinaryWithTypeRHSExpression_u24lambda_u2416 = ktTypeReference;
                boolean bl = false;
                this.registerAccess($this$visitBinaryWithTypeRHSExpression_u24lambda_u2416);
            }
            super.visitBinaryWithTypeRHSExpression(expression);
        }

        public void visitIsExpression(@NotNull KtIsExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            KtTypeReference ktTypeReference = expression.getTypeReference();
            if (ktTypeReference != null) {
                KtTypeReference $this$visitIsExpression_u24lambda_u2417 = ktTypeReference;
                boolean bl = false;
                this.registerAccess($this$visitIsExpression_u24lambda_u2417);
            }
            super.visitIsExpression(expression);
        }

        /*
         * WARNING - void declaration
         */
        public void visitCallExpression(@NotNull KtCallExpression expression) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Object object = expression.getCalleeExpression();
            if (object != null && (object = object.getText()) != null) {
                Object $this$visitCallExpression_u24lambda_u2418 = object;
                boolean bl = false;
                this.namedClasses.add((String)$this$visitCallExpression_u24lambda_u2418);
            }
            List list = expression.getTypeArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTypeArguments(...)");
            Iterable $this$mapNotNull$iv = list;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                KtTypeReference it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                KtTypeProjection it = (KtTypeProjection)element$iv$iv;
                boolean bl2 = false;
                if (it.getTypeReference() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                KtTypeReference it = (KtTypeReference)element$iv;
                boolean bl = false;
                this.registerAccess(it);
            }
            super.visitCallExpression(expression);
        }

        public void visitDoubleColonExpression(@NotNull KtDoubleColonExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            this.checkReceiverForClassUsage(expression.getReceiverExpression());
            if (expression.isEmptyLHS()) {
                KtSimpleNameExpression ktSimpleNameExpression;
                KtCallableReferenceExpression ktCallableReferenceExpression;
                KtDoubleColonExpression $this$safeAs$iv = expression;
                boolean $i$f$safeAs = false;
                KtDoubleColonExpression ktDoubleColonExpression = $this$safeAs$iv;
                if (!(ktDoubleColonExpression instanceof KtCallableReferenceExpression)) {
                    ktDoubleColonExpression = null;
                }
                if ((ktCallableReferenceExpression = (KtCallableReferenceExpression)ktDoubleColonExpression) != null && (ktSimpleNameExpression = ktCallableReferenceExpression.getCallableReference()) != null) {
                    KtSimpleNameExpression ktSimpleNameExpression2;
                    KtSimpleNameExpression ktSimpleNameExpression3;
                    KtSimpleNameExpression it = ktSimpleNameExpression3 = ktSimpleNameExpression;
                    boolean bl = false;
                    Object object = ktSimpleNameExpression2 = this.looksLikeAClassName(it.getReferencedName()) ? ktSimpleNameExpression3 : null;
                    if (ktSimpleNameExpression2 != null) {
                        it = ktSimpleNameExpression2;
                        boolean bl2 = false;
                        this.namedClasses.add(it.getReferencedName());
                    }
                }
            }
            super.visitDoubleColonExpression(expression);
        }

        private final void checkReceiverForClassUsage(KtExpression receiver) {
            block1: {
                String string;
                String string2;
                String string3;
                KtNameReferenceExpression ktNameReferenceExpression;
                KtNameReferenceExpression ktNameReferenceExpression2 = ktNameReferenceExpression = receiver instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)receiver : null;
                if (ktNameReferenceExpression == null || (string3 = ktNameReferenceExpression.getText()) == null) break block1;
                String it = string2 = string3;
                boolean bl = false;
                String string4 = string = this.looksLikeAClassName(it) ? string2 : null;
                if (string != null) {
                    it = string;
                    boolean bl2 = false;
                    this.namedClasses.add(it);
                }
            }
        }

        public void visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            this.checkReceiverForClassUsage(expression.getReceiverExpression());
            super.visitDotQualifiedExpression(expression);
        }

        private final boolean looksLikeAClassName(String maybeClassName) {
            Character c = StringsKt.firstOrNull((CharSequence)maybeClassName);
            return c != null ? Character.isUpperCase(c.charValue()) : false;
        }

        private static final KtElement registerAccess$lambda$9$lambda$7(KtTypeReference it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return UnusedPrivateClassKt.access$orInnerType(it);
        }
    }
}

