/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style.optional;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\u00020\u000f*\u00020\rH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/optional/PreferToOverPairSyntax;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isPairConstructor", "", "Companion", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nPreferToOverPairSyntax.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreferToOverPairSyntax.kt\nio/gitlab/arturbosch/detekt/rules/style/optional/PreferToOverPairSyntax\n+ 2 Junk.kt\nio/gitlab/arturbosch/detekt/rules/JunkKt\n*L\n1#1,67:1\n40#2:68\n*S KotlinDebug\n*F\n+ 1 PreferToOverPairSyntax.kt\nio/gitlab/arturbosch/detekt/rules/style/optional/PreferToOverPairSyntax\n*L\n59#1:68\n*E\n"})
public final class PreferToOverPairSyntax
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final FqName PAIR_FQ_NAME = new FqName("kotlin.Pair");

    public PreferToOverPairSyntax(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("PreferToOverPairSyntax", Severity.Style, "Pair was created using the Pair constructor, using the to syntax is preferred.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ PreferToOverPairSyntax(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitCallExpression(expression);
        if (this.isPairConstructor(expression)) {
            List list = expression.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueArguments(...)");
            String arg = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" to ", null, null, (int)0, null, PreferToOverPairSyntax::visitCallExpression$lambda$0, (int)30, null);
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "Pair is created by using the pair constructor. This can replaced by `" + arg + "`.", null, null, 24, null));
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final boolean isPairConstructor(KtCallExpression $this$isPairConstructor) {
        v0 = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$isPairConstructor), (BindingContext)this.getBindingContext());
        descriptor /* !! */  = v0 != null ? v0.getResultingDescriptor() : null;
        v1 = descriptor /* !! */ ;
        if (v1 == null) ** GOTO lbl-1000
        $this$safeAs$iv = v1;
        $i$f$safeAs = false;
        v2 = $this$safeAs$iv;
        if (!(v2 instanceof ClassConstructorDescriptor)) {
            v2 = null;
        }
        if ((v1 = (ClassConstructorDescriptor)v2) != null && (v1 = v1.getContainingDeclaration()) != null) {
            v3 = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)v1));
        } else lbl-1000:
        // 2 sources

        {
            v3 = null;
        }
        fqName = v3;
        return Intrinsics.areEqual(fqName, (Object)PreferToOverPairSyntax.PAIR_FQ_NAME);
    }

    private static final CharSequence visitCallExpression$lambda$0(KtValueArgument it) {
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    public PreferToOverPairSyntax() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/optional/PreferToOverPairSyntax$Companion;", "", "<init>", "()V", "PAIR_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

