/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/MissingWhenCase;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitWhenExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "detekt-rules"})
public final class MissingWhenCase
extends Rule {
    @NotNull
    private final Issue issue;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitWhenExpression(@NotNull KtWhenExpression expression) {
        ClassDescriptor sealedClassDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        if (expression.getElseExpression() != null) {
            return;
        }
        if (BindingContextUtilsKt.isUsedAsExpression((KtExpression)((KtExpression)expression), (BindingContext)this.getBindingContext())) {
            return;
        }
        KtExpression ktExpression = expression.getSubjectExpression();
        if (ktExpression == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.subjectExpression ?: return");
        KtExpression subjectExpression = ktExpression;
        KotlinType subjectType = CallUtilKt.getType((KtExpression)subjectExpression, (BindingContext)this.getBindingContext());
        ClassDescriptor enumClassDescriptor = WhenChecker.getClassDescriptorOfTypeIfEnum((KotlinType)subjectType);
        if (enumClassDescriptor != null) {
            List enumMissingCases = WhenChecker.getEnumMissingCases((KtWhenExpression)expression, (BindingContext)this.getBindingContext(), (ClassDescriptor)enumClassDescriptor);
            Collection collection = enumMissingCases;
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "When expression is missing cases: " + CollectionsKt.joinToString$default((Iterable)enumMissingCases, null, null, null, (int)0, null, null, (int)63, null) + ". Either add missing " + "cases or a default `else` case.", null, null, 24, null));
            }
        }
        if ((sealedClassDescriptor = WhenChecker.getClassDescriptorOfTypeIfSealed((KotlinType)subjectType)) != null) {
            List sealedClassMissingCases = WhenChecker.getSealedMissingCases((KtWhenExpression)expression, (BindingContext)this.getBindingContext(), (ClassDescriptor)sealedClassDescriptor);
            Collection collection = sealedClassMissingCases;
            boolean bl = false;
            if (!collection.isEmpty()) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "When expression is missing cases: " + CollectionsKt.joinToString$default((Iterable)sealedClassMissingCases, null, null, null, (int)0, null, null, (int)63, null) + ". Either add " + "missing cases or a default `else` case.", null, null, 24, null));
            }
        }
        super.visitWhenExpression(expression);
    }

    public MissingWhenCase(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("MissingWhenCase", Severity.Defect, "Check usage of `when` used as a statement and don't compare all enum or sealed class cases.", Debt.Companion.getTWENTY_MINS());
    }

    public /* synthetic */ MissingWhenCase(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public MissingWhenCase() {
        this(null, 1, null);
    }
}

