/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdRule;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.rules.JunkKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/ComplexInterface;", "Lio/gitlab/arturbosch/detekt/api/ThresholdRule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "threshold", "", "(Lio/gitlab/arturbosch/detekt/api/Config;I)V", "includeStaticDeclarations", "", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "calculateMembers", "body", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "countStaticDeclarations", "companionObject", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "Companion", "detekt-rules"})
public final class ComplexInterface
extends ThresholdRule {
    @NotNull
    private final Issue issue;
    private final boolean includeStaticDeclarations;
    @NotNull
    public static final String INCLUDE_STATIC_DECLARATIONS = "includeStaticDeclarations";
    public static final int DEFAULT_LARGE_INTERFACE_COUNT = 10;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkParameterIsNotNull((Object)klass, (String)"klass");
        if (klass.isInterface()) {
            KtClassBody ktClassBody = klass.getBody();
            if (ktClassBody == null) {
                return;
            }
            KtClassBody body = ktClassBody;
            int size = this.calculateMembers(body);
            if (this.includeStaticDeclarations) {
                size += this.countStaticDeclarations(JunkKt.companionObject(klass));
            }
            if (size >= this.getThreshold()) {
                this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)klass), (int)0, (int)2, null), new Metric("SIZE: ", size, this.getThreshold(), false, 0, 24, null), "The interface " + klass.getName() + " is too complex. Consider splitting it up.", null, 16, null));
            }
        }
        super.visitClass(klass);
    }

    private final int countStaticDeclarations(KtObjectDeclaration companionObject) {
        KtObjectDeclaration ktObjectDeclaration = companionObject;
        KtClassBody body = ktObjectDeclaration != null ? ktObjectDeclaration.getBody() : null;
        return body != null ? this.calculateMembers(body) : 0;
    }

    private final int calculateMembers(KtClassBody body) {
        PsiElement[] psiElementArray = body.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElementArray, (String)"body.children");
        PsiElement[] $this$count$iv = psiElementArray;
        boolean $i$f$count = false;
        int count$iv = 0;
        PsiElement[] psiElementArray2 = $this$count$iv;
        int n = psiElementArray2.length;
        for (int i = 0; i < n; ++i) {
            PsiElement element$iv;
            PsiElement it = element$iv = psiElementArray2[i];
            boolean bl = false;
            if (!(it instanceof KtNamedFunction || it instanceof KtProperty)) continue;
            ++count$iv;
        }
        return count$iv;
    }

    public ComplexInterface(@NotNull Config config, int threshold) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, threshold);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Maintainability, "An interface contains too many functions and properties. Large classes tend to handle many things at once. An interface should have one responsibility. Split up large interfaces into smaller ones that are easier to understand.", Debt.Companion.getTWENTY_MINS());
        this.includeStaticDeclarations = (Boolean)this.valueOrDefault(INCLUDE_STATIC_DECLARATIONS, false);
    }

    public /* synthetic */ ComplexInterface(Config config, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        if ((n2 & 2) != 0) {
            n = 10;
        }
        this(config, n);
    }

    public ComplexInterface() {
        this(null, 0, 3, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/ComplexInterface$Companion;", "", "()V", "DEFAULT_LARGE_INTERFACE_COUNT", "", "INCLUDE_STATIC_DECLARATIONS", "", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

