/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.SplitPattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/LabeledExpression;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "ignoredLabels", "Lio/gitlab/arturbosch/detekt/api/SplitPattern;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "getClassHierarchy", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "classes", "", "Lorg/jetbrains/kotlin/psi/KtClass;", "isAllowedToReferenceContainingClass", "", "klass", "expression", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "isNotReferencingOuterClass", "visitExpressionWithLabel", "Companion", "detekt-rules"})
public final class LabeledExpression
extends Rule {
    @NotNull
    private final Issue issue;
    private final SplitPattern ignoredLabels;
    @NotNull
    public static final String IGNORED_LABELS = "ignoredLabels";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitExpressionWithLabel(@NotNull KtExpressionWithLabel expression) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
            super.visitExpressionWithLabel(expression);
            if (expression instanceof KtThisExpression && !this.isNotReferencingOuterClass(expression)) break block2;
            String string = expression.getLabelName();
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                if (!this.ignoredLabels.contains(it)) {
                    this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
                }
            }
        }
    }

    private final boolean isNotReferencingOuterClass(KtExpressionWithLabel expression) {
        boolean bl;
        block5: {
            boolean bl2 = false;
            List containingClasses = new ArrayList();
            KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)expression));
            if (ktClass == null) {
                return false;
            }
            KtClass containingClass = ktClass;
            if (this.isAllowedToReferenceContainingClass(containingClass, expression)) {
                containingClasses.add(containingClass);
            }
            this.getClassHierarchy((KtElement)containingClass, containingClasses);
            Iterable $this$any$iv = containingClasses;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtClass it = (KtClass)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)expression.getLabelName())) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return !bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAllowedToReferenceContainingClass(KtClass klass, KtExpressionWithLabel expression) {
        if (!klass.isInner()) return true;
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)expression;
        boolean $i$f$getStrictParentOfType = false;
        KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtNamedFunction.class, (boolean)true);
        if (ktNamedFunction == null) return false;
        if (!KtPsiUtilKt.isExtensionDeclaration((PsiElement)((PsiElement)ktNamedFunction))) return false;
        return true;
    }

    private final void getClassHierarchy(KtElement element, List<KtClass> classes) {
        KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)element);
        if (ktClass == null) {
            return;
        }
        KtClass containingClass = ktClass;
        classes.add(containingClass);
        this.getClassHierarchy((KtElement)containingClass, classes);
    }

    public LabeledExpression(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("LabeledExpression", Severity.Maintainability, "Expression with labels increase complexity and affect maintainability.", Debt.Companion.getTWENTY_MINS());
        this.ignoredLabels = new SplitPattern((String)this.valueOrDefault(IGNORED_LABELS, ""), null, false, 6, null);
    }

    public /* synthetic */ LabeledExpression(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public LabeledExpression() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/LabeledExpression$Companion;", "", "()V", "IGNORED_LABELS", "", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

