/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdRule;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\f\u0010\u0011\u001a\u00020\u0005*\u00020\u0012H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/LongParameterList;", "Lio/gitlab/arturbosch/detekt/api/ThresholdRule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "threshold", "", "(Lio/gitlab/arturbosch/detekt/api/Config;I)V", "ignoreDefaultParameters", "", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "parameterCount", "Lorg/jetbrains/kotlin/psi/KtParameterList;", "Companion", "detekt-rules"})
public final class LongParameterList
extends ThresholdRule {
    @NotNull
    private final Issue issue;
    private final boolean ignoreDefaultParameters;
    @NotNull
    public static final String IGNORE_DEFAULT_PARAMETERS = "ignoreDefaultParameters";
    public static final int DEFAULT_THRESHOLD_PARAMETER_LENGTH = 6;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Integer parameters;
        KtParameterList parameterList;
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        if (KtModifierListKt.isOverride((KtModifierListOwner)function)) {
            return;
        }
        KtParameterList ktParameterList = parameterList = function.getValueParameterList();
        Integer n = parameters = ktParameterList != null ? Integer.valueOf(this.parameterCount(ktParameterList)) : null;
        if (parameters != null && parameters >= this.getThreshold()) {
            this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)parameterList), (int)0, (int)2, null), new Metric("SIZE", parameters.intValue(), this.getThreshold(), false, 0, 24, null), "The function " + function.getNameAsSafeName() + " has too many parameters. The current threshold" + " is set to " + this.getThreshold() + '.', null, 16, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int parameterCount(@NotNull KtParameterList $this$parameterCount) {
        int n;
        if (this.ignoreDefaultParameters) {
            void $this$filterTo$iv$iv;
            List list = $this$parameterCount.getParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"parameters");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtParameter it = (KtParameter)element$iv$iv;
                boolean bl = false;
                if (!(!it.hasDefaultValue())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            n = ((List)destination$iv$iv).size();
        } else {
            n = $this$parameterCount.getParameters().size();
        }
        return n;
    }

    public LongParameterList(@NotNull Config config, int threshold) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, threshold);
        this.issue = new Issue("LongParameterList", Severity.Maintainability, "The more parameters a method has the more complex it is. Long parameter lists are often used to control complex algorithms and violate the Single Responsibility Principle. Prefer methods with short parameter lists.", Debt.Companion.getTWENTY_MINS());
        this.ignoreDefaultParameters = (Boolean)this.valueOrDefault(IGNORE_DEFAULT_PARAMETERS, false);
    }

    public /* synthetic */ LongParameterList(Config config, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        if ((n2 & 2) != 0) {
            n = 6;
        }
        this(config, n);
    }

    public LongParameterList() {
        this(null, 0, 3, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/LongParameterList$Companion;", "", "()V", "DEFAULT_THRESHOLD_PARAMETER_LENGTH", "", "IGNORE_DEFAULT_PARAMETERS", "", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

