/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.documentation;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\f\u0010\u0019\u001a\u00020\n*\u00020\u0018H\u0002J\f\u0010\u001a\u001a\u00020\n*\u00020\u0014H\u0002J\f\u0010\u001b\u001a\u00020\n*\u00020\u0014H\u0002J\f\u0010\u001c\u001a\u00020\n*\u00020\u0014H\u0002J\f\u0010\u001d\u001a\u00020\n*\u00020\u0011H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/UndocumentedPublicClass;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "searchInInnerClass", "", "searchInInnerInterface", "searchInInnerObject", "searchInNestedClass", "reportIfUndocumented", "", "element", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "requiresDocumentation", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitClass", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "isCompanionWithoutName", "isInnerClass", "isInnerInterface", "isNestedClass", "notEnumEntry", "Companion", "detekt-rules"})
public final class UndocumentedPublicClass
extends Rule {
    @NotNull
    private final Issue issue;
    private final boolean searchInNestedClass;
    private final boolean searchInInnerClass;
    private final boolean searchInInnerObject;
    private final boolean searchInInnerInterface;
    @NotNull
    public static final String SEARCH_IN_NESTED_CLASS = "searchInNestedClass";
    @NotNull
    public static final String SEARCH_IN_INNER_CLASS = "searchInInnerClass";
    @NotNull
    public static final String SEARCH_IN_INNER_OBJECT = "searchInInnerObject";
    @NotNull
    public static final String SEARCH_IN_INNER_INTERFACE = "searchInInnerInterface";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkParameterIsNotNull((Object)klass, (String)"klass");
        if (this.requiresDocumentation(klass)) {
            this.reportIfUndocumented((KtClassOrObject)klass);
        }
        super.visitClass(klass);
    }

    private final boolean requiresDocumentation(KtClass klass) {
        return klass.isTopLevel() || this.isInnerClass(klass) || this.isNestedClass(klass) || this.isInnerInterface(klass);
    }

    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        if (this.isCompanionWithoutName(declaration) || declaration.isLocal() || !this.searchInInnerObject) {
            return;
        }
        this.reportIfUndocumented((KtClassOrObject)declaration);
        super.visitObjectDeclaration(declaration);
    }

    private final void reportIfUndocumented(KtClassOrObject element) {
        if (KtModifierListKt.isPublicNotOverridden((KtModifierListOwner)element) && this.notEnumEntry(element) && element.getDocComment() == null) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)element), (int)0, (int)2, null), element.getNameAsSafeName() + " is missing required documentation.", null, null, 24, null));
        }
    }

    private final boolean isCompanionWithoutName(@NotNull KtObjectDeclaration $this$isCompanionWithoutName) {
        return $this$isCompanionWithoutName.isCompanion() && Intrinsics.areEqual((Object)$this$isCompanionWithoutName.getNameAsSafeName().asString(), (Object)"Companion");
    }

    private final boolean isNestedClass(@NotNull KtClass $this$isNestedClass) {
        return !$this$isNestedClass.isInterface() && !$this$isNestedClass.isTopLevel() && !$this$isNestedClass.isInner() && this.searchInNestedClass;
    }

    private final boolean isInnerClass(@NotNull KtClass $this$isInnerClass) {
        return !$this$isInnerClass.isInterface() && $this$isInnerClass.isInner() && this.searchInInnerClass;
    }

    private final boolean isInnerInterface(@NotNull KtClass $this$isInnerInterface) {
        return !$this$isInnerInterface.isTopLevel() && $this$isInnerInterface.isInterface() && this.searchInInnerInterface;
    }

    private final boolean notEnumEntry(@NotNull KtClassOrObject $this$notEnumEntry) {
        return !($this$notEnumEntry instanceof KtEnumEntry);
    }

    public UndocumentedPublicClass(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Maintainability, "Public classes, interfaces and objects require documentation.", Debt.Companion.getTWENTY_MINS());
        this.searchInNestedClass = (Boolean)this.valueOrDefault(SEARCH_IN_NESTED_CLASS, true);
        this.searchInInnerClass = (Boolean)this.valueOrDefault(SEARCH_IN_INNER_CLASS, true);
        this.searchInInnerObject = (Boolean)this.valueOrDefault(SEARCH_IN_INNER_OBJECT, true);
        this.searchInInnerInterface = (Boolean)this.valueOrDefault(SEARCH_IN_INNER_INTERFACE, true);
    }

    public /* synthetic */ UndocumentedPublicClass(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public UndocumentedPublicClass() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/UndocumentedPublicClass$Companion;", "", "()V", "SEARCH_IN_INNER_CLASS", "", "SEARCH_IN_INNER_INTERFACE", "SEARCH_IN_INNER_OBJECT", "SEARCH_IN_NESTED_CLASS", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

