/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.empty;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.rules.empty.EmptyRule;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/rules/empty/EmptyDefaultConstructor;", "Lio/gitlab/arturbosch/detekt/rules/empty/EmptyRule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "hasPublicVisibility", "", "visibility", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "hasSuitableSignature", "constructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "isExpectedAnnotationClass", "isNotCalled", "visitPrimaryConstructor", "", "detekt-rules"})
public final class EmptyDefaultConstructor
extends EmptyRule {
    public void visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor) {
        Intrinsics.checkParameterIsNotNull((Object)constructor, (String)"constructor");
        if (this.hasSuitableSignature(constructor) && this.isNotCalled(constructor) && !this.isExpectedAnnotationClass(constructor)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)constructor), (int)0, (int)2, null), "An empty default constructor can be removed.", null, null, 24, null));
        }
    }

    private final boolean isExpectedAnnotationClass(KtPrimaryConstructor constructor) {
        PsiElement parent = constructor.getParent();
        if (parent instanceof KtClass && ((KtClass)parent).isAnnotation()) {
            return PsiUtilsKt.hasExpectModifier((KtModifierListOwner)((KtModifierListOwner)parent)) || PsiUtilsKt.hasActualModifier((KtModifierListOwner)((KtModifierListOwner)parent));
        }
        return false;
    }

    private final boolean hasSuitableSignature(KtPrimaryConstructor constructor) {
        return this.hasPublicVisibility(KtPsiUtilKt.visibilityModifierType((KtModifierListOwner)((KtModifierListOwner)constructor))) && constructor.getAnnotationEntries().isEmpty() && constructor.getValueParameters().isEmpty();
    }

    private final boolean hasPublicVisibility(KtModifierKeywordToken visibility) {
        return visibility == null || Intrinsics.areEqual((Object)visibility, (Object)KtTokens.PUBLIC_KEYWORD);
    }

    private final boolean isNotCalled(KtPrimaryConstructor constructor) {
        boolean bl;
        block3: {
            Iterable $this$none$iv = constructor.getContainingClassOrObject().getSecondaryConstructors();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    KtSecondaryConstructor it = (KtSecondaryConstructor)element$iv;
                    boolean bl2 = false;
                    if (!(it.getDelegationCall().isCallToThis() && it.getDelegationCall().getValueArguments().isEmpty())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public EmptyDefaultConstructor(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config);
    }
}

