/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.SplitPattern;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClassOrObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/ForbiddenClassName;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "forbiddenNames", "Lio/gitlab/arturbosch/detekt/api/SplitPattern;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitClassOrObject", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "Companion", "detekt-rules"})
public final class ForbiddenClassName
extends Rule {
    @NotNull
    private final Issue issue;
    private final SplitPattern forbiddenNames;
    @NotNull
    public static final String FORBIDDEN_NAME = "forbiddenName";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkParameterIsNotNull((Object)classOrObject, (String)"classOrObject");
        String string = classOrObject.getName();
        if (string == null) {
            string = "";
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"classOrObject.name ?: \"\"");
        String name = string;
        List forbiddenEntries = this.forbiddenNames.matches(name);
        Collection collection = forbiddenEntries;
        boolean bl = false;
        if (!collection.isEmpty()) {
            CharSequence charSequence;
            String message;
            block5: {
                message = "Class name " + name + " is forbidden as it contains:";
                Iterable $this$forEach$iv = forbiddenEntries;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    message = message + ' ' + it + ',';
                }
                String $this$trimEnd$iv = message;
                boolean $i$f$trimEnd = false;
                CharSequence $this$trimEnd$iv$iv = $this$trimEnd$iv;
                boolean $i$f$trimEnd2 = false;
                int it = $this$trimEnd$iv$iv.length();
                --it;
                boolean bl3 = false;
                while (it >= 0) {
                    void index$iv$iv;
                    char it2 = $this$trimEnd$iv$iv.charAt((int)index$iv$iv);
                    boolean bl4 = false;
                    if (!(it2 == ',')) {
                        charSequence = $this$trimEnd$iv$iv.subSequence(0, (int)(index$iv$iv + true));
                        break block5;
                    }
                    --index$iv$iv;
                }
                charSequence = "";
            }
            ((Object)charSequence).toString();
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)classOrObject), (int)0, (int)2, null), message, null, null, 24, null));
        }
    }

    public ForbiddenClassName(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Forbidden class name as per configuration detected.", Debt.Companion.getFIVE_MINS());
        this.forbiddenNames = new SplitPattern((String)this.valueOrDefault(FORBIDDEN_NAME, ""), null, false, 6, null);
    }

    public /* synthetic */ ForbiddenClassName(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public ForbiddenClassName() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/ForbiddenClassName$Companion;", "", "()V", "FORBIDDEN_NAME", "", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

