/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.LazyRegex;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.IdentifierNameKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.naming.util.ExcludeClassKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0011\u0010\rR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001e"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/FunctionNaming;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "defaultRuleIdAliases", "", "", "getDefaultRuleIdAliases", "()Ljava/util/Set;", "excludeClassPattern", "Lkotlin/text/Regex;", "getExcludeClassPattern", "()Lkotlin/text/Regex;", "excludeClassPattern$delegate", "Lio/gitlab/arturbosch/detekt/api/LazyRegex;", "functionPattern", "getFunctionPattern", "functionPattern$delegate", "ignoreOverridden", "", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Companion", "detekt-rules"})
public final class FunctionNaming
extends Rule {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Set<String> defaultRuleIdAliases;
    @NotNull
    private final Issue issue;
    private final LazyRegex functionPattern$delegate;
    private final LazyRegex excludeClassPattern$delegate;
    private final boolean ignoreOverridden;
    @NotNull
    public static final String FUNCTION_PATTERN = "functionPattern";
    @NotNull
    public static final String EXCLUDE_CLASS_PATTERN = "excludeClassPattern";
    @NotNull
    public static final String IGNORE_OVERRIDDEN = "ignoreOverridden";
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(FunctionNaming.class), FUNCTION_PATTERN, "getFunctionPattern()Lkotlin/text/Regex;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(FunctionNaming.class), EXCLUDE_CLASS_PATTERN, "getExcludeClassPattern()Lkotlin/text/Regex;"))};
        Companion = new Companion(null);
    }

    @NotNull
    public Set<String> getDefaultRuleIdAliases() {
        return this.defaultRuleIdAliases;
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Regex getFunctionPattern() {
        return this.functionPattern$delegate.getValue((Rule)this, $$delegatedProperties[0]);
    }

    private final Regex getExcludeClassPattern() {
        return this.excludeClassPattern$delegate.getValue((Rule)this, $$delegatedProperties[1]);
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        super.visitNamedFunction(function);
        if (this.ignoreOverridden && KtModifierListKt.isOverride((KtModifierListOwner)function)) {
            return;
        }
        if (!ExcludeClassKt.isContainingExcludedClassOrObject((KtDeclaration)function, this.getExcludeClassPattern())) {
            CharSequence charSequence = IdentifierNameKt.identifierName((KtNamedDeclaration)function);
            Regex regex = this.getFunctionPattern();
            boolean bl = false;
            if (!regex.matches(charSequence)) {
                KtTypeReference ktTypeReference = function.getTypeReference();
                if (Intrinsics.areEqual((Object)IdentifierNameKt.identifierName((KtNamedDeclaration)function), (Object)(ktTypeReference != null ? ktTypeReference.getName() : null)) ^ true) {
                    this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)function), (int)0, (int)2, null), "Function names should match the pattern: " + this.getFunctionPattern(), null, null, 24, null));
                }
            }
        }
    }

    public FunctionNaming(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        this.defaultRuleIdAliases = SetsKt.setOf((Object)"FunctionName");
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Function names should follow the naming convention set in the configuration.", Debt.Companion.getFIVE_MINS());
        this.functionPattern$delegate = new LazyRegex(FUNCTION_PATTERN, "^([a-z$][a-zA-Z$0-9]*)|(`.*`)$");
        this.excludeClassPattern$delegate = new LazyRegex(EXCLUDE_CLASS_PATTERN, "$^");
        this.ignoreOverridden = (Boolean)this.valueOrDefault(IGNORE_OVERRIDDEN, true);
    }

    public /* synthetic */ FunctionNaming(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public FunctionNaming() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/FunctionNaming$Companion;", "", "()V", "EXCLUDE_CLASS_PATTERN", "", "FUNCTION_PATTERN", "IGNORE_OVERRIDDEN", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

