/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/MatchingDeclarationName;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "detekt-rules"})
public final class MatchingDeclarationName
extends Rule {
    @NotNull
    private final Issue issue;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public void visitKtFile(@NotNull KtFile file) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Iterable $this$filterIsInstance$iv = file.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtClassOrObject)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            KtClassOrObject it = (KtClassOrObject)element$iv$iv;
            boolean bl = false;
            if (KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List declarations = (List)destination$iv$iv;
        if (declarations.size() == 1) {
            KtClassOrObject declaration = (KtClassOrObject)CollectionsKt.firstOrNull((List)declarations);
            Object object = declaration;
            if (object == null || (object = object.getName()) == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"declaration?.name ?: return");
            Object declarationName = object;
            String string = file.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
            String filename = StringsKt.removeSuffix((String)string, (CharSequence)".kt");
            if (Intrinsics.areEqual((Object)declarationName, (Object)filename) ^ true) {
                boolean bl;
                block10: {
                    void $this$filterIsInstanceTo$iv$iv2;
                    Iterable $this$filterIsInstance$iv2 = file.getDeclarations();
                    boolean $i$f$filterIsInstance2 = false;
                    Iterator iterator = $this$filterIsInstance$iv2;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterIsInstanceTo2 = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                        if (!(element$iv$iv instanceof KtTypeAlias)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    Iterable $this$all$iv = (List)destination$iv$iv2;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            KtTypeAlias it = (KtTypeAlias)element$iv;
                            boolean bl2 = false;
                            if (Intrinsics.areEqual((Object)it.getName(), (Object)filename) ^ true) continue;
                            bl = false;
                            break block10;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    Entity entity = Entity.copy$default((Entity)Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)declaration), (int)0, (int)2, null), null, null, null, null, (KtElement)((KtElement)file), (int)15, null);
                    this.report((Finding)new CodeSmell(this.getIssue(), entity, "The file name '" + file.getName() + "' " + "does not match the name of the single top-level declaration '" + (String)declarationName + "'.", null, null, 24, null));
                }
            }
        }
    }

    public MatchingDeclarationName(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "If a source file contains only a single non-private top-level class or object, the file name should reflect the case-sensitive name plus the .kt extension.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ MatchingDeclarationName(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public MatchingDeclarationName() {
        this(null, 1, null);
    }
}

