/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.SplitPatternKt;
import io.gitlab.arturbosch.detekt.rules.style.ForbiddenImport;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtImportDirective;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenImport;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "forbiddenImports", "", "Lkotlin/text/Regex;", "forbiddenPatterns", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "containsForbiddenPattern", "", "import", "", "visitImportDirective", "", "importDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "Companion", "detekt-rules"})
public final class ForbiddenImport
extends Rule {
    @NotNull
    private final Issue issue;
    private final List<Regex> forbiddenImports;
    private final Regex forbiddenPatterns;
    @NotNull
    public static final String IMPORTS = "imports";
    @NotNull
    public static final String FORBIDDEN_PATTERNS = "forbiddenPatterns";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitImportDirective(@NotNull KtImportDirective importDirective) {
        boolean bl;
        Object object;
        block5: {
            Intrinsics.checkParameterIsNotNull((Object)importDirective, (String)"importDirective");
            super.visitImportDirective(importDirective);
            Object object2 = importDirective.getImportedFqName();
            if (object2 == null || (object2 = object2.asString()) == null) {
                object2 = "";
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"importDirective.importedFqName?.asString() ?: \"\"");
            object = object2;
            Iterable $this$any$iv = this.forbiddenImports;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Regex it = (Regex)element$iv;
                    boolean bl2 = false;
                    if (!it.matches((CharSequence)object)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl || this.containsForbiddenPattern((String)object)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)importDirective), (int)0, (int)2, null), "The import " + (String)object + " has been forbidden in the Detekt config.", null, null, 24, null));
        }
    }

    private final boolean containsForbiddenPattern(String string) {
        CharSequence charSequence = this.forbiddenPatterns.getPattern();
        boolean bl = false;
        return charSequence.length() > 0 && this.forbiddenPatterns.containsMatchIn((CharSequence)string);
    }

    public ForbiddenImport(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Mark forbidden imports. A forbidden import could be an import for an unstable / experimental apiand hence you might want to mark it as forbidden in order to get warned about the usage.", Debt.Companion.getTEN_MINS());
        this.forbiddenImports = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.distinct((Sequence)SplitPatternKt.commaSeparatedPattern$default((String)((String)this.valueOrDefault(IMPORTS, "")), null, (int)1, null)), (Function1)forbiddenImports.1.INSTANCE));
        this.forbiddenPatterns = new Regex((String)this.valueOrDefault(FORBIDDEN_PATTERNS, ""));
    }

    public /* synthetic */ ForbiddenImport(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public ForbiddenImport() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenImport$Companion;", "", "()V", "FORBIDDEN_PATTERNS", "", "IMPORTS", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

