/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.SplitPatternKt;
import io.gitlab.arturbosch.detekt.rules.style.ForbiddenPublicDataClass;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenPublicDataClass;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "ignorablePackages", "", "Lkotlin/text/Regex;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitCondition", "", "root", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "detekt-rules"})
public final class ForbiddenPublicDataClass
extends Rule {
    @NotNull
    private final Issue issue;
    private final List<Regex> ignorablePackages;
    @NotNull
    public static final String IGNORE_PACKAGES = "ignorePackages";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public boolean visitCondition(@NotNull KtFile root) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        return super.visitCondition(root) && this.getFilters() != null;
    }

    public void visitClass(@NotNull KtClass klass) {
        boolean isPublicOrProtected;
        String packageName;
        Intrinsics.checkParameterIsNotNull((Object)klass, (String)"klass");
        KtPackageDirective ktPackageDirective = klass.getContainingKtFile().getPackageDirective();
        String string = ktPackageDirective != null && (ktPackageDirective = ktPackageDirective.getPackageNameExpression()) != null ? ktPackageDirective.getText() : (packageName = null);
        if (packageName != null) {
            boolean bl;
            block8: {
                Iterable $this$any$iv = this.ignorablePackages;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Regex it = (Regex)element$iv;
                        boolean bl2 = false;
                        if (!it.matches((CharSequence)packageName)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return;
            }
        }
        KtModifierKeywordToken ktModifierKeywordToken = KtPsiUtilKt.visibilityModifierTypeOrDefault((KtModifierListOwner)((KtModifierListOwner)klass));
        boolean bl = false;
        boolean bl3 = false;
        KtModifierKeywordToken visibility = ktModifierKeywordToken;
        boolean bl4 = false;
        boolean bl5 = isPublicOrProtected = Intrinsics.areEqual((Object)visibility, (Object)KtTokens.INTERNAL_KEYWORD) ^ true && Intrinsics.areEqual((Object)visibility, (Object)KtTokens.PRIVATE_KEYWORD) ^ true;
        if (isPublicOrProtected) {
            if (klass.isData()) {
                Issue issue = this.getIssue();
                PsiElement psiElement = klass.getNameIdentifier();
                if (psiElement == null) {
                    psiElement = (PsiElement)klass;
                }
                this.report((Finding)new CodeSmell(issue, Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)psiElement, (int)0, (int)2, null), "", null, null, 24, null));
            }
            super.visitClass(klass);
        }
    }

    public ForbiddenPublicDataClass(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "The data classes are bad for the binary compatibility in public APIs. Avoid to use it.", Debt.Companion.getTWENTY_MINS());
        this.ignorablePackages = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.distinct((Sequence)SplitPatternKt.commaSeparatedPattern$default((String)((String)this.valueOrDefault(IGNORE_PACKAGES, "*.internal,*.internal.*")), null, (int)1, null)), (Function1)ignorablePackages.1.INSTANCE));
    }

    public /* synthetic */ ForbiddenPublicDataClass(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public ForbiddenPublicDataClass() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ForbiddenPublicDataClass$Companion;", "", "()V", "IGNORE_PACKAGES", "", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

