/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0010H\u0002J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\f\u0010\u0019\u001a\u00020\u000e*\u00020\u0016H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnderscoresInNumericLiterals;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "acceptableDecimalLength", "", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "underscoreNumberRegex", "Lkotlin/text/Regex;", "isNotDecimalNumber", "", "rawText", "", "normalizeForMatching", "text", "reportIfInvalidUnderscorePattern", "", "expression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "numberString", "visitConstantExpression", "isSerialUidProperty", "Companion", "detekt-rules"})
public final class UnderscoresInNumericLiterals
extends Rule {
    @NotNull
    private final Issue issue;
    private final Regex underscoreNumberRegex;
    private final int acceptableDecimalLength;
    @NotNull
    public static final String ACCEPTABLE_DECIMAL_LENGTH = "acceptableDecimalLength";
    private static final String HEX_PREFIX = "0x";
    private static final String BIN_PREFIX = "0b";
    private static final String SERIALIZABLE = "Serializable";
    private static final String SERIAL_UID_PROPERTY_NAME = "serialVersionUID";
    private static final int DEFAULT_ACCEPTABLE_DECIMAL_LENGTH = 5;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitConstantExpression(@NotNull KtConstantExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        String string = expression.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"expression.text");
        String normalizedText = this.normalizeForMatching(string);
        if (this.isNotDecimalNumber(normalizedText) || this.isSerialUidProperty(expression)) {
            return;
        }
        String numberString = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)normalizedText, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null));
        if (numberString.length() >= this.acceptableDecimalLength || StringsKt.contains$default((CharSequence)numberString, (char)'_', (boolean)false, (int)2, null)) {
            this.reportIfInvalidUnderscorePattern(expression, numberString);
        }
    }

    private final void reportIfInvalidUnderscorePattern(KtConstantExpression expression, String numberString) {
        CharSequence charSequence = numberString;
        Regex regex = this.underscoreNumberRegex;
        boolean bl = false;
        if (!regex.matches(charSequence)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "This numeric literal should be separated by underscores in order to increase readability.", null, null, 24, null));
        }
    }

    private final boolean isNotDecimalNumber(String rawText) {
        return StringsKt.toDoubleOrNull((String)StringsKt.replace$default((String)rawText, (String)"_", (String)"", (boolean)false, (int)4, null)) == null || StringsKt.startsWith$default((String)rawText, (String)HEX_PREFIX, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)rawText, (String)BIN_PREFIX, (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSerialUidProperty(@NotNull KtConstantExpression $this$isSerialUidProperty) {
        KtSuperTypeListEntry it;
        PsiElement psiElement = $this$isSerialUidProperty.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"parent");
        PsiElement $this$safeAs$iv = psiElement;
        boolean $i$f$safeAs = false;
        PsiElement psiElement2 = $this$safeAs$iv;
        if (!(psiElement2 instanceof KtProperty)) {
            psiElement2 = null;
        }
        KtProperty ktProperty = (KtProperty)psiElement2;
        if (!Intrinsics.areEqual((Object)(ktProperty != null ? ktProperty.getName() : null), (Object)SERIAL_UID_PROPERTY_NAME)) return false;
        PsiElement psiElement3 = $this$isSerialUidProperty.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"parent");
        PsiElement psiElement4 = psiElement3.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"parent.parent");
        PsiElement psiElement5 = psiElement4.getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement5, (String)"parent.parent.parent");
        $this$safeAs$iv = psiElement5;
        $i$f$safeAs = false;
        PsiElement psiElement6 = $this$safeAs$iv;
        if (!(psiElement6 instanceof KtClassOrObject)) {
            psiElement6 = null;
        }
        KtClassOrObject ktClassOrObject = (KtClassOrObject)psiElement6;
        Object object = ktClassOrObject;
        if (ktClassOrObject == null) return false;
        List list = object.getSuperTypeListEntries();
        object = list;
        if (list == null) return false;
        Iterable $this$any$iv = (Iterable)object;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (KtSuperTypeListEntry)element$iv;
            boolean bl = false;
        } while (!Intrinsics.areEqual((Object)it.getText(), (Object)SERIALIZABLE));
        return true;
    }

    private final String normalizeForMatching(String text) {
        String string = text;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        Locale locale = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
        Locale locale2 = locale;
        boolean bl2 = false;
        String string3 = string;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
        return StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)string4, (CharSequence)"l"), (CharSequence)"d"), (CharSequence)"f");
    }

    public UnderscoresInNumericLiterals(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Report missing or invalid underscores in decimal base 10 numeric literals. Numeric literals should be underscore separated to increase readability. Underscores that do not make groups of 3 digits are also reported.", Debt.Companion.getFIVE_MINS());
        this.underscoreNumberRegex = new Regex("^[0-9]{1,3}(_[0-9]{3})*$");
        this.acceptableDecimalLength = ((Number)this.valueOrDefault(ACCEPTABLE_DECIMAL_LENGTH, 5)).intValue();
    }

    public /* synthetic */ UnderscoresInNumericLiterals(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public UnderscoresInNumericLiterals() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnderscoresInNumericLiterals$Companion;", "", "()V", "ACCEPTABLE_DECIMAL_LENGTH", "", "BIN_PREFIX", "DEFAULT_ACCEPTABLE_DECIMAL_LENGTH", "", "HEX_PREFIX", "SERIALIZABLE", "SERIAL_UID_PROPERTY_NAME", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

