/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.style.UnusedMemberVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u001bH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnusedFunctionVisitor;", "Lio/gitlab/arturbosch/detekt/rules/style/UnusedMemberVisitor;", "allowedNames", "Lkotlin/text/Regex;", "(Lkotlin/text/Regex;)V", "callExpressions", "", "", "functions", "", "Lorg/jetbrains/kotlin/psi/KtFunction;", "collectFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "getUnusedReports", "", "Lio/gitlab/arturbosch/detekt/api/CodeSmell;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "isDeclaredInsideAnInterface", "", "visitCallExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitNamedFunction", "visitReferenceExpression", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "detekt-rules"})
final class UnusedFunctionVisitor
extends UnusedMemberVisitor {
    private final Set<String> callExpressions;
    private final Map<String, KtFunction> functions;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<CodeSmell> getUnusedReports(@NotNull Issue issue) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        for (String call : this.callExpressions) {
            if (this.functions.isEmpty()) break;
            this.functions.remove(call);
        }
        Map<String, KtFunction> $this$map$iv = this.functions;
        boolean $i$f$map = false;
        Map<String, KtFunction> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var7_8 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var7_8.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            CodeSmell codeSmell = new CodeSmell(issue, Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it.getValue()), (int)0, (int)2, null), "Private function " + (String)it.getKey() + " is unused.", null, null, 24, null);
            collection.add(codeSmell);
        }
        return (List)destination$iv$iv;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        if (!this.isDeclaredInsideAnInterface(function)) {
            if (!KtModifierListKt.isOperator((KtModifierListOwner)function) && KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)function))) {
                this.collectFunction(function);
            }
        }
        super.visitNamedFunction(function);
    }

    private final boolean isDeclaredInsideAnInterface(KtNamedFunction function) {
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)function;
        boolean $i$f$getStrictParentOfType = false;
        KtClass ktClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClass.class, (boolean)true);
        return ktClass != null && ktClass.isInterface();
    }

    private final void collectFunction(KtNamedFunction function) {
        Name name = function.getNameAsSafeName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"function.nameAsSafeName");
        String string = name.getIdentifier();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"function.nameAsSafeName.identifier");
        String name2 = string;
        if (!this.getAllowedNames().matches((CharSequence)name2)) {
            this.functions.put(name2, (KtFunction)function);
        }
    }

    public void visitReferenceExpression(@NotNull KtReferenceExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        super.visitReferenceExpression(expression);
        KtReferenceExpression ktReferenceExpression = expression;
        if (ktReferenceExpression instanceof KtOperationReferenceExpression) {
            this.callExpressions.add(((KtOperationReferenceExpression)expression).getReferencedName());
        } else if (ktReferenceExpression instanceof KtNameReferenceExpression) {
            this.callExpressions.add(((KtNameReferenceExpression)expression).getReferencedName());
        }
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        String calledMethodName;
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        super.visitCallExpression(expression);
        KtReferenceExpression ktReferenceExpression = KtPsiUtilKt.referenceExpression((KtExpression)((KtExpression)expression));
        String string = calledMethodName = ktReferenceExpression != null ? ktReferenceExpression.getText() : null;
        if (calledMethodName != null) {
            this.callExpressions.add(calledMethodName);
        }
    }

    public UnusedFunctionVisitor(@NotNull Regex allowedNames) {
        Intrinsics.checkParameterIsNotNull((Object)allowedNames, (String)"allowedNames");
        super(allowedNames);
        UnusedFunctionVisitor unusedFunctionVisitor = this;
        boolean bl = false;
        Object object = new LinkedHashSet();
        unusedFunctionVisitor.callExpressions = object;
        unusedFunctionVisitor = this;
        bl = false;
        unusedFunctionVisitor.functions = object = (Map)new LinkedHashMap();
    }
}

