/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.AnnotationExcluder;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.SplitPattern;
import io.gitlab.arturbosch.detekt.rules.KtClassOrObjectExtensionsKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d*\u00020\u0013H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseDataClass;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "allowVars", "", "defaultFunctionNames", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "excludeAnnotatedClasses", "Lio/gitlab/arturbosch/detekt/api/SplitPattern;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "hasOnlyPrivateConstructors", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "isIncorrectClassType", "visit", "", "root", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitKlass", "annotationExcluder", "Lio/gitlab/arturbosch/detekt/api/AnnotationExcluder;", "extractConstructorPropertyParameters", "", "Lorg/jetbrains/kotlin/psi/KtParameter;", "Companion", "detekt-rules"})
public final class UseDataClass
extends Rule {
    @NotNull
    private final Issue issue;
    private final SplitPattern excludeAnnotatedClasses;
    private final HashSet<String> defaultFunctionNames;
    private final boolean allowVars;
    @NotNull
    public static final String ALLOW_VARS = "allowVars";
    @NotNull
    public static final String EXCLUDE_ANNOTATED_CLASSES = "excludeAnnotatedClasses";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public void visit(@NotNull KtFile root) {
        void $this$forEachDescendantOfType$iv;
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        super.visit(root);
        AnnotationExcluder annotationExcluder = new AnnotationExcluder(root, this.excludeAnnotatedClasses);
        PsiElement psiElement = (PsiElement)root;
        Function1 action$iv = (Function1)new Function1<KtClass, Unit>(this, annotationExcluder){
            final /* synthetic */ UseDataClass this$0;
            final /* synthetic */ AnnotationExcluder $annotationExcluder;

            public final void invoke(@NotNull KtClass it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                UseDataClass.access$visitKlass(this.this$0, it, this.$annotationExcluder);
            }
            {
                this.this$0 = useDataClass;
                this.$annotationExcluder = annotationExcluder;
                super(1);
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        void $this$forEachDescendantOfType$iv$iv = $this$forEachDescendantOfType$iv;
        boolean $i$f$forEachDescendantOfType2 = false;
        $this$forEachDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $captured_local_variable$1;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtClass) {
                    this.$action.invoke((Object)element);
                }
            }
        });
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void visitKlass(KtClass klass, AnnotationExcluder annotationExcluder) {
        block25: {
            block24: {
                block23: {
                    block22: {
                        block21: {
                            if (this.isIncorrectClassType(klass) || this.hasOnlyPrivateConstructors(klass)) {
                                return;
                            }
                            if (!KtClassOrObjectExtensionsKt.isClosedForExtension(klass) || !KtClassOrObjectExtensionsKt.doesNotExtendAnything(klass)) break block25;
                            v0 = klass.getAnnotationEntries();
                            Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"klass.annotationEntries");
                            if (annotationExcluder.shouldExclude(v0)) break block25;
                            declarations = KtClassOrObjectExtensionsKt.extractDeclarations(klass);
                            $this$filterIsInstance$iv = declarations;
                            $i$f$filterIsInstance = false;
                            var7_7 = $this$filterIsInstance$iv;
                            destination$iv$iv /* !! */  = new ArrayList<E>();
                            $i$f$filterIsInstanceTo = false;
                            for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                                if (!(element$iv$iv /* !! */  instanceof KtProperty)) continue;
                                destination$iv$iv /* !! */ .add(element$iv$iv /* !! */ );
                            }
                            properties = (List)destination$iv$iv /* !! */ ;
                            $this$filterIsInstance$iv = declarations;
                            $i$f$filterIsInstance = false;
                            destination$iv$iv /* !! */  = $this$filterIsInstance$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$filterIsInstanceTo = false;
                            for (E element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                                if (!(element$iv$iv instanceof KtNamedFunction)) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            functions = (List)destination$iv$iv;
                            propertyParameters = this.extractConstructorPropertyParameters(klass);
                            $this$none$iv = functions;
                            $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                v1 = true;
                            } else {
                                for (T element$iv : $this$none$iv) {
                                    it = (KtNamedFunction)element$iv;
                                    $i$a$-none-UseDataClass$visitKlass$containsFunctions$1 = false;
                                    if (!(CollectionsKt.contains((Iterable)this.defaultFunctionNames, (Object)it.getName()) == false)) continue;
                                    v1 = false;
                                    break block21;
                                }
                                v1 = true;
                            }
                        }
                        containsFunctions = v1;
                        $i$f$none = properties;
                        $i$f$filterIsInstanceTo = false;
                        if ($i$f$none.isEmpty() == false) ** GOTO lbl-1000
                        $i$f$none = propertyParameters;
                        $i$f$filterIsInstanceTo = false;
                        if ($i$f$none.isEmpty() == false) lbl-1000:
                        // 2 sources

                        {
                            v2 = true;
                        } else {
                            v2 = false;
                        }
                        containsPropertyOrPropertyParameters = v2;
                        $this$any$iv = properties;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            v3 = false;
                        } else {
                            for (E element$iv : $this$any$iv) {
                                it = (KtProperty)element$iv;
                                $i$a$-any-UseDataClass$visitKlass$containsVars$1 = false;
                                if (!it.isVar()) continue;
                                v3 = true;
                                break block22;
                            }
                            v3 = false;
                        }
                    }
                    if (v3) ** GOTO lbl-1000
                    $this$any$iv = propertyParameters;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v4 = false;
                    } else {
                        for (E element$iv : $this$any$iv) {
                            it = (KtParameter)element$iv;
                            $i$a$-any-UseDataClass$visitKlass$containsVars$2 = false;
                            if (!it.isMutable()) continue;
                            v4 = true;
                            break block23;
                        }
                        v4 = false;
                    }
                }
                if (v4) lbl-1000:
                // 2 sources

                {
                    v5 = true;
                } else {
                    v5 = false;
                }
                containsVars = v5;
                $this$any$iv = properties;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v6 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (KtProperty)element$iv;
                        $i$a$-any-UseDataClass$visitKlass$containsDelegatedProperty$1 = false;
                        if (!it.hasDelegate()) continue;
                        v6 = true;
                        break block24;
                    }
                    v6 = containsDelegatedProperty = false;
                }
            }
            if (containsFunctions && containsPropertyOrPropertyParameters && !containsDelegatedProperty) {
                if (this.allowVars && containsVars) {
                    return;
                }
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)klass), (int)0, (int)2, null), "The class " + klass.getNameAsSafeName() + " defines no " + "functionality and only holds data. Consider converting it to a data class.", null, null, 24, null));
            }
        }
    }

    private final boolean isIncorrectClassType(KtClass klass) {
        return klass.isData() || klass.isEnum() || klass.isAnnotation() || klass.isSealed() || KtModifierListKt.isInline((KtModifierListOwner)klass);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasOnlyPrivateConstructors(KtClass klass) {
        KtSecondaryConstructor it;
        KtPrimaryConstructor primaryConstructor = klass.getPrimaryConstructor();
        if (primaryConstructor != null) {
            if (!KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)primaryConstructor))) return false;
        }
        Iterable $this$all$iv = klass.getSecondaryConstructors();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (KtSecondaryConstructor)element$iv;
            boolean bl = false;
        } while (KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)it)));
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtParameter> extractConstructorPropertyParameters(@NotNull KtClass $this$extractConstructorPropertyParameters) {
        List list;
        Object object = $this$extractConstructorPropertyParameters.getPrimaryConstructorParameterList();
        if (object != null && (object = object.getParameters()) != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)object;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtParameter it = (KtParameter)element$iv$iv;
                boolean bl = false;
                KtParameter ktParameter = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"it");
                if (!KtPsiUtilKt.isPropertyParameter((KtParameter)ktParameter)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List list2 = list;
        boolean bl = false;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    public UseDataClass(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("UseDataClass", Severity.Style, "Classes that do nothing but hold data should be replaced with a data class.", Debt.Companion.getFIVE_MINS());
        this.excludeAnnotatedClasses = new SplitPattern((String)this.valueOrDefault(EXCLUDE_ANNOTATED_CLASSES, ""), null, false, 6, null);
        this.defaultFunctionNames = SetsKt.hashSetOf((Object[])new String[]{"hashCode", "equals", "toString", "copy"});
        this.allowVars = (Boolean)this.valueOrDefault(ALLOW_VARS, false);
    }

    public /* synthetic */ UseDataClass(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public UseDataClass() {
        this(null, 1, null);
    }

    public static final /* synthetic */ void access$visitKlass(UseDataClass $this, KtClass klass, AnnotationExcluder annotationExcluder) {
        $this.visitKlass(klass, annotationExcluder);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UseDataClass$Companion;", "", "()V", "ALLOW_VARS", "", "EXCLUDE_ANNOTATED_CLASSES", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

