/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\n2\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UtilityClassWithPublicConstructor;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "canBeCheckedForUtilityClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "hasOnlyUtilityClassMembers", "declarations", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "isCompanionObject", "declaration", "visitClass", "", "UtilityClassConstructor", "detekt-rules"})
public final class UtilityClassWithPublicConstructor
extends Rule {
    @NotNull
    private final Issue issue;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkParameterIsNotNull((Object)klass, (String)"klass");
        if (this.canBeCheckedForUtilityClass(klass)) {
            List declarations;
            UtilityClassConstructor utilityClassConstructor = new UtilityClassConstructor(klass);
            KtClassBody ktClassBody = klass.getBody();
            List list = declarations = ktClassBody != null ? ktClassBody.getDeclarations() : null;
            if (this.hasOnlyUtilityClassMembers(declarations)) {
                if (utilityClassConstructor.hasPublicConstructorWithoutParameters$detekt_rules()) {
                    this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)klass), (int)0, (int)2, null), "The class " + klass.getNameAsSafeName() + " only contains" + " utility functions. Consider defining it as an object.", null, null, 24, null));
                } else if (KtModifierListKt.isOpen((KtModifierListOwner)klass) && utilityClassConstructor.hasNonPublicConstructorWithoutParameters$detekt_rules()) {
                    this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)klass), (int)0, (int)2, null), "The utility class " + klass.getNameAsSafeName() + " should be final.", null, null, 24, null));
                }
            }
        }
        super.visitClass(klass);
    }

    private final boolean canBeCheckedForUtilityClass(KtClass klass) {
        return !klass.isInterface() && !CollectionsKt.any((Iterable)klass.getSuperTypeListEntries()) && !klass.isAnnotation() && !klass.isSealed();
    }

    private final boolean hasOnlyUtilityClassMembers(List<? extends KtDeclaration> declarations) {
        if (declarations == null || declarations.isEmpty()) {
            return false;
        }
        boolean containsCompanionObject = false;
        boolean isUtilityClassCandidate = true;
        Iterable $this$forEach$iv = declarations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtDeclaration it = (KtDeclaration)element$iv;
            boolean bl = false;
            if (this.isCompanionObject(it)) {
                containsCompanionObject = true;
                continue;
            }
            if (it instanceof KtSecondaryConstructor || it instanceof KtClassInitializer) continue;
            isUtilityClassCandidate = false;
        }
        return containsCompanionObject && isUtilityClassCandidate;
    }

    private final boolean isCompanionObject(KtDeclaration declaration) {
        KtDeclaration ktDeclaration = declaration;
        if (!(ktDeclaration instanceof KtObjectDeclaration)) {
            ktDeclaration = null;
        }
        KtObjectDeclaration ktObjectDeclaration = (KtObjectDeclaration)ktDeclaration;
        return ktObjectDeclaration != null && ktObjectDeclaration.isCompanion();
    }

    public UtilityClassWithPublicConstructor(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "The class declaration is unnecessary because it only contains utility functions. An object declaration should be used instead.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UtilityClassWithPublicConstructor(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public UtilityClassWithPublicConstructor() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002J\r\u0010\b\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\tJ\r\u0010\n\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UtilityClassWithPublicConstructor$UtilityClassConstructor;", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "(Lorg/jetbrains/kotlin/psi/KtClass;)V", "hasConstructorWithoutParameters", "", "publicModifier", "hasNonPublicConstructorWithoutParameters", "hasNonPublicConstructorWithoutParameters$detekt_rules", "hasPublicConstructorWithoutParameters", "hasPublicConstructorWithoutParameters$detekt_rules", "detekt-rules"})
    public static final class UtilityClassConstructor {
        private final KtClass klass;

        public final boolean hasPublicConstructorWithoutParameters$detekt_rules() {
            return this.hasConstructorWithoutParameters(true);
        }

        public final boolean hasNonPublicConstructorWithoutParameters$detekt_rules() {
            return this.hasConstructorWithoutParameters(false);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean hasConstructorWithoutParameters(boolean publicModifier) {
            boolean bl;
            KtPrimaryConstructor primaryConstructor = this.klass.getPrimaryConstructor();
            if (primaryConstructor != null) {
                if (KtPsiUtilKt.isPublic((KtModifierListOwner)((KtModifierListOwner)primaryConstructor)) != publicModifier) return false;
                if (!primaryConstructor.getValueParameters().isEmpty()) return false;
                return true;
            }
            List secondaryConstructors = this.klass.getSecondaryConstructors();
            if (secondaryConstructors.isEmpty()) return true;
            Iterable $this$any$iv = secondaryConstructors;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                KtSecondaryConstructor it = (KtSecondaryConstructor)element$iv;
                boolean bl2 = false;
                if (KtPsiUtilKt.isPublic((KtModifierListOwner)((KtModifierListOwner)it)) == publicModifier && it.getValueParameters().isEmpty()) {
                    return true;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        public UtilityClassConstructor(@NotNull KtClass klass) {
            Intrinsics.checkParameterIsNotNull((Object)klass, (String)"klass");
            this.klass = klass;
        }
    }
}

