/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.test.utils;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003\u00a8\u0006\u0006"}, d2={"createTempDirectoryForTest", "Ljava/nio/file/Path;", "prefix", "", "createTempFileForTest", "suffix", "detekt-test-utils"})
public final class FileExtensionKt {
    @NotNull
    public static final Path createTempFileForTest(@NotNull String prefix, @NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Path path = Files.createTempFile(prefix, suffix, new FileAttribute[0]);
        path.toFile().deleteOnExit();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        return path;
    }

    @NotNull
    public static final Path createTempDirectoryForTest(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Path dir = Files.createTempDirectory(prefix, new FileAttribute[0]);
        dir.toFile().deleteOnExit();
        Intrinsics.checkNotNullExpressionValue((Object)dir, (String)"dir");
        return dir;
    }
}

