/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.test.utils;

import io.github.detekt.test.utils.KotlinScriptEnginePool;
import io.github.detekt.test.utils.KotlinScriptException;
import io.github.detekt.test.utils.PooledScriptEngine;
import javax.script.ScriptException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.util.KotlinFrontEndException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0007\u001a\u00020\u0004*\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\t"}, d2={"Lio/github/detekt/test/utils/KotlinScriptEngine;", "", "()V", "compile", "", "code", "", "compileWithRetryOnFrontendException", "Lio/github/detekt/test/utils/PooledScriptEngine;", "detekt-test-utils"})
public final class KotlinScriptEngine {
    @NotNull
    public static final KotlinScriptEngine INSTANCE = new KotlinScriptEngine();

    private KotlinScriptEngine() {
    }

    public final void compile(@Language(value="kotlin") @NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this.compileWithRetryOnFrontendException(KotlinScriptEnginePool.INSTANCE.borrowEngine(), code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void compileWithRetryOnFrontendException(PooledScriptEngine $this$compileWithRetryOnFrontendException, String code) {
        try {
            $this$compileWithRetryOnFrontendException.compile(code);
        }
        catch (KotlinFrontEndException _) {
            String string = "w: Kotlin compiler exception detected. This is most likely caused by a name clash with previously compiled snippets";
            System.out.println((Object)string);
            this.compileWithRetryOnFrontendException(KotlinScriptEnginePool.INSTANCE.borrowNewEngine(), code);
        }
        catch (ScriptException e) {
            throw new KotlinScriptException(e);
        }
        finally {
            KotlinScriptEnginePool.INSTANCE.returnEngine($this$compileWithRetryOnFrontendException);
        }
    }
}

