/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.test.utils;

import io.github.detekt.test.utils.PooledScriptEngine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.environment.UtilKt;
import org.jetbrains.kotlin.script.jsr223.KotlinJsr223JvmLocalScriptEngine;
import org.jetbrains.kotlin.script.jsr223.KotlinJsr223JvmLocalScriptEngineFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0005J\u0006\u0010\u0007\u001a\u00020\u0005J\b\u0010\b\u001a\u00020\u0005H\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/github/detekt/test/utils/KotlinScriptEnginePool;", "", "()V", "availableEngines", "", "Lio/github/detekt/test/utils/PooledScriptEngine;", "borrowEngine", "borrowNewEngine", "createEngine", "returnEngine", "", "engine", "detekt-test-utils"})
public final class KotlinScriptEnginePool {
    @NotNull
    public static final KotlinScriptEnginePool INSTANCE = new KotlinScriptEnginePool();
    @NotNull
    private static final List<PooledScriptEngine> availableEngines;

    private KotlinScriptEnginePool() {
    }

    @NotNull
    public final PooledScriptEngine borrowEngine() {
        PooledScriptEngine pooledScriptEngine = (PooledScriptEngine)CollectionsKt.removeFirstOrNull(availableEngines);
        if (pooledScriptEngine == null) {
            pooledScriptEngine = this.createEngine();
        }
        return pooledScriptEngine;
    }

    @NotNull
    public final PooledScriptEngine borrowNewEngine() {
        return this.createEngine();
    }

    public final void returnEngine(@NotNull PooledScriptEngine engine) {
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        availableEngines.add(engine);
    }

    private final PooledScriptEngine createEngine() {
        UtilKt.setIdeaIoUseFallback();
        ScriptEngine scriptEngine = new KotlinJsr223JvmLocalScriptEngineFactory().getScriptEngine();
        KotlinJsr223JvmLocalScriptEngine kotlinJsr223JvmLocalScriptEngine = scriptEngine instanceof KotlinJsr223JvmLocalScriptEngine ? (KotlinJsr223JvmLocalScriptEngine)scriptEngine : null;
        if (kotlinJsr223JvmLocalScriptEngine == null) {
            throw new IllegalStateException("Kotlin script engine not supported".toString());
        }
        KotlinJsr223JvmLocalScriptEngine engine = kotlinJsr223JvmLocalScriptEngine;
        return new PooledScriptEngine(engine);
    }

    static {
        List list = Collections.synchronizedList(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(mutableListOf())");
        availableEngines = list;
    }
}

