/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.test.utils;

import io.github.detekt.parser.KtCompiler;
import io.github.detekt.test.utils.KotlinCoreEnvironmentWrapper;
import io.github.detekt.test.utils.KtTestCompiler;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.CharRange;
import kotlinx.coroutines.CoroutineScope;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u001a\u0010\f\u001a\u00020\n2\b\b\u0001\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000eJ&\u0010\u0010\u001a\u00020\u00112\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\b\u0010\u0016\u001a\u00020\u0014H\u0002J\b\u0010\u0017\u001a\u00020\u0014H\u0002J\u0006\u0010\u0018\u001a\u00020\u0019R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lio/github/detekt/test/utils/KtTestCompiler;", "Lio/github/detekt/parser/KtCompiler;", "()V", "root", "Ljava/nio/file/Path;", "getRoot", "()Ljava/nio/file/Path;", "root$delegate", "Lkotlin/Lazy;", "compile", "Lorg/jetbrains/kotlin/psi/KtFile;", "path", "compileFromContent", "content", "", "filename", "createEnvironment", "Lio/github/detekt/test/utils/KotlinCoreEnvironmentWrapper;", "additionalRootPaths", "", "Ljava/io/File;", "additionalJavaSourceRootPaths", "kotlinStdLibPath", "kotlinxCoroutinesCorePath", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "detekt-test-utils"})
public final class KtTestCompiler
extends KtCompiler {
    @NotNull
    public static final KtTestCompiler INSTANCE = new KtTestCompiler();
    @NotNull
    private static final Lazy root$delegate = LazyKt.lazy((Function0)root.2.INSTANCE);

    private KtTestCompiler() {
        super(null, 1, null);
    }

    private final Path getRoot() {
        Lazy lazy = root$delegate;
        return (Path)lazy.getValue();
    }

    @NotNull
    public final KtFile compile(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.compile(this.getRoot(), path);
    }

    @NotNull
    public final KtFile compileFromContent(@Language(value="kotlin") @NotNull String content, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        KtPsiFactory ktPsiFactory = this.getPsiFileFactory();
        String string = StringUtilRt.convertLineSeparators((String)content);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(content)");
        return ktPsiFactory.createPhysicalFile(filename, string);
    }

    public static /* synthetic */ KtFile compileFromContent$default(KtTestCompiler ktTestCompiler, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "Test.kt";
        }
        return ktTestCompiler.compileFromContent(string, string2);
    }

    @NotNull
    public final KotlinCoreEnvironmentWrapper createEnvironment(@NotNull List<? extends File> additionalRootPaths, @NotNull List<? extends File> additionalJavaSourceRootPaths) {
        CompilerConfiguration compilerConfiguration;
        Intrinsics.checkNotNullParameter(additionalRootPaths, (String)"additionalRootPaths");
        Intrinsics.checkNotNullParameter(additionalJavaSourceRootPaths, (String)"additionalJavaSourceRootPaths");
        CompilerConfiguration configuration = new CompilerConfiguration();
        configuration.put(CommonConfigurationKeys.MODULE_NAME, (Object)"test_module");
        configuration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, (Object)MessageCollector.Companion.getNONE());
        CompilerConfiguration $this$createEnvironment_u24lambda_u2d0 = compilerConfiguration = configuration;
        boolean bl = false;
        JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)$this$createEnvironment_u24lambda_u2d0, (File)INSTANCE.kotlinStdLibPath());
        JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)$this$createEnvironment_u24lambda_u2d0, (File)INSTANCE.kotlinxCoroutinesCorePath());
        JvmContentRootsKt.addJvmClasspathRoots((CompilerConfiguration)$this$createEnvironment_u24lambda_u2d0, additionalRootPaths);
        JvmContentRootsKt.addJavaSourceRoots$default((CompilerConfiguration)$this$createEnvironment_u24lambda_u2d0, additionalJavaSourceRootPaths, null, (int)2, null);
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable()");
        Disposable parentDisposable = disposable;
        KotlinCoreEnvironment kotlinCoreEnvironment = KotlinCoreEnvironment.Companion.createForTests(parentDisposable, configuration, EnvironmentConfigFiles.JVM_CONFIG_FILES);
        return new KotlinCoreEnvironmentWrapper(kotlinCoreEnvironment, parentDisposable);
    }

    public static /* synthetic */ KotlinCoreEnvironmentWrapper createEnvironment$default(KtTestCompiler ktTestCompiler, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return ktTestCompiler.createEnvironment(list, list2);
    }

    @NotNull
    public final Project project() {
        return this.getEnvironment().getProject();
    }

    private final File kotlinStdLibPath() {
        return new File(CharRange.class.getProtectionDomain().getCodeSource().getLocation().getPath());
    }

    private final File kotlinxCoroutinesCorePath() {
        return new File(CoroutineScope.class.getProtectionDomain().getCodeSource().getLocation().getPath());
    }
}

